/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.engine;

import com.caoccao.javet.enums.JSRuntimeType;
import com.caoccao.javet.interfaces.IJavetLogger;
import com.caoccao.javet.interop.engine.JavetEnginePool;
import com.caoccao.javet.utils.JavetDefaultLogger;
import com.caoccao.javet.utils.JavetOSUtils;
import java.util.Objects;
import java.util.concurrent.ExecutorService;

public final class JavetEngineConfig {
    public static final int DEFAULT_ENGINE_GUARD_TIMEOUT_MILLIS = 30000;
    public static final int DEFAULT_ENGINE_GUARD_CHECK_INTERVAL_MILLIS = 1000;
    public static final JSRuntimeType DEFAULT_JS_RUNTIME_TYPE = JSRuntimeType.V8;
    public static final int DEFAULT_POOL_MIN_SIZE = 1;
    public static final int DEFAULT_POOL_IDLE_TIMEOUT_SECONDS = 60;
    public static final int DEFAULT_POOL_DAEMON_CHECK_INTERVAL_MILLIS = 1000;
    public static final int DEFAULT_RESET_ENGINE_TIMEOUT_SECONDS = 3600;
    public static final int DEFAULT_POOL_SHUTDOWN_TIMEOUT_SECONDS = 5;
    public static IJavetLogger DEFAULT_JAVET_LOGGER = new JavetDefaultLogger(JavetEnginePool.class.getName());
    private boolean allowEval;
    private boolean autoSendGCNotification;
    private int defaultEngineGuardTimeoutMillis;
    private int engineGuardCheckIntervalMillis;
    private ExecutorService executorService;
    private boolean gcBeforeEngineClose;
    private String globalName;
    private IJavetLogger javetLogger;
    private JSRuntimeType jsRuntimeType;
    private int poolDaemonCheckIntervalMillis;
    private int poolIdleTimeoutSeconds;
    private int poolMaxSize;
    private int poolMinSize;
    private int poolShutdownTimeoutSeconds;
    private int resetEngineTimeoutSeconds;

    public JavetEngineConfig() {
        this.reset();
    }

    public int getDefaultEngineGuardTimeoutMillis() {
        return this.defaultEngineGuardTimeoutMillis;
    }

    public int getEngineGuardCheckIntervalMillis() {
        return this.engineGuardCheckIntervalMillis;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public String getGlobalName() {
        return this.globalName;
    }

    public JSRuntimeType getJSRuntimeType() {
        return this.jsRuntimeType;
    }

    public IJavetLogger getJavetLogger() {
        return this.javetLogger;
    }

    public int getPoolDaemonCheckIntervalMillis() {
        return this.poolDaemonCheckIntervalMillis;
    }

    public int getPoolIdleTimeoutSeconds() {
        return this.poolIdleTimeoutSeconds;
    }

    public int getPoolMaxSize() {
        return this.poolMaxSize;
    }

    public int getPoolMinSize() {
        return this.poolMinSize;
    }

    public int getPoolShutdownTimeoutSeconds() {
        return this.poolShutdownTimeoutSeconds;
    }

    public int getResetEngineTimeoutSeconds() {
        return this.resetEngineTimeoutSeconds;
    }

    public boolean isAllowEval() {
        return this.allowEval;
    }

    public boolean isAutoSendGCNotification() {
        return this.autoSendGCNotification;
    }

    public boolean isGcBeforeEngineClose() {
        return this.gcBeforeEngineClose;
    }

    public JavetEngineConfig reset() {
        this.javetLogger = DEFAULT_JAVET_LOGGER;
        this.globalName = null;
        this.allowEval = false;
        this.autoSendGCNotification = true;
        this.defaultEngineGuardTimeoutMillis = 30000;
        this.engineGuardCheckIntervalMillis = 1000;
        this.gcBeforeEngineClose = false;
        this.jsRuntimeType = DEFAULT_JS_RUNTIME_TYPE;
        int cpuCount = JavetOSUtils.getCPUCount();
        this.poolMinSize = Math.max(1, cpuCount >> 1);
        this.poolMaxSize = Math.max(1, cpuCount);
        this.poolIdleTimeoutSeconds = 60;
        this.poolShutdownTimeoutSeconds = 5;
        this.poolDaemonCheckIntervalMillis = 1000;
        this.resetEngineTimeoutSeconds = 3600;
        return this;
    }

    public JavetEngineConfig setAllowEval(boolean allowEval) {
        this.allowEval = allowEval;
        return this;
    }

    public JavetEngineConfig setAutoSendGCNotification(boolean autoSendGCNotification) {
        this.autoSendGCNotification = autoSendGCNotification;
        return this;
    }

    public JavetEngineConfig setDefaultEngineGuardTimeoutMillis(int defaultEngineGuardTimeoutMillis) {
        this.defaultEngineGuardTimeoutMillis = defaultEngineGuardTimeoutMillis;
        return this;
    }

    public JavetEngineConfig setEngineGuardCheckIntervalMillis(int engineGuardCheckIntervalMillis) {
        this.engineGuardCheckIntervalMillis = engineGuardCheckIntervalMillis;
        return this;
    }

    JavetEngineConfig setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public JavetEngineConfig setGcBeforeEngineClose(boolean gcBeforeEngineClose) {
        this.gcBeforeEngineClose = gcBeforeEngineClose;
        return this;
    }

    public JavetEngineConfig setGlobalName(String globalName) {
        this.globalName = globalName;
        return this;
    }

    public JavetEngineConfig setJSRuntimeType(JSRuntimeType jsRuntimeType) {
        Objects.requireNonNull(jsRuntimeType);
        this.jsRuntimeType = jsRuntimeType;
        return this;
    }

    public JavetEngineConfig setJavetLogger(IJavetLogger javetLogger) {
        Objects.requireNonNull(javetLogger);
        this.javetLogger = javetLogger;
        return this;
    }

    public JavetEngineConfig setPoolDaemonCheckIntervalMillis(int poolDaemonCheckIntervalMillis) {
        this.poolDaemonCheckIntervalMillis = poolDaemonCheckIntervalMillis;
        return this;
    }

    public JavetEngineConfig setPoolIdleTimeoutSeconds(int poolIdleTimeoutSeconds) {
        this.poolIdleTimeoutSeconds = poolIdleTimeoutSeconds;
        return this;
    }

    public JavetEngineConfig setPoolMaxSize(int poolMaxSize) {
        this.poolMaxSize = poolMaxSize;
        return this;
    }

    public JavetEngineConfig setPoolMinSize(int poolMinSize) {
        this.poolMinSize = poolMinSize;
        return this;
    }

    public JavetEngineConfig setPoolShutdownTimeoutSeconds(int poolShutdownTimeoutSeconds) {
        this.poolShutdownTimeoutSeconds = poolShutdownTimeoutSeconds;
        return this;
    }

    public JavetEngineConfig setResetEngineTimeoutSeconds(int resetEngineTimeoutSeconds) {
        this.resetEngineTimeoutSeconds = resetEngineTimeoutSeconds;
        return this;
    }
}

