/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.converters;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.V8Scope;
import com.caoccao.javet.interop.callback.JavetCallbackContext;
import com.caoccao.javet.interop.converters.JavetObjectConverter;
import com.caoccao.javet.interop.proxy.JavetUniversalProxyHandler;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.IV8ValueObject;
import com.caoccao.javet.values.reference.V8ValueFunction;
import com.caoccao.javet.values.reference.V8ValueProxy;
import java.util.List;

public class JavetProxyConverter
extends JavetObjectConverter {
    protected static final String DUMMY_FUNCTION_STRING = "(() => {\n  const DummyFunction = function () { };\n  return DummyFunction;\n})();";

    @Override
    protected <T extends V8Value> T toV8Value(V8Runtime v8Runtime, Object object, int depth) throws JavetException {
        Object v8Value = super.toV8Value(v8Runtime, object, depth);
        if (v8Value != null && !v8Value.isUndefined()) {
            return v8Value;
        }
        boolean classMode = false;
        if (object instanceof Class) {
            classMode = JavetUniversalProxyHandler.isClassMode((Class)object);
        }
        try (V8Scope v8Scope = v8Runtime.getV8Scope();){
            V8ValueProxy v8ValueProxy;
            Throwable throwable;
            if (classMode) {
                throwable = null;
                try (V8ValueFunction v8ValueFunction = v8Runtime.createV8ValueFunction(DUMMY_FUNCTION_STRING);){
                    v8ValueProxy = v8Scope.createV8ValueProxy(v8ValueFunction);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            } else {
                v8ValueProxy = v8Scope.createV8ValueProxy();
            }
            throwable = null;
            try (IV8ValueObject iV8ValueObjectHandler = v8ValueProxy.getHandler();){
                JavetUniversalProxyHandler<Object> javetUniversalProxyHandler = new JavetUniversalProxyHandler<Object>(v8Runtime, object);
                List<JavetCallbackContext> javetCallbackContexts = iV8ValueObjectHandler.bind(javetUniversalProxyHandler);
                iV8ValueObjectHandler.setPrivateProperty("Javet#proxyTarget", javetCallbackContexts.get(0).getHandle());
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            v8Value = v8ValueProxy;
            v8Scope.setEscapable();
        }
        return (T)((V8Value)v8Runtime.decorateV8Value(v8Value));
    }
}

