/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop.callback;

import com.caoccao.javet.exceptions.JavetError;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.callback.JavetCallbackContext;
import com.caoccao.javet.interop.converters.IJavetConverter;
import com.caoccao.javet.interop.converters.JavetConverterConfig;
import com.caoccao.javet.utils.JavetReflectionUtils;
import com.caoccao.javet.utils.JavetResourceUtils;
import com.caoccao.javet.utils.JavetTypeUtils;
import com.caoccao.javet.utils.SimpleMap;
import com.caoccao.javet.values.IV8Value;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.V8ValueArray;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public final class V8FunctionCallback {
    private static final String NULL = "null";

    private static Object convert(IJavetConverter converter, Class<?> expectedClass, V8Value v8Value) throws JavetException {
        if (v8Value == null) {
            if (expectedClass.isPrimitive()) {
                JavetConverterConfig<?> config = converter.getConfig();
                if (expectedClass == Integer.TYPE) {
                    return config.getDefaultInt();
                }
                if (expectedClass == Boolean.TYPE) {
                    return config.getDefaultBoolean();
                }
                if (expectedClass == Double.TYPE) {
                    return config.getDefaultDouble();
                }
                if (expectedClass == Float.TYPE) {
                    return Float.valueOf(config.getDefaultFloat());
                }
                if (expectedClass == Long.TYPE) {
                    return config.getDefaultLong();
                }
                if (expectedClass == Short.TYPE) {
                    return config.getDefaultShort();
                }
                if (expectedClass == Byte.TYPE) {
                    return config.getDefaultByte();
                }
                if (expectedClass == Character.TYPE) {
                    return Character.valueOf(config.getDefaultChar());
                }
            } else {
                if (expectedClass == Optional.class) {
                    return Optional.empty();
                }
                if (expectedClass == OptionalInt.class) {
                    return OptionalInt.empty();
                }
                if (expectedClass == OptionalDouble.class) {
                    return OptionalDouble.empty();
                }
                if (expectedClass == OptionalLong.class) {
                    return OptionalLong.empty();
                }
                if (expectedClass == Stream.class) {
                    return Stream.empty();
                }
                if (expectedClass == IntStream.class) {
                    return IntStream.empty();
                }
                if (expectedClass == DoubleStream.class) {
                    return DoubleStream.empty();
                }
                if (expectedClass == LongStream.class) {
                    return LongStream.empty();
                }
            }
        } else if (!expectedClass.isAssignableFrom(v8Value.getClass())) {
            Object convertedObject = converter.toObject(v8Value);
            try {
                if (convertedObject == null) {
                    return V8FunctionCallback.convert(converter, expectedClass, null);
                }
                Class<?> convertedObjectClass = convertedObject.getClass();
                if (expectedClass.isAssignableFrom(convertedObjectClass)) {
                    return convertedObject;
                }
                if (expectedClass.isPrimitive()) {
                    if (expectedClass == Integer.TYPE) {
                        if (convertedObjectClass == Integer.class) {
                            return (int)((Integer)convertedObject);
                        }
                        if (convertedObjectClass == Long.class) {
                            return ((Long)convertedObject).intValue();
                        }
                        if (convertedObjectClass == Short.class) {
                            return ((Short)convertedObject).intValue();
                        }
                        if (convertedObjectClass == Byte.class) {
                            return ((Byte)convertedObject).intValue();
                        }
                    } else {
                        if (expectedClass == Boolean.TYPE && convertedObjectClass == Boolean.class) {
                            return (boolean)((Boolean)convertedObject);
                        }
                        if (expectedClass == Double.TYPE) {
                            if (convertedObjectClass == Double.class) {
                                return (double)((Double)convertedObject);
                            }
                            if (convertedObjectClass == Float.class) {
                                return ((Float)convertedObject).doubleValue();
                            }
                            if (convertedObjectClass == Integer.class) {
                                return ((Integer)convertedObject).doubleValue();
                            }
                            if (convertedObjectClass == Long.class) {
                                return ((Long)convertedObject).doubleValue();
                            }
                            if (convertedObjectClass == Short.class) {
                                return ((Short)convertedObject).doubleValue();
                            }
                            if (convertedObjectClass == Byte.class) {
                                return ((Byte)convertedObject).doubleValue();
                            }
                        } else if (expectedClass == Float.TYPE) {
                            if (convertedObjectClass == Double.class) {
                                return Float.valueOf(((Double)convertedObject).floatValue());
                            }
                            if (convertedObjectClass == Float.class) {
                                return Float.valueOf(((Float)convertedObject).floatValue());
                            }
                            if (convertedObjectClass == Integer.class) {
                                return Float.valueOf(((Integer)convertedObject).floatValue());
                            }
                            if (convertedObjectClass == Long.class) {
                                return Float.valueOf(((Long)convertedObject).floatValue());
                            }
                            if (convertedObjectClass == Short.class) {
                                return Float.valueOf(((Short)convertedObject).floatValue());
                            }
                            if (convertedObjectClass == Byte.class) {
                                return Float.valueOf(((Byte)convertedObject).floatValue());
                            }
                        } else if (expectedClass == Long.TYPE) {
                            if (convertedObjectClass == Long.class) {
                                return (long)((Long)convertedObject);
                            }
                            if (convertedObjectClass == Integer.class) {
                                return ((Integer)convertedObject).longValue();
                            }
                            if (convertedObjectClass == Short.class) {
                                return ((Short)convertedObject).longValue();
                            }
                            if (convertedObjectClass == Byte.class) {
                                return ((Byte)convertedObject).longValue();
                            }
                        } else if (expectedClass == Short.TYPE) {
                            if (convertedObjectClass == Short.class) {
                                return (short)((Short)convertedObject);
                            }
                            if (convertedObjectClass == Integer.class) {
                                return ((Integer)convertedObject).shortValue();
                            }
                            if (convertedObjectClass == Long.class) {
                                return ((Long)convertedObject).shortValue();
                            }
                            if (convertedObjectClass == Byte.class) {
                                return ((Byte)convertedObject).shortValue();
                            }
                        } else if (expectedClass == Byte.TYPE) {
                            if (convertedObjectClass == Byte.class) {
                                return (byte)((Byte)convertedObject);
                            }
                            if (convertedObjectClass == Integer.class) {
                                return ((Integer)convertedObject).byteValue();
                            }
                            if (convertedObjectClass == Long.class) {
                                return ((Long)convertedObject).byteValue();
                            }
                            if (convertedObjectClass == Short.class) {
                                return ((Short)convertedObject).byteValue();
                            }
                        } else if (expectedClass == Character.TYPE) {
                            if (convertedObjectClass == Character.class) {
                                return Character.valueOf(((Character)convertedObject).charValue());
                            }
                            if (convertedObjectClass == String.class) {
                                String convertedString = (String)convertedObject;
                                return Character.valueOf(convertedString.length() > 0 ? convertedString.charAt(0) : converter.getConfig().getDefaultChar());
                            }
                        }
                    }
                } else if (expectedClass == Integer.class) {
                    if (convertedObjectClass == Long.class) {
                        return ((Long)convertedObject).intValue();
                    }
                    if (convertedObjectClass == Short.class) {
                        return ((Short)convertedObject).intValue();
                    }
                    if (convertedObjectClass == Byte.class) {
                        return ((Byte)convertedObject).intValue();
                    }
                } else if (expectedClass == Double.class) {
                    if (convertedObjectClass == Float.class) {
                        return ((Float)convertedObject).doubleValue();
                    }
                    if (convertedObjectClass == Integer.class) {
                        return ((Integer)convertedObject).doubleValue();
                    }
                    if (convertedObjectClass == Long.class) {
                        return ((Long)convertedObject).doubleValue();
                    }
                    if (convertedObjectClass == Short.class) {
                        return ((Short)convertedObject).doubleValue();
                    }
                    if (convertedObjectClass == Byte.class) {
                        return ((Byte)convertedObject).doubleValue();
                    }
                } else if (expectedClass == Float.class) {
                    if (convertedObjectClass == Double.class) {
                        return Float.valueOf(((Double)convertedObject).floatValue());
                    }
                    if (convertedObjectClass == Integer.class) {
                        return Float.valueOf(((Integer)convertedObject).floatValue());
                    }
                    if (convertedObjectClass == Long.class) {
                        return Float.valueOf(((Long)convertedObject).floatValue());
                    }
                    if (convertedObjectClass == Short.class) {
                        return Float.valueOf(((Short)convertedObject).floatValue());
                    }
                    if (convertedObjectClass == Byte.class) {
                        return Float.valueOf(((Byte)convertedObject).floatValue());
                    }
                } else if (expectedClass == Long.class) {
                    if (convertedObjectClass == Integer.class) {
                        return ((Integer)convertedObject).longValue();
                    }
                    if (convertedObjectClass == Short.class) {
                        return ((Short)convertedObject).longValue();
                    }
                    if (convertedObjectClass == Byte.class) {
                        return ((Byte)convertedObject).longValue();
                    }
                } else if (expectedClass == Short.class) {
                    if (convertedObjectClass == Integer.class) {
                        return ((Integer)convertedObject).shortValue();
                    }
                    if (convertedObjectClass == Long.class) {
                        return ((Long)convertedObject).shortValue();
                    }
                    if (convertedObjectClass == Byte.class) {
                        return ((Byte)convertedObject).shortValue();
                    }
                } else if (expectedClass == Byte.class) {
                    if (convertedObjectClass == Integer.class) {
                        return ((Integer)convertedObject).byteValue();
                    }
                    if (convertedObjectClass == Long.class) {
                        return ((Long)convertedObject).byteValue();
                    }
                    if (convertedObjectClass == Short.class) {
                        return ((Short)convertedObject).byteValue();
                    }
                } else if (expectedClass == Character.class) {
                    if (convertedObjectClass == String.class) {
                        String convertedString = (String)convertedObject;
                        return Character.valueOf(convertedString.length() > 0 ? convertedString.charAt(0) : converter.getConfig().getDefaultChar());
                    }
                } else {
                    DoubleStream doubleStream;
                    if (expectedClass == Optional.class) {
                        return Optional.of(convertedObject);
                    }
                    if (expectedClass == OptionalInt.class) {
                        if (convertedObject instanceof Integer) {
                            return OptionalInt.of((Integer)convertedObject);
                        }
                    } else if (expectedClass == OptionalDouble.class) {
                        if (convertedObject instanceof Double) {
                            return OptionalDouble.of((Double)convertedObject);
                        }
                    } else if (expectedClass == OptionalLong.class) {
                        if (convertedObject instanceof Long) {
                            return OptionalLong.of((Long)convertedObject);
                        }
                    } else if (expectedClass == Stream.class) {
                        Stream<?> stream = JavetTypeUtils.toStream(convertedObject);
                        if (stream != null) {
                            return stream;
                        }
                    } else if (expectedClass == IntStream.class) {
                        IntStream intStream = JavetTypeUtils.toIntStream(convertedObject);
                        if (intStream != null) {
                            return intStream;
                        }
                    } else if (expectedClass == LongStream.class) {
                        LongStream longStream = JavetTypeUtils.toLongStream(convertedObject);
                        if (longStream != null) {
                            return longStream;
                        }
                    } else if (expectedClass == DoubleStream.class && (doubleStream = JavetTypeUtils.toDoubleStream(convertedObject)) != null) {
                        return doubleStream;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new JavetException(JavetError.CallbackSignatureParameterTypeMismatch, SimpleMap.of("expectedParameterType", expectedClass, "actualParameterType", convertedObject == null ? NULL : convertedObject.getClass()));
        }
        return v8Value;
    }

    public static V8Value receiveCallback(V8Runtime v8Runtime, JavetCallbackContext javetCallbackContext, V8Value thisObject, V8ValueArray args) throws Throwable {
        if (javetCallbackContext != null) {
            ArrayList<V8Value> values = new ArrayList<V8Value>();
            Object resultObject = null;
            try {
                int length;
                v8Runtime.decorateV8Values(new V8Value[]{thisObject, args});
                IJavetConverter converter = v8Runtime.getConverter();
                Method method = javetCallbackContext.getCallbackMethod();
                JavetReflectionUtils.safeSetAccessible(method);
                Object callbackReceiver = javetCallbackContext.getCallbackReceiver();
                if (javetCallbackContext.isThisObjectRequired()) {
                    values.add(thisObject);
                }
                if (args != null) {
                    length = args.getLength();
                    for (int i = 0; i < length; ++i) {
                        values.add((V8Value)args.get(i));
                    }
                }
                if (values.isEmpty()) {
                    if (method.isVarArgs()) {
                        Class<?>[] parameterTypes = method.getParameterTypes();
                        Class<?> parameterClass = parameterTypes[parameterTypes.length - 1];
                        Object varObject = Array.newInstance(parameterClass.getComponentType(), 0);
                        resultObject = method.invoke(callbackReceiver, varObject);
                    } else {
                        resultObject = method.invoke(callbackReceiver, new Object[0]);
                    }
                } else {
                    int i;
                    length = values.size();
                    ArrayList<Object> objectValues = new ArrayList<Object>();
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    if (method.isVarArgs()) {
                        for (i = 0; i < parameterTypes.length; ++i) {
                            Class<?> parameterClass = parameterTypes[i];
                            if (parameterClass.isArray() && i == parameterTypes.length - 1) {
                                Class<?> componentType = parameterClass.getComponentType();
                                Object varObject = Array.newInstance(componentType, length - i);
                                for (int j = i; j < length; ++j) {
                                    Array.set(varObject, j - i, V8FunctionCallback.convert(converter, componentType, (V8Value)values.get(j)));
                                }
                                objectValues.add(varObject);
                                continue;
                            }
                            objectValues.add(V8FunctionCallback.convert(converter, parameterClass, (V8Value)values.get(i)));
                        }
                    } else {
                        if (method.getParameterCount() != length) {
                            throw new JavetException(JavetError.CallbackSignatureParameterSizeMismatch, SimpleMap.of("methodName", method.getName(), "expectedParameterSize", length, "actualParameterSize", method.getParameterCount()));
                        }
                        for (i = 0; i < parameterTypes.length; ++i) {
                            objectValues.add(V8FunctionCallback.convert(converter, parameterTypes[i], (V8Value)values.get(i)));
                        }
                    }
                    resultObject = method.invoke(callbackReceiver, objectValues.toArray());
                }
                if (javetCallbackContext.isReturnResult()) {
                    if (resultObject instanceof IV8Value) {
                        v8Runtime.decorateV8Value((IV8Value)resultObject);
                    } else {
                        resultObject = v8Runtime.toV8Value(resultObject);
                    }
                    V8Value v8Value = (V8Value)resultObject;
                    return v8Value;
                }
                JavetResourceUtils.safeClose(resultObject);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            finally {
                if (!javetCallbackContext.isThisObjectRequired() && thisObject != resultObject) {
                    JavetResourceUtils.safeClose((Object)thisObject);
                }
                if (args != resultObject) {
                    JavetResourceUtils.safeClose((Object)args);
                }
                for (Object e : values) {
                    if (e == resultObject) continue;
                    JavetResourceUtils.safeClose(e);
                }
            }
        }
        return v8Runtime.createV8ValueUndefined();
    }
}

