/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop;

import com.caoccao.javet.enums.JSFunctionType;
import com.caoccao.javet.enums.JSRuntimeType;
import com.caoccao.javet.enums.JSScopeType;
import com.caoccao.javet.enums.JavetPromiseRejectEvent;
import com.caoccao.javet.enums.V8ValueInternalType;
import com.caoccao.javet.enums.V8ValueReferenceType;
import com.caoccao.javet.exceptions.JavetError;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interfaces.IJavetClosable;
import com.caoccao.javet.interfaces.IJavetLogger;
import com.caoccao.javet.interfaces.IJavetPromiseRejectCallback;
import com.caoccao.javet.interfaces.IV8ModuleResolver;
import com.caoccao.javet.interop.IV8Convertible;
import com.caoccao.javet.interop.IV8Creatable;
import com.caoccao.javet.interop.IV8Native;
import com.caoccao.javet.interop.V8Host;
import com.caoccao.javet.interop.V8Inspector;
import com.caoccao.javet.interop.V8Internal;
import com.caoccao.javet.interop.V8Locker;
import com.caoccao.javet.interop.V8Scope;
import com.caoccao.javet.interop.V8ScriptOrigin;
import com.caoccao.javet.interop.binding.BindingContext;
import com.caoccao.javet.interop.callback.JavetCallbackContext;
import com.caoccao.javet.interop.converters.IJavetConverter;
import com.caoccao.javet.interop.converters.JavetObjectConverter;
import com.caoccao.javet.interop.executors.IV8Executor;
import com.caoccao.javet.interop.executors.V8PathExecutor;
import com.caoccao.javet.interop.executors.V8StringExecutor;
import com.caoccao.javet.interop.monitoring.V8HeapSpaceStatistics;
import com.caoccao.javet.interop.monitoring.V8HeapStatistics;
import com.caoccao.javet.interop.monitoring.V8SharedMemoryStatistics;
import com.caoccao.javet.interop.options.RuntimeOptions;
import com.caoccao.javet.utils.JavetDefaultLogger;
import com.caoccao.javet.utils.JavetPromiseRejectCallback;
import com.caoccao.javet.utils.JavetResourceUtils;
import com.caoccao.javet.values.IV8Value;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.primitive.V8ValueBoolean;
import com.caoccao.javet.values.primitive.V8ValueDouble;
import com.caoccao.javet.values.primitive.V8ValueInteger;
import com.caoccao.javet.values.primitive.V8ValueLong;
import com.caoccao.javet.values.primitive.V8ValueNull;
import com.caoccao.javet.values.primitive.V8ValueString;
import com.caoccao.javet.values.primitive.V8ValueUndefined;
import com.caoccao.javet.values.primitive.V8ValueZonedDateTime;
import com.caoccao.javet.values.reference.IV8Module;
import com.caoccao.javet.values.reference.IV8Script;
import com.caoccao.javet.values.reference.IV8ValueArray;
import com.caoccao.javet.values.reference.IV8ValueFunction;
import com.caoccao.javet.values.reference.IV8ValueKeyContainer;
import com.caoccao.javet.values.reference.IV8ValueObject;
import com.caoccao.javet.values.reference.IV8ValuePromise;
import com.caoccao.javet.values.reference.IV8ValueProxy;
import com.caoccao.javet.values.reference.IV8ValueReference;
import com.caoccao.javet.values.reference.IV8ValueSet;
import com.caoccao.javet.values.reference.IV8ValueTypedArray;
import com.caoccao.javet.values.reference.V8Module;
import com.caoccao.javet.values.reference.V8Script;
import com.caoccao.javet.values.reference.V8ValueArray;
import com.caoccao.javet.values.reference.V8ValueArrayBuffer;
import com.caoccao.javet.values.reference.V8ValueDataView;
import com.caoccao.javet.values.reference.V8ValueError;
import com.caoccao.javet.values.reference.V8ValueFunction;
import com.caoccao.javet.values.reference.V8ValueGlobalObject;
import com.caoccao.javet.values.reference.V8ValueMap;
import com.caoccao.javet.values.reference.V8ValueObject;
import com.caoccao.javet.values.reference.V8ValuePromise;
import com.caoccao.javet.values.reference.V8ValueProxy;
import com.caoccao.javet.values.reference.V8ValueSet;
import com.caoccao.javet.values.reference.V8ValueSymbol;
import com.caoccao.javet.values.reference.V8ValueTypedArray;
import com.caoccao.javet.values.reference.builtin.V8ValueBuiltInSymbol;
import java.io.File;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.IntStream;

public class V8Runtime
implements IJavetClosable,
IV8Creatable,
IV8Convertible {
    protected static final IJavetConverter DEFAULT_CONVERTER = new JavetObjectConverter();
    protected static final String DEFAULT_MESSAGE_FORMAT_JAVET_INSPECTOR = "Javet Inspector {0}";
    protected static final long INVALID_HANDLE = 0L;
    protected static final String PROPERTY_DATA_VIEW = "DataView";
    protected static final int V8_VALUE_BOOLEAN_FALSE_INDEX = 0;
    protected static final int V8_VALUE_BOOLEAN_TRUE_INDEX = 1;
    protected static final int V8_VALUE_NUMBER_LOWER_BOUND = -128;
    protected static final int V8_VALUE_NUMBER_UPPER_BOUND = 128;
    protected Map<Class<?>, BindingContext> bindingContextWeakHashMap;
    protected V8ValueBoolean[] cachedV8ValueBooleans;
    protected V8ValueInteger[] cachedV8ValueIntegers;
    protected V8ValueLong[] cachedV8ValueLongs;
    protected V8ValueNull cachedV8ValueNull;
    protected V8ValueUndefined cachedV8ValueUndefined;
    protected ReadWriteLock callbackContextLock;
    protected Map<Long, JavetCallbackContext> callbackContextMap;
    protected IJavetConverter converter;
    protected boolean gcScheduled;
    protected long handle;
    protected IJavetLogger logger;
    protected boolean pooled;
    protected IJavetPromiseRejectCallback promiseRejectCallback;
    protected ReadWriteLock referenceLock;
    protected Map<Long, IV8ValueReference> referenceMap;
    protected RuntimeOptions<?> runtimeOptions;
    protected V8Host v8Host;
    protected V8Inspector v8Inspector;
    protected V8Internal v8Internal;
    protected ReadWriteLock v8ModuleLock;
    protected Map<String, IV8Module> v8ModuleMap;
    protected IV8ModuleResolver v8ModuleResolver;
    protected IV8Native v8Native;

    V8Runtime(V8Host v8Host, long handle, boolean pooled, IV8Native v8Native, RuntimeOptions<?> runtimeOptions) {
        assert (handle != 0L);
        this.bindingContextWeakHashMap = Collections.synchronizedMap(new WeakHashMap());
        this.callbackContextLock = new ReentrantReadWriteLock();
        this.callbackContextMap = new HashMap<Long, JavetCallbackContext>();
        this.converter = DEFAULT_CONVERTER;
        this.gcScheduled = false;
        this.runtimeOptions = Objects.requireNonNull(runtimeOptions);
        this.handle = handle;
        this.logger = new JavetDefaultLogger(this.getClass().getName());
        this.pooled = pooled;
        this.promiseRejectCallback = new JavetPromiseRejectCallback(this.logger);
        this.referenceLock = new ReentrantReadWriteLock();
        this.referenceMap = new HashMap<Long, IV8ValueReference>();
        this.v8Host = Objects.requireNonNull(v8Host);
        this.v8Inspector = null;
        this.v8Native = Objects.requireNonNull(v8Native);
        this.v8ModuleLock = new ReentrantReadWriteLock();
        this.v8ModuleMap = new HashMap<String, IV8Module>();
        this.v8ModuleResolver = null;
        this.v8Internal = new V8Internal(this);
        this.initializeV8ValueCache();
    }

    void add(IV8ValueSet iV8ValueKeySet, V8Value value) throws JavetException {
        this.decorateV8Value(value);
        this.v8Native.add(this.handle, iV8ValueKeySet.getHandle(), iV8ValueKeySet.getType().getId(), value);
    }

    void addReference(IV8ValueReference iV8ValueReference) {
        Lock readLock = this.referenceLock.readLock();
        try {
            readLock.lock();
            this.referenceMap.put(iV8ValueReference.getHandle(), iV8ValueReference);
        }
        finally {
            readLock.unlock();
        }
    }

    public void addV8Module(IV8Module iV8Module) {
        Lock readLock = this.v8ModuleLock.readLock();
        try {
            readLock.lock();
            this.v8ModuleMap.put(iV8Module.getResourceName(), iV8Module);
        }
        finally {
            readLock.unlock();
        }
    }

    public void allowEval(boolean allow) {
        this.v8Native.allowCodeGenerationFromStrings(this.handle, allow);
    }

    public void await() {
        this.v8Native.await(this.handle);
    }

    <T extends V8Value> T call(IV8ValueObject iV8ValueObject, IV8ValueObject receiver, boolean returnResult, V8Value ... v8Values) throws JavetException {
        this.decorateV8Values(v8Values);
        return (T)this.decorateV8Value((V8Value)this.v8Native.call(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), receiver, returnResult, v8Values));
    }

    <T extends V8Value> T callAsConstructor(IV8ValueObject iV8ValueObject, V8Value ... v8Values) throws JavetException {
        this.decorateV8Values(v8Values);
        return (T)this.decorateV8Value((V8Value)this.v8Native.callAsConstructor(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), v8Values));
    }

    void clearWeak(IV8ValueReference iV8ValueReference) throws JavetException {
        this.v8Native.clearWeak(this.handle, iV8ValueReference.getHandle(), iV8ValueReference.getType().getId());
    }

    <T extends V8Value> T cloneV8Value(IV8ValueReference iV8ValueReference) throws JavetException {
        return (T)this.decorateV8Value((V8Value)this.v8Native.cloneV8Value(this.handle, iV8ValueReference.getHandle(), iV8ValueReference.getType().getId()));
    }

    @Override
    public void close() throws JavetException {
        this.close(!this.pooled);
    }

    public void close(boolean forceClose) throws JavetException {
        if (!this.isClosed() && forceClose) {
            this.removeAllReferences();
            this.v8Host.closeV8Runtime(this);
            this.handle = 0L;
            this.v8Native = null;
        }
    }

    public V8Module compileV8Module(String scriptString, V8ScriptOrigin v8ScriptOrigin, boolean resultRequired) throws JavetException {
        v8ScriptOrigin.setModule(true);
        if (v8ScriptOrigin.getResourceName() == null || v8ScriptOrigin.getResourceName().length() == 0) {
            throw new JavetException(JavetError.ModuleNameEmpty);
        }
        Object result = this.v8Native.compile(this.handle, scriptString, resultRequired, v8ScriptOrigin.getResourceName(), v8ScriptOrigin.getResourceLineOffset(), v8ScriptOrigin.getResourceColumnOffset(), v8ScriptOrigin.getScriptId(), v8ScriptOrigin.isWasm(), v8ScriptOrigin.isModule());
        V8Module v8Module = null;
        if (resultRequired && result instanceof V8Module) {
            v8Module = this.decorateV8Value((V8Module)result);
            v8Module.setResourceName(v8ScriptOrigin.getResourceName());
            this.addV8Module(v8Module);
        }
        return v8Module;
    }

    public V8Script compileV8Script(String scriptString, V8ScriptOrigin v8ScriptOrigin, boolean resultRequired) throws JavetException {
        v8ScriptOrigin.setModule(false);
        return this.decorateV8Value((V8Script)this.v8Native.compile(this.handle, scriptString, resultRequired, v8ScriptOrigin.getResourceName(), v8ScriptOrigin.getResourceLineOffset(), v8ScriptOrigin.getResourceColumnOffset(), v8ScriptOrigin.getScriptId(), v8ScriptOrigin.isWasm(), v8ScriptOrigin.isModule()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsV8Module(String resourceName) {
        Lock readLock = this.v8ModuleLock.readLock();
        try {
            readLock.lock();
            boolean bl = this.v8ModuleMap.containsKey(resourceName);
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public V8ValueArray createV8ValueArray() throws JavetException {
        return this.decorateV8Value((V8ValueArray)this.v8Native.createV8Value(this.handle, V8ValueReferenceType.Array.getId(), null));
    }

    @Override
    public V8ValueArrayBuffer createV8ValueArrayBuffer(int length) throws JavetException {
        return this.decorateV8Value((V8ValueArrayBuffer)this.v8Native.createV8Value(this.handle, V8ValueReferenceType.ArrayBuffer.getId(), this.createV8ValueInteger(length)));
    }

    @Override
    public V8ValueBoolean createV8ValueBoolean(boolean booleanValue) throws JavetException {
        return booleanValue ? this.cachedV8ValueBooleans[1] : this.cachedV8ValueBooleans[0];
    }

    @Override
    public V8ValueDataView createV8ValueDataView(V8ValueArrayBuffer v8ValueArrayBuffer) throws JavetException {
        Objects.requireNonNull(v8ValueArrayBuffer);
        try (V8ValueFunction v8ValueFunction = (V8ValueFunction)this.getGlobalObject().get(PROPERTY_DATA_VIEW);){
            V8ValueDataView v8ValueDataView = (V8ValueDataView)v8ValueFunction.callAsConstructor(v8ValueArrayBuffer);
            return v8ValueDataView;
        }
    }

    @Override
    public V8ValueDouble createV8ValueDouble(double doubleValue) throws JavetException {
        return this.decorateV8Value(new V8ValueDouble(doubleValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V8ValueFunction createV8ValueFunction(JavetCallbackContext javetCallbackContext) throws JavetException {
        Objects.requireNonNull(javetCallbackContext);
        V8ValueFunction v8ValueFunction = this.decorateV8Value((V8ValueFunction)this.v8Native.createV8Value(this.handle, V8ValueReferenceType.Function.getId(), javetCallbackContext));
        Lock writeLock = this.callbackContextLock.writeLock();
        try {
            writeLock.lock();
            this.callbackContextMap.put(javetCallbackContext.getHandle(), javetCallbackContext);
        }
        finally {
            writeLock.unlock();
        }
        return v8ValueFunction;
    }

    @Override
    public V8ValueFunction createV8ValueFunction(String codeString) throws JavetException {
        return (V8ValueFunction)this.getExecutor(codeString).execute();
    }

    @Override
    public V8ValueInteger createV8ValueInteger(int integerValue) throws JavetException {
        if (integerValue >= -128 && integerValue < 128) {
            return this.cachedV8ValueIntegers[integerValue - -128];
        }
        return this.decorateV8Value(new V8ValueInteger(integerValue));
    }

    @Override
    public V8ValueLong createV8ValueLong(long longValue) throws JavetException {
        if (longValue >= -128L && longValue < 128L) {
            return this.cachedV8ValueLongs[(int)longValue - -128];
        }
        return this.decorateV8Value(new V8ValueLong(longValue));
    }

    @Override
    public V8ValueMap createV8ValueMap() throws JavetException {
        return this.decorateV8Value((V8ValueMap)this.v8Native.createV8Value(this.handle, V8ValueReferenceType.Map.getId(), null));
    }

    @Override
    public V8ValueNull createV8ValueNull() {
        return this.cachedV8ValueNull;
    }

    @Override
    public V8ValueObject createV8ValueObject() throws JavetException {
        return this.decorateV8Value((V8ValueObject)this.v8Native.createV8Value(this.handle, V8ValueReferenceType.Object.getId(), null));
    }

    @Override
    public V8ValuePromise createV8ValuePromise() throws JavetException {
        return this.decorateV8Value((V8ValuePromise)this.v8Native.createV8Value(this.handle, V8ValueReferenceType.Promise.getId(), null));
    }

    @Override
    public V8ValueProxy createV8ValueProxy(V8ValueObject v8ValueObject) throws JavetException {
        return this.decorateV8Value((V8ValueProxy)this.v8Native.createV8Value(this.handle, V8ValueReferenceType.Proxy.getId(), v8ValueObject));
    }

    @Override
    public V8ValueSet createV8ValueSet() throws JavetException {
        return this.decorateV8Value((V8ValueSet)this.v8Native.createV8Value(this.handle, V8ValueReferenceType.Set.getId(), null));
    }

    @Override
    public V8ValueString createV8ValueString(String str) throws JavetException {
        return this.decorateV8Value(new V8ValueString(str));
    }

    @Override
    public V8ValueSymbol createV8ValueSymbol(String description, boolean global) throws JavetException {
        Objects.requireNonNull(description);
        assert (description.length() > 0);
        if (global) {
            try (V8ValueBuiltInSymbol v8ValueBuiltInSymbol = this.getGlobalObject().getBuiltInSymbol();){
                V8ValueSymbol v8ValueSymbol = v8ValueBuiltInSymbol._for(description);
                return v8ValueSymbol;
            }
        }
        return this.decorateV8Value((V8ValueSymbol)this.v8Native.createV8Value(this.handle, V8ValueReferenceType.Symbol.getId(), description));
    }

    @Override
    public V8ValueTypedArray createV8ValueTypedArray(V8ValueReferenceType type, int length) throws JavetException {
        try (V8ValueFunction v8ValueFunction = (V8ValueFunction)this.getGlobalObject().get(type.getName());){
            V8ValueTypedArray v8ValueTypedArray = (V8ValueTypedArray)v8ValueFunction.callAsConstructor(length);
            return v8ValueTypedArray;
        }
    }

    @Override
    public V8ValueUndefined createV8ValueUndefined() {
        return this.cachedV8ValueUndefined;
    }

    @Override
    public V8ValueZonedDateTime createV8ValueZonedDateTime(long jsTimestamp) throws JavetException {
        return this.decorateV8Value(new V8ValueZonedDateTime(jsTimestamp));
    }

    @Override
    public V8ValueZonedDateTime createV8ValueZonedDateTime(ZonedDateTime zonedDateTime) throws JavetException {
        return this.decorateV8Value(new V8ValueZonedDateTime(zonedDateTime));
    }

    public <T extends IV8Value> T decorateV8Value(T v8Value) throws JavetException {
        if (v8Value != null) {
            if (v8Value.getV8Runtime() == null) {
                v8Value.setV8Runtime(this);
            } else if (v8Value.getV8Runtime() != this) {
                throw new JavetException(JavetError.RuntimeAlreadyRegistered);
            }
        }
        return v8Value;
    }

    public <T extends IV8Value> int decorateV8Values(T ... v8Values) throws JavetException {
        if (v8Values != null && v8Values.length > 0) {
            for (T v8Value : v8Values) {
                this.decorateV8Value(v8Value);
            }
            return v8Values.length;
        }
        return 0;
    }

    boolean delete(IV8ValueObject iV8ValueObject, V8Value key) throws JavetException {
        this.decorateV8Value(key);
        return this.v8Native.delete(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), key);
    }

    boolean deletePrivateProperty(IV8ValueObject iV8ValueObject, String propertyName) throws JavetException {
        return this.v8Native.deletePrivateProperty(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), propertyName);
    }

    boolean equals(IV8ValueReference iV8ValueReference1, IV8ValueReference iV8ValueReference2) throws JavetException {
        return this.v8Native.equals(this.handle, iV8ValueReference1.getHandle(), iV8ValueReference2.getHandle());
    }

    public <T extends V8Value> T execute(String scriptString, V8ScriptOrigin v8ScriptOrigin, boolean resultRequired) throws JavetException {
        return (T)this.decorateV8Value((V8Value)this.v8Native.execute(this.handle, scriptString, resultRequired, v8ScriptOrigin.getResourceName(), v8ScriptOrigin.getResourceLineOffset(), v8ScriptOrigin.getResourceColumnOffset(), v8ScriptOrigin.getScriptId(), v8ScriptOrigin.isWasm(), v8ScriptOrigin.isModule()));
    }

    <T extends V8Value> T get(IV8ValueObject iV8ValueObject, V8Value key) throws JavetException {
        return (T)this.decorateV8Value((V8Value)this.v8Native.get(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), key));
    }

    public Map<Class<?>, BindingContext> getBindingContextWeakHashMap() {
        return this.bindingContextWeakHashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavetCallbackContext getCallbackContext(long handle) {
        Lock readLock = this.callbackContextLock.readLock();
        try {
            readLock.lock();
            JavetCallbackContext javetCallbackContext = this.callbackContextMap.get(handle);
            return javetCallbackContext;
        }
        finally {
            readLock.unlock();
        }
    }

    public int getCallbackContextCount() {
        Lock readLock = this.callbackContextLock.readLock();
        try {
            readLock.lock();
            int n = this.callbackContextMap.size();
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    public IJavetConverter getConverter() {
        return this.converter;
    }

    public IV8Executor getExecutor(File scriptFile) throws JavetException {
        return this.getExecutor(scriptFile.toPath());
    }

    public IV8Executor getExecutor(Path scriptPath) throws JavetException {
        return new V8PathExecutor(this, scriptPath);
    }

    public IV8Executor getExecutor(String scriptString) {
        return new V8StringExecutor(this, scriptString);
    }

    public V8ValueGlobalObject getGlobalObject() throws JavetException {
        return this.decorateV8Value((V8ValueGlobalObject)this.v8Native.getGlobalObject(this.handle));
    }

    public long getHandle() {
        return this.handle;
    }

    int getIdentityHash(IV8ValueReference iV8ValueReference) throws JavetException {
        return this.v8Native.getIdentityHash(this.handle, iV8ValueReference.getHandle(), iV8ValueReference.getType().getId());
    }

    IV8ValueArray getInternalProperties(IV8ValueFunction iV8ValueFunction) throws JavetException {
        return this.decorateV8Value((V8ValueArray)this.v8Native.getInternalProperties(this.handle, iV8ValueFunction.getHandle(), iV8ValueFunction.getType().getId()));
    }

    JSFunctionType getJSFunctionType(IV8ValueFunction iV8ValueFunction) {
        return JSFunctionType.parse(this.v8Native.getJSFunctionType(this.handle, iV8ValueFunction.getHandle(), iV8ValueFunction.getType().getId()));
    }

    public JSRuntimeType getJSRuntimeType() {
        return JSRuntimeType.V8;
    }

    JSScopeType getJSScopeType(IV8ValueFunction iV8ValueFunction) {
        return JSScopeType.parse(this.v8Native.getJSScopeType(this.handle, iV8ValueFunction.getHandle(), iV8ValueFunction.getType().getId()));
    }

    int getLength(IV8ValueArray iV8ValueArray) throws JavetException {
        return this.v8Native.getLength(this.handle, iV8ValueArray.getHandle(), iV8ValueArray.getType().getId());
    }

    int getLength(IV8ValueTypedArray iV8ValueTypedArray) throws JavetException {
        return this.v8Native.getLength(this.handle, iV8ValueTypedArray.getHandle(), iV8ValueTypedArray.getType().getId());
    }

    public IJavetLogger getLogger() {
        return this.logger;
    }

    IV8ValueArray getOwnPropertyNames(IV8ValueObject iV8ValueObject) throws JavetException {
        return this.decorateV8Value((V8ValueArray)this.v8Native.getOwnPropertyNames(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId()));
    }

    <T extends V8Value> T getPrivateProperty(IV8ValueObject iV8ValueObject, String propertyName) throws JavetException {
        return (T)this.decorateV8Value((V8Value)this.v8Native.getPrivateProperty(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), propertyName));
    }

    public IJavetPromiseRejectCallback getPromiseRejectCallback() {
        return this.promiseRejectCallback;
    }

    <T extends V8Value> T getProperty(IV8ValueObject iV8ValueObject, V8Value key) throws JavetException {
        this.decorateV8Value(key);
        return (T)this.decorateV8Value((V8Value)this.v8Native.getProperty(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), key));
    }

    IV8ValueArray getPropertyNames(IV8ValueObject iV8ValueObject) throws JavetException {
        return this.decorateV8Value((V8ValueArray)this.v8Native.getPropertyNames(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId()));
    }

    <T extends IV8ValueObject> T getPrototype(IV8ValueObject iV8ValueObject) throws JavetException {
        return (T)this.decorateV8Value((IV8ValueObject)this.v8Native.getPrototype(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId()));
    }

    public int getReferenceCount() {
        Lock readLock = this.referenceLock.readLock();
        try {
            readLock.lock();
            int n = this.referenceMap.size();
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    public RuntimeOptions<?> getRuntimeOptions() {
        return this.runtimeOptions;
    }

    int getSize(IV8ValueKeyContainer iV8ValueKeyContainer) throws JavetException {
        return this.v8Native.getSize(this.handle, iV8ValueKeyContainer.getHandle(), iV8ValueKeyContainer.getType().getId());
    }

    String getSourceCode(IV8ValueFunction iV8ValueFunction) throws JavetException {
        return this.v8Native.getSourceCode(this.handle, iV8ValueFunction.getHandle(), iV8ValueFunction.getType().getId());
    }

    public V8HeapSpaceStatistics getV8HeapSpaceStatistics(V8HeapSpaceStatistics.AllocationSpace allocationSpace) {
        Objects.requireNonNull(allocationSpace);
        return ((V8HeapSpaceStatistics)this.v8Native.getV8HeapSpaceStatistics(this.handle, allocationSpace.getIndex())).setAllocationSpace(allocationSpace);
    }

    public V8HeapStatistics getV8HeapStatistics() {
        return (V8HeapStatistics)this.v8Native.getV8HeapStatistics(this.handle);
    }

    public V8Inspector getV8Inspector() {
        return this.getV8Inspector(MessageFormat.format(DEFAULT_MESSAGE_FORMAT_JAVET_INSPECTOR, Long.toString(this.handle)));
    }

    public V8Inspector getV8Inspector(String name) {
        if (this.v8Inspector == null) {
            this.v8Inspector = new V8Inspector(this, name, this.v8Native);
        }
        return this.v8Inspector;
    }

    public V8Internal getV8Internal() {
        return this.v8Internal;
    }

    public V8Locker getV8Locker() throws JavetException {
        return new V8Locker(this, this.v8Native);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IV8Module getV8Module(String resourceName, IV8Module v8ModuleReferrer) throws JavetException {
        if (resourceName != null && resourceName.length() > 0) {
            this.decorateV8Value(v8ModuleReferrer);
            Lock readLock = this.v8ModuleLock.readLock();
            try {
                readLock.lock();
                if (this.v8ModuleMap.containsKey(resourceName)) {
                    IV8Module iV8Module = this.v8ModuleMap.get(resourceName);
                    return iV8Module;
                }
            }
            finally {
                readLock.unlock();
            }
            if (this.v8ModuleResolver != null) {
                return this.v8ModuleResolver.resolve(this, resourceName, v8ModuleReferrer);
            }
        }
        return null;
    }

    public int getV8ModuleCount() {
        Lock readLock = this.v8ModuleLock.readLock();
        try {
            readLock.lock();
            int n = this.v8ModuleMap.size();
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    public IV8ModuleResolver getV8ModuleResolver() {
        return this.v8ModuleResolver;
    }

    public V8Scope getV8Scope() {
        return new V8Scope(this);
    }

    public V8SharedMemoryStatistics getV8SharedMemoryStatistics() {
        return (V8SharedMemoryStatistics)this.v8Native.getV8SharedMemoryStatistics();
    }

    public String getVersion() {
        return this.v8Native.getVersion();
    }

    boolean has(IV8ValueObject iV8ValueObject, V8Value value) throws JavetException {
        this.decorateV8Value(value);
        return this.v8Native.has(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), value);
    }

    boolean hasInternalType(IV8ValueObject iV8ValueObject, V8ValueInternalType internalType) {
        return this.v8Native.hasInternalType(this.handle, iV8ValueObject.getHandle(), Objects.requireNonNull(internalType).getId());
    }

    boolean hasOwnProperty(IV8ValueObject iV8ValueObject, V8Value key) throws JavetException {
        this.decorateV8Value(key);
        return this.v8Native.hasOwnProperty(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), key);
    }

    boolean hasPrivateProperty(IV8ValueObject iV8ValueObject, String propertyName) throws JavetException {
        return this.v8Native.hasPrivateProperty(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), propertyName);
    }

    public void idleNotificationDeadline(long deadlineInMillis) {
        if (!this.isClosed() && deadlineInMillis > 0L) {
            this.v8Native.idleNotificationDeadline(this.handle, deadlineInMillis);
        }
    }

    void initializeV8ValueCache() {
        try {
            this.cachedV8ValueNull = this.decorateV8Value(new V8ValueNull());
            this.cachedV8ValueUndefined = this.decorateV8Value(new V8ValueUndefined());
            this.cachedV8ValueBooleans = new V8ValueBoolean[]{this.decorateV8Value(new V8ValueBoolean(false)), this.decorateV8Value(new V8ValueBoolean(true))};
            this.cachedV8ValueIntegers = new V8ValueInteger[256];
            this.cachedV8ValueLongs = new V8ValueLong[256];
            IntStream.range(-128, 128).forEach(i -> {
                try {
                    this.cachedV8ValueIntegers[i - -128] = this.decorateV8Value(new V8ValueInteger(i));
                    this.cachedV8ValueLongs[i - -128] = this.decorateV8Value(new V8ValueLong(i));
                }
                catch (JavetException e) {
                    this.logger.logError(e, e.getMessage(), new Object[0]);
                }
            });
        }
        catch (JavetException e) {
            this.logger.logError(e, e.getMessage(), new Object[0]);
        }
    }

    <T extends V8Value> T invoke(IV8ValueObject iV8ValueObject, String functionName, boolean returnResult, V8Value ... v8Values) throws JavetException {
        this.decorateV8Values(v8Values);
        return (T)this.decorateV8Value((V8Value)this.v8Native.invoke(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), functionName, returnResult, v8Values));
    }

    @Override
    public boolean isClosed() {
        return this.handle == 0L;
    }

    public boolean isDead() {
        return this.v8Native.isDead(this.handle);
    }

    public boolean isGCScheduled() {
        return this.gcScheduled;
    }

    public boolean isInUse() {
        return this.v8Native.isInUse(this.handle);
    }

    public boolean isPooled() {
        return this.pooled;
    }

    boolean isWeak(IV8ValueReference iV8ValueReference) {
        return this.v8Native.isWeak(this.handle, iV8ValueReference.getHandle(), iV8ValueReference.getType().getId());
    }

    public void lowMemoryNotification() {
        if (!this.isClosed()) {
            this.v8Native.lowMemoryNotification(this.handle);
        }
    }

    <T extends V8Value> T moduleEvaluate(IV8Module iV8Module, boolean resultRequired) throws JavetException {
        return (T)this.decorateV8Value((V8Value)this.v8Native.moduleEvaluate(this.handle, iV8Module.getHandle(), iV8Module.getType().getId(), resultRequired));
    }

    V8ValueError moduleGetException(IV8Module iV8Module) throws JavetException {
        return this.decorateV8Value((V8ValueError)this.v8Native.moduleGetException(this.handle, iV8Module.getHandle(), iV8Module.getType().getId()));
    }

    V8ValueObject moduleGetNamespace(IV8Module iV8Module) throws JavetException {
        return this.decorateV8Value((V8ValueObject)this.v8Native.moduleGetNamespace(this.handle, iV8Module.getHandle(), iV8Module.getType().getId()));
    }

    int moduleGetScriptId(IV8Module iV8Module) throws JavetException {
        return this.v8Native.moduleGetScriptId(this.handle, iV8Module.getHandle(), iV8Module.getType().getId());
    }

    int moduleGetStatus(IV8Module iV8Module) throws JavetException {
        return this.v8Native.moduleGetStatus(this.handle, iV8Module.getHandle(), iV8Module.getType().getId());
    }

    boolean moduleInstantiate(IV8Module iV8Module) throws JavetException {
        return this.v8Native.moduleInstantiate(this.handle, iV8Module.getHandle(), iV8Module.getType().getId());
    }

    <T extends V8ValuePromise> T promiseCatch(IV8ValuePromise iV8ValuePromise, IV8ValueFunction functionHandle) throws JavetException {
        return (T)this.decorateV8Value((V8ValuePromise)this.v8Native.promiseCatch(this.handle, iV8ValuePromise.getHandle(), iV8ValuePromise.getType().getId(), functionHandle.getHandle()));
    }

    V8ValuePromise promiseGetPromise(IV8ValuePromise iV8ValuePromise) throws JavetException {
        return this.decorateV8Value((V8ValuePromise)this.v8Native.promiseGetPromise(this.handle, iV8ValuePromise.getHandle(), iV8ValuePromise.getType().getId()));
    }

    <T extends V8Value> T promiseGetResult(IV8ValuePromise iV8ValuePromise) throws JavetException {
        return (T)this.decorateV8Value((V8Value)this.v8Native.promiseGetResult(this.handle, iV8ValuePromise.getHandle(), iV8ValuePromise.getType().getId()));
    }

    int promiseGetState(IV8ValuePromise iV8ValuePromise) {
        return this.v8Native.promiseGetState(this.handle, iV8ValuePromise.getHandle(), iV8ValuePromise.getType().getId());
    }

    boolean promiseHasHandler(IV8ValuePromise iV8ValuePromise) {
        return this.v8Native.promiseHasHandler(this.handle, iV8ValuePromise.getHandle(), iV8ValuePromise.getType().getId());
    }

    void promiseMarkAsHandled(IV8ValuePromise iV8ValuePromise) {
        this.v8Native.promiseMarkAsHandled(this.handle, iV8ValuePromise.getHandle(), iV8ValuePromise.getType().getId());
    }

    boolean promiseReject(V8ValuePromise v8ValuePromise, V8Value v8Value) {
        return this.v8Native.promiseReject(this.handle, v8ValuePromise.getHandle(), v8ValuePromise.getType().getId(), v8Value);
    }

    boolean promiseResolve(V8ValuePromise v8ValuePromise, V8Value v8Value) {
        return this.v8Native.promiseResolve(this.handle, v8ValuePromise.getHandle(), v8ValuePromise.getType().getId(), v8Value);
    }

    <T extends V8ValuePromise> T promiseThen(IV8ValuePromise iV8ValuePromise, IV8ValueFunction functionFulfilledHandle, IV8ValueFunction functionRejectedHandle) throws JavetException {
        return (T)this.decorateV8Value((V8ValuePromise)this.v8Native.promiseThen(this.handle, iV8ValuePromise.getHandle(), iV8ValuePromise.getType().getId(), functionFulfilledHandle.getHandle(), functionRejectedHandle == null ? 0L : functionRejectedHandle.getHandle()));
    }

    V8ValueObject proxyGetHandler(IV8ValueProxy iV8ValueProxy) throws JavetException {
        return this.decorateV8Value((V8ValueObject)this.v8Native.proxyGetHandler(this.handle, iV8ValueProxy.getHandle(), iV8ValueProxy.getType().getId()));
    }

    V8ValueObject proxyGetTarget(IV8ValueProxy iV8ValueProxy) throws JavetException {
        return this.decorateV8Value((V8ValueObject)this.v8Native.proxyGetTarget(this.handle, iV8ValueProxy.getHandle(), iV8ValueProxy.getType().getId()));
    }

    boolean proxyIsRevoked(IV8ValueProxy iV8ValueProxy) throws JavetException {
        return this.v8Native.proxyIsRevoked(this.handle, iV8ValueProxy.getHandle(), iV8ValueProxy.getType().getId());
    }

    void proxyRevoke(IV8ValueProxy iV8ValueProxy) throws JavetException {
        this.v8Native.proxyRevoke(this.handle, iV8ValueProxy.getHandle(), iV8ValueProxy.getType().getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receivePromiseRejectCallback(int event, V8ValuePromise promise, V8Value value) {
        try {
            this.decorateV8Values(new V8Value[]{promise, value});
            this.promiseRejectCallback.callback(JavetPromiseRejectEvent.parse(event), promise, value);
        }
        catch (Throwable t) {
            try {
                this.logger.logError(t, "Failed to process promise reject callback {0}.", event);
            }
            catch (Throwable throwable) {
                JavetResourceUtils.safeClose(promise, value);
                throw throwable;
            }
            JavetResourceUtils.safeClose(promise, value);
        }
        JavetResourceUtils.safeClose(promise, value);
    }

    void removeAllReferences() throws JavetException {
        this.removeReferences();
        this.removeCallbackContexts();
        this.removeV8Modules();
        this.v8Inspector = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCallbackContext(long handle) {
        Lock writeLock = this.callbackContextLock.writeLock();
        try {
            writeLock.lock();
            this.callbackContextMap.remove(handle);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCallbackContexts() {
        Lock writeLock = this.callbackContextLock.writeLock();
        try {
            writeLock.lock();
            if (!this.callbackContextMap.isEmpty()) {
                int callbackContextCount = this.callbackContextMap.size();
                for (long handle : this.callbackContextMap.keySet()) {
                    this.removeJNIGlobalRef(handle);
                }
                this.logger.logWarn("{0} V8 callback context object(s) not recycled.", Integer.toString(callbackContextCount));
                this.callbackContextMap.clear();
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    void removeJNIGlobalRef(long handle) {
        if (!this.isClosed()) {
            this.v8Native.removeJNIGlobalRef(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeReference(IV8ValueReference iV8ValueReference) throws JavetException {
        long referenceHandle = iV8ValueReference.getHandle();
        Lock writeLock = this.referenceLock.writeLock();
        try {
            writeLock.lock();
            if (this.referenceMap.containsKey(referenceHandle)) {
                int referenceType = iV8ValueReference.getType().getId();
                if (referenceType == V8ValueReferenceType.Module.getId()) {
                    this.removeV8Module((IV8Module)iV8ValueReference);
                }
                this.v8Native.removeReferenceHandle(referenceHandle, referenceType);
                this.referenceMap.remove(referenceHandle);
            }
        }
        finally {
            writeLock.unlock();
        }
        if (this.gcScheduled) {
            this.lowMemoryNotification();
            this.gcScheduled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeReferences() throws JavetException {
        Lock writeLock = this.referenceLock.writeLock();
        try {
            writeLock.lock();
            if (!this.referenceMap.isEmpty()) {
                int referenceCount = this.getReferenceCount();
                int v8ModuleCount = this.getV8ModuleCount();
                int weakReferenceCount = 0;
                for (IV8ValueReference iV8ValueReference : new ArrayList<IV8ValueReference>(this.referenceMap.values())) {
                    IV8ValueObject iV8ValueObject;
                    if (iV8ValueReference instanceof IV8ValueObject && (iV8ValueObject = (IV8ValueObject)iV8ValueReference).isWeak()) {
                        ++weakReferenceCount;
                    }
                    iV8ValueReference.close(true);
                }
                if (v8ModuleCount + weakReferenceCount < referenceCount) {
                    this.logger.logWarn("{0} V8 object(s) not recycled, {1} weak, {2} module(s).", Integer.toString(referenceCount), Integer.toString(weakReferenceCount), Integer.toString(v8ModuleCount));
                } else {
                    this.logger.logDebug("{0} V8 object(s) not recycled, {1} weak, {2} module(s).", Integer.toString(referenceCount), Integer.toString(weakReferenceCount), Integer.toString(v8ModuleCount));
                }
                this.referenceMap.clear();
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeV8Module(String resourceName, boolean forceClose) throws JavetException {
        IV8Module iV8Module;
        Lock writeLock = this.v8ModuleLock.writeLock();
        try {
            writeLock.lock();
            iV8Module = this.v8ModuleMap.remove(resourceName);
        }
        finally {
            writeLock.unlock();
        }
        if (forceClose && iV8Module != null) {
            iV8Module.close(true);
        }
    }

    public void removeV8Module(String resourceName) throws JavetException {
        this.removeV8Module(resourceName, false);
    }

    public void removeV8Module(IV8Module iV8Module) throws JavetException {
        this.removeV8Module(iV8Module, false);
    }

    public void removeV8Module(IV8Module iV8Module, boolean forceClose) throws JavetException {
        this.removeV8Module(iV8Module.getResourceName(), forceClose);
    }

    public void removeV8Modules() throws JavetException {
        this.removeV8Modules(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeV8Modules(boolean forceClose) throws JavetException {
        Lock writeLock = this.v8ModuleLock.writeLock();
        try {
            writeLock.lock();
            if (!this.v8ModuleMap.isEmpty()) {
                this.logger.logWarn("{0} V8 module(s) not recycled.", Integer.toString(this.v8ModuleMap.size()));
                for (IV8Module iV8Module : this.v8ModuleMap.values()) {
                    this.logger.logWarn("  V8 module: {0}", iV8Module.getResourceName());
                    if (!forceClose) continue;
                    iV8Module.close(true);
                }
                this.v8ModuleMap.clear();
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    public V8Runtime requestGarbageCollectionForTesting(boolean fullGC) {
        this.v8Native.requestGarbageCollectionForTesting(this.handle, fullGC);
        return this;
    }

    public V8Runtime resetContext() throws JavetException {
        this.removeAllReferences();
        this.v8Native.resetV8Context(this.handle, this.runtimeOptions);
        return this;
    }

    public V8Runtime resetIsolate() throws JavetException {
        this.removeAllReferences();
        this.v8Native.resetV8Isolate(this.handle, this.runtimeOptions);
        return this;
    }

    boolean sameValue(IV8ValueObject iV8ValueObject1, IV8ValueObject iV8ValueObject2) {
        return this.v8Native.sameValue(this.handle, iV8ValueObject1.getHandle(), iV8ValueObject2.getHandle());
    }

    <T extends V8Value> T scriptRun(IV8Script iV8Script, boolean resultRequired) throws JavetException {
        return (T)this.decorateV8Value((V8Value)this.v8Native.scriptRun(this.handle, iV8Script.getHandle(), iV8Script.getType().getId(), resultRequired));
    }

    boolean set(IV8ValueObject iV8ValueObject, V8Value key, V8Value value) throws JavetException {
        this.decorateV8Values(new V8Value[]{key, value});
        return this.v8Native.set(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setAccessor(IV8ValueObject iV8ValueObject, V8Value propertyName, JavetCallbackContext javetCallbackContextGetter, JavetCallbackContext javetCallbackContextSetter) throws JavetException {
        assert (propertyName instanceof V8ValueString || propertyName instanceof V8ValueSymbol);
        boolean isAccessorSet = this.v8Native.setAccessor(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), propertyName, javetCallbackContextGetter, javetCallbackContextSetter);
        Lock writeLock = this.callbackContextLock.writeLock();
        try {
            writeLock.lock();
            if (javetCallbackContextGetter != null && javetCallbackContextGetter.isValid()) {
                this.callbackContextMap.put(javetCallbackContextGetter.getHandle(), javetCallbackContextGetter);
            }
            if (javetCallbackContextSetter != null && javetCallbackContextSetter.isValid()) {
                this.callbackContextMap.put(javetCallbackContextSetter.getHandle(), javetCallbackContextSetter);
            }
        }
        finally {
            writeLock.unlock();
        }
        return isAccessorSet;
    }

    public void setConverter(IJavetConverter converter) {
        Objects.requireNonNull(converter);
        this.converter = converter;
    }

    public void setGCScheduled(boolean gcScheduled) {
        this.gcScheduled = gcScheduled;
    }

    public void setLogger(IJavetLogger logger) {
        this.logger = logger;
    }

    boolean setPrivateProperty(IV8ValueObject iV8ValueObject, String propertyName, V8Value propertyValue) throws JavetException {
        this.decorateV8Value(propertyValue);
        return this.v8Native.setPrivateProperty(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), propertyName, propertyValue);
    }

    public void setPromiseRejectCallback(IJavetPromiseRejectCallback promiseRejectCallback) {
        Objects.requireNonNull(promiseRejectCallback);
        this.promiseRejectCallback = promiseRejectCallback;
    }

    boolean setProperty(IV8ValueObject iV8ValueObject, V8Value key, V8Value value) throws JavetException {
        this.decorateV8Values(new V8Value[]{key, value});
        return this.v8Native.setProperty(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), key, value);
    }

    boolean setPrototype(IV8ValueObject iV8ValueObject, IV8ValueObject iV8ValueObjectPrototype) throws JavetException {
        this.decorateV8Value(iV8ValueObjectPrototype);
        return this.v8Native.setPrototype(this.handle, iV8ValueObject.getHandle(), iV8ValueObject.getType().getId(), iV8ValueObjectPrototype.getHandle());
    }

    boolean setSourceCode(IV8ValueFunction iV8ValueFunction, String sourceCode) throws JavetException {
        return this.v8Native.setSourceCode(this.handle, iV8ValueFunction.getHandle(), iV8ValueFunction.getType().getId(), sourceCode);
    }

    public void setV8ModuleResolver(IV8ModuleResolver v8ModuleResolver) {
        this.v8ModuleResolver = v8ModuleResolver;
    }

    void setWeak(IV8ValueReference iV8ValueReference) {
        this.v8Native.setWeak(this.handle, iV8ValueReference.getHandle(), iV8ValueReference.getType().getId(), iV8ValueReference);
    }

    boolean strictEquals(IV8ValueObject iV8ValueObject1, IV8ValueObject iV8ValueObject2) {
        return this.v8Native.strictEquals(this.handle, iV8ValueObject1.getHandle(), iV8ValueObject2.getHandle());
    }

    public void terminateExecution() {
        this.v8Native.terminateExecution(this.handle);
    }

    @Override
    public <T, V extends V8Value> T toObject(V v8Value) throws JavetException {
        return (T)this.converter.toObject(v8Value);
    }

    String toProtoString(IV8ValueReference iV8ValueReference) throws JavetException {
        return this.v8Native.toProtoString(this.handle, iV8ValueReference.getHandle(), iV8ValueReference.getType().getId());
    }

    String toString(IV8ValueReference iV8ValueReference) throws JavetException {
        return this.v8Native.toString(this.handle, iV8ValueReference.getHandle(), iV8ValueReference.getType().getId());
    }

    @Override
    public <T, V extends V8Value> V toV8Value(T object) throws JavetException {
        return (V)this.converter.toV8Value(this, object);
    }
}

