/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.interop;

import com.caoccao.javet.annotations.NodeModule;
import com.caoccao.javet.enums.JSRuntimeType;
import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.IV8Native;
import com.caoccao.javet.interop.V8Host;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.interop.options.RuntimeOptions;
import com.caoccao.javet.node.modules.INodeModule;
import com.caoccao.javet.node.modules.NodeModuleProcess;
import com.caoccao.javet.utils.JavetResourceUtils;
import com.caoccao.javet.values.reference.V8ValueFunction;
import com.caoccao.javet.values.reference.V8ValueObject;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class NodeRuntime
extends V8Runtime {
    public static final String FUNCTION_REQUIRE = "require";
    public static final String PROPERTY_DIRNAME = "__dirname";
    public static final String PROPERTY_FILENAME = "__filename";
    protected Map<String, INodeModule> nodeModuleMap = new HashMap<String, INodeModule>();

    NodeRuntime(V8Host v8Host, long handle, boolean pooled, IV8Native v8Native, RuntimeOptions<?> runtimeOptions) {
        super(v8Host, handle, pooled, v8Native, runtimeOptions);
    }

    @Override
    public JSRuntimeType getJSRuntimeType() {
        return JSRuntimeType.Node;
    }

    public <Module extends INodeModule> Module getNodeModule(Class<Module> nodeModuleClass) throws JavetException {
        if (!nodeModuleClass.isAnnotationPresent(NodeModule.class)) {
            return null;
        }
        NodeModule nodeModule = nodeModuleClass.getAnnotation(NodeModule.class);
        return this.getNodeModule(nodeModule.name(), nodeModuleClass);
    }

    public <Module extends INodeModule> Module getNodeModule(String name, Class<Module> nodeModuleClass) throws JavetException {
        Objects.requireNonNull(name);
        INodeModule nodeModule = null;
        if (this.nodeModuleMap.containsKey(name)) {
            nodeModule = this.nodeModuleMap.get(name);
        } else {
            V8ValueObject moduleObject;
            if (nodeModuleClass == NodeModuleProcess.class) {
                moduleObject = (V8ValueObject)this.getGlobalObject().get(name);
            } else {
                try (V8ValueFunction requireFunction = (V8ValueFunction)this.getGlobalObject().get(FUNCTION_REQUIRE);){
                    moduleObject = (V8ValueObject)requireFunction.call(null, name);
                }
            }
            try {
                Constructor<Module> constructor = nodeModuleClass.getConstructor(V8ValueObject.class, String.class);
                nodeModule = (INodeModule)constructor.newInstance(moduleObject, name);
                this.nodeModuleMap.put(name, nodeModule);
            }
            catch (Exception e) {
                this.getLogger().logError(e, "Failed to create node module {0}.", name);
            }
        }
        return (Module)nodeModule;
    }

    public int getNodeModuleCount() {
        return this.nodeModuleMap.size();
    }

    @Override
    void removeAllReferences() throws JavetException {
        this.removeNodeModules();
        super.removeAllReferences();
    }

    public void removeNodeModule(INodeModule iNodeModule) throws JavetException {
        Objects.requireNonNull(iNodeModule);
        if (this.nodeModuleMap.containsKey(iNodeModule.getName())) {
            this.nodeModuleMap.remove(iNodeModule.getName());
            iNodeModule.close();
        }
    }

    void removeNodeModules() {
        if (!this.nodeModuleMap.isEmpty()) {
            JavetResourceUtils.safeClose(this.nodeModuleMap.values());
            this.nodeModuleMap.clear();
        }
    }
}

