/*
 * Decompiled with CFR 0.152.
 */
package com.caoccao.javet.enums;

import com.caoccao.javet.interop.options.NodeRuntimeOptions;
import com.caoccao.javet.interop.options.RuntimeOptions;
import com.caoccao.javet.interop.options.V8RuntimeOptions;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public enum JSRuntimeType {
    Node("node", "9.4.146.19-node.13", NodeRuntimeOptions::new, o -> o instanceof NodeRuntimeOptions),
    V8("v8", "9.5.172.22", V8RuntimeOptions::new, o -> o instanceof V8RuntimeOptions);

    private final String name;
    private final Supplier<? extends RuntimeOptions<?>> runtimeOptionsConstructor;
    private final Function<RuntimeOptions<?>, Boolean> runtimeOptionsValidator;
    private final String version;

    private JSRuntimeType(String name, String version, Supplier<RuntimeOptions<?>> runtimeOptionsConstructor, Function<RuntimeOptions<?>, Boolean> runtimeOptionsValidator) {
        this.runtimeOptionsConstructor = Objects.requireNonNull(runtimeOptionsConstructor);
        this.runtimeOptionsValidator = Objects.requireNonNull(runtimeOptionsValidator);
        this.name = name;
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public <Options extends RuntimeOptions<?>> Options getRuntimeOptions() {
        return (Options)this.runtimeOptionsConstructor.get();
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isNode() {
        return this == Node;
    }

    public boolean isRuntimeOptionsValid(RuntimeOptions<?> runtimeOptions) {
        return this.runtimeOptionsValidator.apply(runtimeOptions);
    }

    public boolean isV8() {
        return this == V8;
    }
}

