/*
 * Decompiled with CFR 0.152.
 */
package com.canaan.library;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.canaan.library.R;
import com.canaan.library.RatingShape;

public class SimpleRatingBar
extends View {
    private float starWidth;
    private float starHeight;
    private int starSpace;
    private float stepSize;
    private int starNum;
    private float rating;
    private Drawable starDrawable;
    private RatingShape shape;
    private int progressColor;
    private int backgroundColor;
    private boolean isStarClickable;
    private Paint mPaint;
    private Rect starsBoundRect = new Rect();
    private Path shapePath;
    private int mWidth = 100;
    private int mHeight = 20;
    private float right;

    public SimpleRatingBar(Context context) {
        this(context, null, 0);
    }

    public SimpleRatingBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SimpleRatingBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttr(attrs);
        this.initPaint();
        this.shape = new RatingShape(this.mPaint);
    }

    private void initAttr(AttributeSet atts) {
        if (atts != null) {
            TypedArray array = this.getContext().obtainStyledAttributes(atts, R.styleable.SimpleRatingBar);
            this.starHeight = array.getDimension(R.styleable.SimpleRatingBar_starHeight, 10.0f);
            this.starWidth = array.getDimension(R.styleable.SimpleRatingBar_starWidth, 10.0f);
            this.starSpace = array.getInteger(R.styleable.SimpleRatingBar_starSpace, 5);
            this.stepSize = array.getFloat(R.styleable.SimpleRatingBar_stepSize, 1.0f);
            this.starNum = array.getInteger(R.styleable.SimpleRatingBar_numStar, 5);
            this.rating = array.getFloat(R.styleable.SimpleRatingBar_rating, 0.0f);
            this.progressColor = array.getColor(R.styleable.SimpleRatingBar_starColor, -256);
            this.backgroundColor = array.getColor(R.styleable.SimpleRatingBar_backgroundColor, -7829368);
            this.starDrawable = array.getDrawable(R.styleable.SimpleRatingBar_starDrawable);
            this.isStarClickable = array.getBoolean(R.styleable.SimpleRatingBar_isStarClicable, false);
            array.recycle();
        }
    }

    private void initPaint() {
        this.mPaint = new Paint();
        this.mPaint.setColor(this.backgroundColor);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStrokeWidth(1.0f);
        this.mPaint.setStyle(Paint.Style.FILL);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int specWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int widhtMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int specHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int boundWidth = this.getStarsBoundWidth();
        this.mWidth = boundWidth > this.mWidth ? boundWidth : this.mWidth;
        int n = this.mHeight = this.starHeight > (float)this.mHeight ? (int)this.starHeight : this.mHeight;
        if (widhtMode == Integer.MIN_VALUE && heightMode == Integer.MIN_VALUE) {
            this.setMeasuredDimension(this.mWidth, this.mHeight);
        } else if (widhtMode == Integer.MIN_VALUE) {
            this.setMeasuredDimension(this.mWidth, specHeight);
            this.mHeight = specHeight;
        } else if (heightMode == Integer.MIN_VALUE) {
            this.setMeasuredDimension(specWidth, this.mHeight);
            this.mWidth = specWidth;
        } else {
            this.mWidth = SimpleRatingBar.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec);
            this.mHeight = SimpleRatingBar.getDefaultSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec);
            this.setMeasuredDimension(this.mWidth, this.mHeight);
        }
    }

    protected void onDraw(Canvas canvas) {
        int i;
        super.onDraw(canvas);
        int radius = this.computeRadius();
        int innerRadius = radius / 2;
        float startX = Float.parseFloat((double)radius * Math.cos(0.0) + "");
        float startY = Float.parseFloat((double)radius * Math.sin(Math.toRadians(72.0)) + "");
        this.getRect(radius, (int)startY);
        canvas.save();
        this.mPaint.setColor(this.backgroundColor);
        canvas.clipRect(this.starsBoundRect, Region.Op.DIFFERENCE);
        for (i = 0; i < this.starNum; ++i) {
            canvas.drawPath(this.shape.setStar(startX, startY, radius, innerRadius, 5), this.mPaint);
            startX += (float)(this.starSpace + radius * 2);
        }
        canvas.restore();
        this.mPaint.setColor(-256);
        canvas.save();
        canvas.clipRect(this.starsBoundRect);
        startX = Float.parseFloat((double)radius * Math.cos(0.0) + "");
        for (i = 0; i < this.starNum; ++i) {
            canvas.drawPath(this.shape.setStar(startX, startY, radius, innerRadius, 5), this.mPaint);
            startX += (float)(this.starSpace + radius * 2);
        }
        canvas.restore();
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                if (!this.isStarClickable) break;
                this.right = event.getX();
                this.postInvalidate();
            }
        }
        return true;
    }

    private int computeRadius() {
        return (int)this.starWidth / 2;
    }

    private void getRect(int radius, int startY) {
        if (this.right == 0.0f) {
            this.right = Math.round((float)(2 * radius) * this.rating + (float)(this.starSpace * Math.round(this.rating)));
        }
        float bottom = Math.round(2 * startY);
        this.right = this.removeReduntant(radius, this.right);
        this.starsBoundRect.setEmpty();
        this.starsBoundRect.set(0, 0, Math.round(this.right), Math.round(bottom));
    }

    private float removeReduntant(int radius, float right) {
        int spaceNum = (int)right / (2 * radius + this.starSpace);
        float result = (float)Math.round((right - (float)(spaceNum * this.starSpace)) / (this.stepSize * (float)radius * 2.0f)) * (this.stepSize * (float)radius * 2.0f) + (float)(spaceNum * this.starSpace);
        return result;
    }

    private void initShapePath() {
        this.shapePath = this.shape.getPath();
    }

    private int getStarsBoundWidth() {
        return (int)this.starWidth * this.starNum + this.starSpace * (this.starNum - 1);
    }
}

