/*
 * Decompiled with CFR 0.152.
 */
package com.canaan.library;

import android.graphics.Paint;
import android.graphics.Path;
import com.canaan.library.BaseShape;

public class RatingShape
extends BaseShape {
    private Paint paint;
    private Path path;

    public RatingShape(Paint paint) {
        this.paint = paint;
        this.path = new Path();
    }

    public void setCircle(float x, float y, float radius, Path.Direction dir) {
        this.path.reset();
        this.path.addCircle(x, y, radius, dir);
    }

    public Path setStar(float x, float y, float radius, float innerRadius, int numOfPt) {
        double section = Math.PI * 2 / (double)numOfPt;
        this.path.reset();
        this.path.moveTo((float)((double)x + (double)radius * Math.cos(0.0)), (float)((double)y + (double)radius * Math.sin(0.0)));
        this.path.lineTo((float)((double)x + (double)innerRadius * Math.cos(0.0 + section / 2.0)), (float)((double)y + (double)innerRadius * Math.sin(0.0 + section / 2.0)));
        for (int i = 1; i < numOfPt; ++i) {
            this.path.lineTo((float)((double)x + (double)radius * Math.cos(section * (double)i)), (float)((double)y + (double)radius * Math.sin(section * (double)i)));
            this.path.lineTo((float)((double)x + (double)innerRadius * Math.cos(section * (double)i + section / 2.0)), (float)((double)y + (double)innerRadius * Math.sin(section * (double)i + section / 2.0)));
        }
        this.path.close();
        return this.path;
    }

    @Override
    public Path getPath() {
        return this.path;
    }
}

