/*
 * Decompiled with CFR 0.152.
 */
package com.google.ical.compat.javatime;

import com.google.ical.compat.javatime.LocalDateIterable;
import com.google.ical.compat.javatime.LocalDateIterator;
import com.google.ical.compat.javatime.TimeZoneConverter;
import com.google.ical.iter.RecurrenceIterable;
import com.google.ical.iter.RecurrenceIterator;
import com.google.ical.iter.RecurrenceIteratorFactory;
import com.google.ical.values.DateValue;
import com.google.ical.values.DateValueImpl;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.ZoneId;

public class LocalDateIteratorFactory {
    public static LocalDateIterator createLocalDateIterator(String rdata, LocalDate start, ZoneId zoneId, boolean strict) throws ParseException {
        return new RecurrenceIteratorWrapper(RecurrenceIteratorFactory.createRecurrenceIterator(rdata, LocalDateIteratorFactory.localDateToDateValue(start), TimeZoneConverter.toTimeZone(zoneId), strict));
    }

    public static LocalDateIterator createLocalDateIterator(String rdata, LocalDate start, boolean strict) throws ParseException {
        return LocalDateIteratorFactory.createLocalDateIterator(rdata, start, ZoneId.of("UTC"), strict);
    }

    public static LocalDateIterable createLocalDateIterable(String rdata, LocalDate start, ZoneId tzid, boolean strict) throws ParseException {
        return new RecurrenceIterableWrapper(RecurrenceIteratorFactory.createRecurrenceIterable(rdata, LocalDateIteratorFactory.localDateToDateValue(start), TimeZoneConverter.toTimeZone(tzid), strict));
    }

    public static LocalDateIterable createLocalDateIterable(String rdata, LocalDate start, boolean strict) throws ParseException {
        return LocalDateIteratorFactory.createLocalDateIterable(rdata, start, ZoneId.of("UTC"), strict);
    }

    public static LocalDateIterator createLocalDateIterator(RecurrenceIterator rit) {
        return new RecurrenceIteratorWrapper(rit);
    }

    static LocalDate dateValueToLocalDate(DateValue dvUtc) {
        return LocalDate.of(dvUtc.year(), dvUtc.month(), dvUtc.day());
    }

    static DateValue localDateToDateValue(LocalDate date) {
        return new DateValueImpl(date.getYear(), date.getMonthValue(), date.getDayOfMonth());
    }

    private LocalDateIteratorFactory() {
    }

    private static final class RecurrenceIteratorWrapper
    implements LocalDateIterator {
        private final RecurrenceIterator it;

        RecurrenceIteratorWrapper(RecurrenceIterator it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public LocalDate next() {
            return LocalDateIteratorFactory.dateValueToLocalDate(this.it.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void advanceTo(LocalDate d) {
            this.it.advanceTo(LocalDateIteratorFactory.localDateToDateValue(d));
        }
    }

    private static final class RecurrenceIterableWrapper
    implements LocalDateIterable {
        private final RecurrenceIterable it;

        public RecurrenceIterableWrapper(RecurrenceIterable it) {
            this.it = it;
        }

        @Override
        public LocalDateIterator iterator() {
            return new RecurrenceIteratorWrapper(this.it.iterator());
        }
    }
}

