/*
 * Decompiled with CFR 0.152.
 */
package com.cab404.chumroll;

import android.content.Context;
import android.database.DataSetObserver;
import android.os.Looper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.cab404.chumroll.ConverterPool;
import com.cab404.chumroll.ViewConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class ChumrollAdapter
extends BaseAdapter {
    protected List<ViewConverter> usedConverters;
    protected ConverterPool converters;
    protected List<ViewBinder> list;
    protected LayoutInflater inf;
    protected AtomicInteger observers = new AtomicInteger(0);

    public ChumrollAdapter() {
        this.usedConverters = new ArrayList<ViewConverter>();
        this.converters = new ConverterPool();
        this.list = new ArrayList<ViewBinder>();
    }

    public ConverterPool getConverters() {
        return this.converters;
    }

    public void registerDataSetObserver(DataSetObserver observer) {
        if (observer == null) {
            return;
        }
        this.observers.incrementAndGet();
        super.registerDataSetObserver(observer);
    }

    public void unregisterDataSetObserver(DataSetObserver observer) {
        this.observers.decrementAndGet();
        super.unregisterDataSetObserver(observer);
    }

    protected void throwIfIllegal() {
        if (this.observers.get() == 0) {
            return;
        }
        if (!Thread.currentThread().equals(Looper.getMainLooper().getThread())) {
            throw new UnsupportedOperationException("Operation on connected adapter should be done inside main thread!");
        }
    }

    public int indexOf(Object data) {
        this.throwIfIllegal();
        for (int i = 0; i < this.list.size(); ++i) {
            if (!this.list.get((int)i).data.equals(data)) continue;
            return i;
        }
        return -1;
    }

    public <Data> int add(ViewConverter<Data> instance, Data data) {
        this.throwIfIllegal();
        this.addConverterWithCheck(instance);
        ViewBinder<Data> binder = new ViewBinder<Data>(instance, data);
        this.list.add(binder);
        this.notifyDataSetChanged();
        return binder.id;
    }

    public <Data> int add(int index, ViewConverter<Data> instance, Data data) {
        this.throwIfIllegal();
        this.addConverterWithCheck(instance);
        ViewBinder<Data> binder = new ViewBinder<Data>(instance, data);
        this.list.add(index, binder);
        this.notifyDataSetChanged();
        return binder.id;
    }

    public <Data> void addAll(ViewConverter<Data> instance, Collection<? extends Data> data_set) {
        this.throwIfIllegal();
        this.addConverterWithCheck(instance);
        for (Data data : data_set) {
            this.list.add(new ViewBinder<Data>(instance, data));
        }
        this.notifyDataSetChanged();
    }

    public void removeById(int id) {
        this.throwIfIllegal();
        for (int i = 0; i < this.list.size(); ++i) {
            if (this.list.get((int)i).id != id) continue;
            this.list.remove(i);
            this.notifyDataSetChanged();
            break;
        }
    }

    public int indexOfId(int id) {
        for (int i = 0; i < this.list.size(); ++i) {
            if (this.list.get((int)i).id != id) continue;
            return i;
        }
        return -1;
    }

    public int idOf(int index) {
        return this.list.get((int)index).id;
    }

    public <Data> int add(Class<? extends ViewConverter<Data>> converter, Data data) {
        ViewConverter<Data> instance = this.converters.getInstance(converter);
        return this.add(instance, data);
    }

    public <Data> int add(int index, Class<? extends ViewConverter<Data>> converter, Data data) {
        ViewConverter<Data> instance = this.converters.getInstance(converter);
        return this.add(index, instance, data);
    }

    public <Data> void addAll(Class<? extends ViewConverter<Data>> converter, Collection<? extends Data> data_set) {
        ViewConverter<Data> instance = this.converters.getInstance(converter);
        this.addAll(instance, data_set);
    }

    private <Data> void addConverterWithCheck(ViewConverter<Data> instance) {
        if (!this.usedConverters.contains(instance)) {
            if (this.observers.get() > 0) {
                throw new RuntimeException(instance.getClass().getSimpleName() + ": Cannot add new data types on fly :(");
            }
            this.usedConverters.add(instance);
        }
    }

    public Object getData(int at) {
        return this.list.get((int)at).data;
    }

    public void clear() {
        this.throwIfIllegal();
        this.list.clear();
        this.notifyDataSetChanged();
    }

    public void clearConverters() {
        this.usedConverters.clear();
    }

    public void remove(int at) {
        this.throwIfIllegal();
        this.list.remove(at);
    }

    public <Data> void remove(Data what) {
        this.remove(this.indexOf(what));
    }

    public int typeIdOf(ViewConverter converter) {
        return this.usedConverters.indexOf(converter);
    }

    public int getCount() {
        return this.list.size();
    }

    public int getViewTypeCount() {
        return this.usedConverters.size();
    }

    public int getItemViewType(int position) {
        ViewConverter converter = this.list.get((int)position).converter;
        return this.usedConverters.indexOf(converter);
    }

    public Object getItem(int position) {
        return this.getData(position);
    }

    public long getItemId(int position) {
        return this.idOf(position);
    }

    public boolean hasStableIds() {
        return false;
    }

    public boolean areAllItemsEnabled() {
        return false;
    }

    public Class<? extends ViewConverter> classOf(int index) {
        return this.list.get((int)index).converter.getClass();
    }

    public <A extends ViewConverter> A converterOf(int index) {
        return (A)this.list.get((int)index).converter;
    }

    public boolean isEnabled(int position) {
        ViewBinder binder = this.list.get(position);
        return binder.converter.enabled(binder.data, position, this);
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewBinder binder = this.list.get(position);
        if (convertView == null) {
            if (this.inf == null || this.inf.getContext() != parent.getContext()) {
                this.inf = LayoutInflater.from((Context)parent.getContext());
            }
            convertView = binder.converter.createView(this.inf, parent, this);
        }
        binder.converter.convert(convertView, binder.data, position, parent, this);
        return convertView;
    }

    public void prepareFor(ViewConverter ... prepare_to_what) {
        for (ViewConverter thing : prepare_to_what) {
            this.converters.enforceInstance(thing);
            if (this.observers.get() > 0) {
                throw new RuntimeException("Cannot add new data types on fly :(");
            }
            this.usedConverters.add(thing);
        }
    }

    public boolean isInstanceOf(int index, Class dataType) {
        return dataType.isInstance(this.list.get((int)index).data);
    }

    public boolean converterIsInstanceOf(int index, Class convType) {
        return convType.isInstance(this.list.get((int)index).converter);
    }

    public ViewConverter getConverterOf(int index) {
        return this.list.get((int)index).converter;
    }

    protected class ViewBinder<From> {
        final int id;
        ViewConverter<? extends From> converter;
        From data;

        public ViewBinder(ViewConverter<? extends From> converter, From data) {
            this.converter = converter;
            this.data = data;
            int rnd = (int)(Math.random() * 2.147483647E9);
            this.id = converter.hashCode() ^ rnd;
        }
    }
}

