/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.storage;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Parcel;
import android.support.annotation.NonNull;
import com.ca.mas.foundation.Internal;
import com.ca.mas.storage.DataMarshaller;
import com.ca.mas.storage.MASStorage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

abstract class AbstractMASStorage
implements MASStorage {
    private List<DataMarshaller> marshallers = new ArrayList<DataMarshaller>();

    AbstractMASStorage() {
    }

    @Internal
    protected DataMarshaller findMarshaller(Object type) {
        for (DataMarshaller current : this.marshallers) {
            if (!current.getType().isAssignableFrom(type.getClass())) continue;
            return current;
        }
        throw new TypeNotPresentException(type.getClass().getName(), null);
    }

    @Internal
    protected DataMarshaller findMarshaller(String type) {
        for (DataMarshaller current : this.marshallers) {
            if (!current.getTypeAsString().equals(type)) continue;
            return current;
        }
        throw new TypeNotPresentException(type, null);
    }

    @Override
    @Internal
    public void register(@NonNull DataMarshaller marshaller) {
        this.marshallers.add(marshaller);
    }

    @Internal
    protected void checkNull(String key, Object value) {
        this.checkNull(key);
        if (value == null) {
            throw new NullPointerException("Value cannot be null");
        }
    }

    @Internal
    protected void checkNull(String key) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null");
        }
    }

    public class StringDataMarshaller
    implements DataMarshaller<String> {
        @Override
        public String unmarshall(byte[] content) throws Exception {
            return new String(content, "UTF-8");
        }

        @Override
        public byte[] marshall(@NonNull String data) throws Exception {
            return data.getBytes("UTF-8");
        }

        @Override
        public Class<String> getType() {
            return String.class;
        }

        @Override
        public String getTypeAsString() {
            return "text/plain";
        }
    }

    public class JsonDataMarshaller
    implements DataMarshaller<JSONObject> {
        @Override
        public JSONObject unmarshall(@NonNull byte[] content) throws UnsupportedEncodingException, JSONException {
            return new JSONObject(new String(content, "UTF-8"));
        }

        @Override
        public byte[] marshall(@NonNull JSONObject data) throws UnsupportedEncodingException {
            return data.toString().getBytes("UTF-8");
        }

        @Override
        public Class<JSONObject> getType() {
            return JSONObject.class;
        }

        @Override
        public String getTypeAsString() {
            return "application/json";
        }
    }

    public class SerializableDataMarshaller
    implements DataMarshaller<Serializable> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Serializable unmarshall(byte[] content) throws IOException, ClassNotFoundException {
            ByteArrayInputStream bis = new ByteArrayInputStream(content);
            ObjectInputStream in = null;
            try {
                in = new ObjectInputStream(bis);
                Serializable serializable = (Serializable)in.readObject();
                return serializable;
            }
            finally {
                try {
                    bis.close();
                }
                catch (IOException iOException) {}
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] marshall(@NonNull Serializable data) throws IOException {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = null;
            try {
                out = new ObjectOutputStream(bos);
                out.writeObject(data);
                byte[] byArray = bos.toByteArray();
                return byArray;
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
            }
        }

        @Override
        public Class<Serializable> getType() {
            return Serializable.class;
        }

        @Override
        public String getTypeAsString() {
            return "serializable";
        }
    }

    public class ParcelDataMarshaller
    implements DataMarshaller<Parcel> {
        @Override
        public Parcel unmarshall(byte[] content) {
            Parcel parcel = Parcel.obtain();
            parcel.unmarshall(content, 0, content.length);
            parcel.setDataPosition(0);
            return parcel;
        }

        @Override
        public byte[] marshall(@NonNull Parcel data) {
            byte[] bytes = data.marshall();
            data.recycle();
            return bytes;
        }

        @Override
        public Class<Parcel> getType() {
            return Parcel.class;
        }

        @Override
        public String getTypeAsString() {
            return "parcel";
        }
    }

    public class ByteArrayDataMarshaller
    implements DataMarshaller<byte[]> {
        @Override
        public byte[] unmarshall(byte[] content) throws Exception {
            return content;
        }

        @Override
        public byte[] marshall(byte[] data) throws Exception {
            return data;
        }

        @Override
        public Class<byte[]> getType() {
            return byte[].class;
        }

        @Override
        public String getTypeAsString() {
            return "application/octet-stream";
        }
    }

    public class BitmapDataMarshaller
    implements DataMarshaller<Bitmap> {
        @Override
        public Bitmap unmarshall(byte[] content) throws Exception {
            return BitmapFactory.decodeByteArray((byte[])content, (int)0, (int)content.length);
        }

        @Override
        public byte[] marshall(Bitmap data) throws Exception {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            data.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
            return stream.toByteArray();
        }

        @Override
        public Class<Bitmap> getType() {
            return Bitmap.class;
        }

        @Override
        public String getTypeAsString() {
            return "image/png";
        }
    }
}

