/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.messaging;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.util.Base64;
import com.ca.mas.foundation.MASUser;
import com.ca.mas.identity.ScimIdentifiable;
import com.ca.mas.messaging.MASMessageException;
import com.ca.mas.messaging.MASPayload;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class MASMessage
implements MASPayload {
    public static MASMessage newInstance(Intent intent) throws MASMessageException {
        MASMessage m = MASMessage.newInstance();
        m.createMASMessageFromJSONString(intent.getStringExtra("Message"));
        return m;
    }

    public static MASMessage newInstance() {
        return new MASMessage(){
            private String mSenderId;
            private String mVersion = "1.0";
            private byte[] mPayload = new byte[0];
            private boolean mIsDuplicate;
            private boolean mIsRetained;
            private long mSentTime = 0L;
            private String mDisplayName;
            private String mSenderType = ScimIdentifiable.ResourceType.User.toString();
            private String mContentType = "text/plain";
            private String mContentEncoding = "BASE64";
            private int mQos = 2;
            private String mTopic;

            @Override
            public int getQos() {
                return this.mQos;
            }

            @Override
            public void setQos(int qos) {
                this.mQos = qos;
            }

            @Override
            public String getSenderId() {
                return this.mSenderId;
            }

            @Override
            public void setVersion(String version) {
                this.mVersion = version;
            }

            @Override
            public String getVersion() {
                return this.mVersion;
            }

            @Override
            public void setSenderId(String senderId) {
                this.mSenderId = senderId;
            }

            @Override
            public byte[] getPayload() {
                return this.mPayload;
            }

            @Override
            public void setPayload(byte[] payload) {
                this.mPayload = payload;
            }

            @Override
            public boolean isDuplicate() {
                return this.mIsDuplicate;
            }

            @Override
            public void setDuplicate(boolean isDuplicate) {
                this.mIsDuplicate = isDuplicate;
            }

            @Override
            public boolean isRetained() {
                return this.mIsRetained;
            }

            @Override
            public void setRetained(boolean isRetained) {
                this.mIsRetained = isRetained;
            }

            @Override
            public String getDisplayName() {
                return this.mDisplayName;
            }

            @Override
            public void setSenderType(String senderType) {
                this.mSenderType = senderType;
            }

            @Override
            public String getSenderType() {
                return this.mSenderType;
            }

            @Override
            public void setSentTime(long sentTime) {
                this.mSentTime = sentTime;
            }

            @Override
            public long getSentTime() {
                return this.mSentTime;
            }

            @Override
            public void setContentType(String contentType) {
                this.mContentType = contentType;
            }

            @Override
            public String getContentType() {
                return this.mContentType;
            }

            @Override
            public void setContentEncoding(String encoding) {
                this.mContentEncoding = encoding;
            }

            @Override
            public String getContentEncoding() {
                return this.mContentEncoding;
            }

            @Override
            public String getTopic() {
                return this.mTopic;
            }

            @Override
            public void setTopic(String topic) {
                this.mTopic = topic;
            }

            @Override
            public void createMASMessageFromJSONString(String jsonStr) throws MASMessageException {
                try {
                    JSONObject jobj = new JSONObject(jsonStr);
                    this.mVersion = jobj.optString("Version", "1.0");
                    this.mSenderId = jobj.optString("SenderId");
                    this.mSenderType = jobj.optString("SenderType");
                    if (!TextUtils.isEmpty((CharSequence)this.mSenderType)) {
                        this.mSenderType = this.mSenderType.toUpperCase();
                    }
                    this.mDisplayName = jobj.optString("DisplayName");
                    this.mSentTime = jobj.getLong("SentTime");
                    this.mContentType = jobj.optString("ContentType");
                    this.mContentEncoding = jobj.optString("ContentEncoding", "utf8");
                    String payloadBefore = jobj.optString("Payload", "");
                    this.mPayload = Base64.decode((byte[])payloadBefore.getBytes(), (int)2);
                    this.mTopic = jobj.optString("Topic");
                }
                catch (JSONException je) {
                    throw new MASMessageException(je);
                }
            }

            @Override
            public String createJSONStringFromMASMessage(Context context) throws MASMessageException {
                JSONObject jobj = new JSONObject();
                try {
                    String ver = this.getVersion();
                    if (TextUtils.isEmpty((CharSequence)ver)) {
                        ver = "1.0";
                    }
                    jobj.put("Version", (Object)ver);
                    String id = this.getSenderId();
                    if (TextUtils.isEmpty((CharSequence)id)) {
                        MASUser masUser = MASUser.getCurrentUser();
                        id = masUser.getId();
                    }
                    jobj.put("SenderId", (Object)id);
                    String senderType = this.getSenderType();
                    if (TextUtils.isEmpty((CharSequence)senderType)) {
                        senderType = "USER";
                    }
                    jobj.put("SenderType", (Object)senderType.toUpperCase());
                    String dispName = this.getDisplayName();
                    if (TextUtils.isEmpty((CharSequence)dispName)) {
                        dispName = id;
                    }
                    jobj.put("DisplayName", (Object)dispName);
                    long sentTime = this.getSentTime();
                    if (sentTime == 0L) {
                        sentTime = System.currentTimeMillis();
                    }
                    jobj.put("SentTime", sentTime);
                    String contentType = this.getContentType();
                    if (TextUtils.isEmpty((CharSequence)contentType)) {
                        contentType = "text/plain";
                    }
                    jobj.put("ContentType", (Object)contentType);
                    String contentEnc = this.getContentEncoding();
                    if (TextUtils.isEmpty((CharSequence)contentEnc)) {
                        contentEnc = "BASE64";
                    }
                    jobj.put("ContentEncoding", (Object)contentEnc);
                    byte[] payload = this.getPayload();
                    if (payload == null || payload.length <= 0) {
                        throw new MASMessageException("Parameter cannot be empty or null.");
                    }
                    jobj.put("Payload", (Object)new String(Base64.encode((byte[])payload, (int)2)));
                    String topic = this.getTopic();
                    if (!TextUtils.isEmpty((CharSequence)topic)) {
                        jobj.put("Topic", (Object)topic);
                    }
                }
                catch (JSONException je) {
                    throw new MASMessageException(je);
                }
                return jobj.toString();
            }
        };
    }

    public abstract void setDuplicate(boolean var1);

    public abstract boolean isDuplicate();

    public abstract void setRetained(boolean var1);

    public abstract boolean isRetained();

    public abstract void setQos(int var1);

    public abstract int getQos();

    public abstract void setTopic(String var1);

    public abstract String getTopic();
}

