/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.identity.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.ca.mas.core.MAG;
import com.ca.mas.core.conf.ConfigurationManager;
import com.ca.mas.foundation.MASUser;
import com.ca.mas.foundation.util.FoundationUtil;
import com.ca.mas.identity.common.MASFilteredRequest;
import com.ca.mas.identity.user.MASPhoto;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class IdentityUtil
extends FoundationUtil {
    public static final Map<String, JSONObject> SCHEMA_MAP = new HashMap<String, JSONObject>();

    public static String getMetaDateString(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd:HH:mm:ss.SSSZ");
        return formatter.format(date);
    }

    public static Bitmap getThumbnail(List<MASPhoto> photoList) {
        return IdentityUtil.getPhoto(photoList);
    }

    public static List<String> normalizeAttributes(@NonNull List<String> providedAttributes, @NonNull List<String> allowedAttributes) {
        ArrayList<String> replacements = new ArrayList<String>();
        for (String attribute : providedAttributes) {
            if (allowedAttributes.contains(attribute)) {
                replacements.add(attribute);
                continue;
            }
            for (String s : allowedAttributes) {
                if (!s.startsWith(attribute + '.')) continue;
                replacements.add(s);
            }
        }
        return replacements;
    }

    public static String[] getUserNamesAsStrings(List<MASUser> usersList) {
        String[] userArr = new String[usersList.size()];
        for (int i = 0; i < usersList.size(); ++i) {
            userArr[i] = usersList.get(i).getUserName();
        }
        return userArr;
    }

    public static String getSchemasUrl(Context context) {
        return IdentityUtil.getUrl(context, "Schemas");
    }

    public static String getSchemasPath(Context context) {
        return IdentityUtil.getPath(context, "Schemas");
    }

    public static String getUserUrl(Context context) {
        return IdentityUtil.getUrl(context, "Users");
    }

    public static String getUserPath(Context context) {
        return IdentityUtil.getPath(context, "Users");
    }

    public static String getCreateUrl(Context context) {
        return IdentityUtil.getUrl(context, null);
    }

    public static String getDeleteUrl(Context context, String id) {
        return IdentityUtil.getUrl(context, id);
    }

    public static String getUpdateUrl(Context context, String id) {
        return IdentityUtil.getUrl(context, id);
    }

    public static String getGroupUrl(Context context) {
        return IdentityUtil.getUrl(context, "Groups");
    }

    public static String getGroupPath(Context context) {
        return IdentityUtil.getPath(context, "Groups");
    }

    private static String getUrl(Context context, String entity) {
        StringBuilder sb = new StringBuilder();
        sb.append(FoundationUtil.getFqdn());
        String scimPath = (String)ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getProperty("mas.url.scim_path");
        if (scimPath == null) {
            scimPath = "/SCIM/MAS/v2";
        }
        sb.append(scimPath);
        if (!TextUtils.isEmpty((CharSequence)entity)) {
            sb.append("/");
            sb.append(entity);
        }
        if (MAG.DEBUG) {
            Log.d((String)MAG.TAG, (String)("SCIM URL" + sb.toString()));
        }
        return sb.toString();
    }

    private static String getPath(Context context, String entity) {
        StringBuilder sb = new StringBuilder();
        String scimPath = (String)ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getProperty("mas.url.scim_path");
        if (scimPath == null) {
            scimPath = "/SCIM/MAS/v2";
        }
        sb.append(scimPath);
        if (!TextUtils.isEmpty((CharSequence)entity)) {
            sb.append("/");
            sb.append(entity);
        }
        if (MAG.DEBUG) {
            Log.d((String)MAG.TAG, (String)("SCIM URL Path: " + sb.toString()));
        }
        return sb.toString();
    }

    public static Bitmap getPhoto(List<MASPhoto> photoList) {
        if (photoList != null) {
            for (MASPhoto photo : photoList) {
                if (photo == null || !photo.getType().equals("thumbnail")) continue;
                String value = photo.getValue();
                int offset = value.indexOf("base64,") + "base64,".length();
                byte[] subVal = Base64.decode((String)value.substring(offset), (int)0);
                return BitmapFactory.decodeByteArray((byte[])subVal, (int)0, (int)subVal.length);
            }
        }
        return null;
    }

    public static MASFilteredRequest createFilter(List<String> attributes, String attributesType, String filter, String op, String attribute) {
        MASFilteredRequest frb = new MASFilteredRequest(attributes, attributesType);
        if (op.equals("eq")) {
            frb.isEqualTo(attribute, filter);
        }
        if (op.equals("ne")) {
            frb.isNotEqualTo(attribute, filter);
        }
        if (op.equals("co")) {
            frb.contains(attribute, filter);
        }
        if (op.equals("sw")) {
            frb.startsWith(attribute, filter);
        }
        if (op.equals("ew")) {
            frb.endsWith(attribute, filter);
        }
        if (op.equals("pr")) {
            frb.isPresent(attribute);
        }
        if (op.equals("gt")) {
            frb.isGreaterThan(attribute, filter);
        }
        if (op.equals("ge")) {
            frb.isGreaterThanOrEqual(attribute, filter);
        }
        if (op.equals("lt")) {
            frb.isLessThan(attribute, filter);
        }
        if (op.equals("le")) {
            frb.isLessThanOrEqual(attribute, filter);
        }
        return frb;
    }
}

