/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.identity.user;

import android.graphics.Bitmap;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.ca.mas.core.http.MAGResponseBody;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASCallback;
import com.ca.mas.foundation.MASGroup;
import com.ca.mas.foundation.MASRequest;
import com.ca.mas.foundation.MASResponse;
import com.ca.mas.foundation.MASSessionUnlockCallback;
import com.ca.mas.foundation.MASUser;
import com.ca.mas.foundation.notify.Callback;
import com.ca.mas.identity.common.MASFilteredRequest;
import com.ca.mas.identity.user.MASAddress;
import com.ca.mas.identity.user.MASEmail;
import com.ca.mas.identity.user.MASIms;
import com.ca.mas.identity.user.MASMeta;
import com.ca.mas.identity.user.MASName;
import com.ca.mas.identity.user.MASPhone;
import com.ca.mas.identity.user.MASPhoto;
import com.ca.mas.identity.user.ScimUser;
import com.ca.mas.identity.user.User;
import com.ca.mas.identity.user.UserAttributes;
import com.ca.mas.identity.user.UserNotAuthenticatedException;
import com.ca.mas.identity.util.IdentityUtil;
import com.ca.mas.messaging.MASMessage;
import com.ca.mas.messaging.topic.MASTopic;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UserIdentityManager {
    private static UserIdentityManager instance = new UserIdentityManager();

    public static UserIdentityManager getInstance() {
        return instance;
    }

    private UserIdentityManager() {
    }

    public void getUsersByFilter(MASFilteredRequest filteredRequest, final MASCallback<List<MASUser>> callback) {
        Uri uri = filteredRequest.createUri(MAS.getContext());
        MASRequest masRequest = new MASRequest.MASRequestBuilder(uri).header("Accept", "application/scim+json").header("Content-Type", "application/scim+json").responseBody(MAGResponseBody.jsonBody()).get().build();
        MAS.invoke(masRequest, new MASCallback<MASResponse<JSONObject>>(){

            @Override
            public void onSuccess(MASResponse<JSONObject> result) {
                try {
                    Callback.onSuccess(callback, UserIdentityManager.this.parse((JSONObject)result.getBody().getContent()));
                }
                catch (JSONException e) {
                    Callback.onError(callback, e);
                }
            }

            @Override
            public void onError(Throwable e) {
                Callback.onError(callback, e);
            }
        });
    }

    public void getUserById(String id, final MASCallback<MASUser> callback) {
        Uri.Builder builder = new Uri.Builder();
        String path = IdentityUtil.getUserPath(MAS.getContext());
        builder.appendEncodedPath(path.startsWith("/") ? path.substring(1) : path);
        builder.appendPath(id);
        MASRequest masRequest = new MASRequest.MASRequestBuilder(builder.build()).header("Accept", "application/scim+json").header("Content-Type", "application/scim+json").responseBody(MAGResponseBody.jsonBody()).get().build();
        MAS.invoke(masRequest, new MASCallback<MASResponse<JSONObject>>(){

            @Override
            public void onSuccess(MASResponse<JSONObject> result) {
                try {
                    Callback.onSuccess(callback, UserIdentityManager.this.processUserById((JSONObject)result.getBody().getContent()));
                }
                catch (JSONException e) {
                    Callback.onError(callback, e);
                }
            }

            @Override
            public void onError(Throwable e) {
                Callback.onError(callback, e);
            }
        });
    }

    public void getUserMetaData(final MASCallback<UserAttributes> callback) {
        String schemaPath = IdentityUtil.getSchemasPath(MAS.getContext()) + "/";
        MASRequest masRequest = new MASRequest.MASRequestBuilder(Uri.parse((String)(schemaPath + "urn:ietf:params:scim:schemas:core:2.0:User"))).responseBody(MAGResponseBody.jsonBody()).get().build();
        MAS.invoke(masRequest, new MASCallback<MASResponse<JSONObject>>(){

            @Override
            public void onSuccess(MASResponse<JSONObject> result) {
                try {
                    JSONObject jsonObject = (JSONObject)result.getBody().getContent();
                    UserAttributes userAttributes = UserIdentityManager.this.getAttributes(jsonObject);
                    Callback.onSuccess(callback, userAttributes);
                }
                catch (JSONException e) {
                    Callback.onError(callback, e);
                }
            }

            @Override
            public void onError(Throwable e) {
                Callback.onError(callback, e);
            }
        });
    }

    public Bitmap getUserThumbnailImage(MASUser user) {
        return IdentityUtil.getThumbnail(user.getPhotoList());
    }

    private MASUser processUserById(JSONObject jsonObject) throws JSONException {
        User user = new User();
        if (jsonObject.has("Resources")) {
            JSONArray jsonArray = jsonObject.getJSONArray("Resources");
            int totalResults = jsonObject.optInt("totalResults");
            if (totalResults != 1) {
                throw new IllegalStateException("Should not return more than 1 user");
            }
            JSONObject arrElem = jsonArray.getJSONObject(0);
            user.populate(arrElem);
        } else {
            user.populate(jsonObject);
        }
        return UserIdentityManager.createMASUser(user);
    }

    private UserAttributes getAttributes(JSONObject jsonObject) throws JSONException {
        String id = jsonObject.optString("id");
        if (TextUtils.isEmpty((CharSequence)id)) {
            throw new IllegalArgumentException("The ID cannot be null!");
        }
        if (id.equals("urn:ietf:params:scim:schemas:core:2.0:User")) {
            UserAttributes userAttributes = new UserAttributes();
            userAttributes.populate(jsonObject);
            return userAttributes;
        }
        return null;
    }

    private List<MASUser> parse(JSONObject jsonObject) throws JSONException {
        JSONArray jsonArray;
        ArrayList<MASUser> result = new ArrayList<MASUser>();
        if (jsonObject.has("Resources") && (jsonArray = jsonObject.getJSONArray("Resources")).length() > 0) {
            for (int i = 0; i < jsonArray.length(); ++i) {
                User ident = new User();
                JSONObject arrElem = jsonArray.getJSONObject(i);
                ident.populate(arrElem);
                result.add(UserIdentityManager.createMASUser(ident));
            }
        }
        return result;
    }

    private static MASUser createMASUser(final ScimUser scimUser) {
        return new MASUser(){

            @Override
            public boolean isAuthenticated() {
                return false;
            }

            @Override
            public boolean isCurrentUser() {
                return true;
            }

            @Override
            public void requestUserInfo(MASCallback<Void> callback) {
                new UserNotAuthenticatedException();
            }

            @Override
            public String getUserName() {
                return scimUser.getUserName();
            }

            @Override
            public String getNickName() {
                return scimUser.getNickName();
            }

            @Override
            public String getProfileUrl() {
                return scimUser.getProfileUrl();
            }

            @Override
            public String getUserType() {
                return scimUser.getUserType();
            }

            @Override
            public String getTitle() {
                return scimUser.getTitle();
            }

            @Override
            public String getPreferredLanguage() {
                return scimUser.getPreferredLanguage();
            }

            @Override
            public String getLocale() {
                return scimUser.getLocale();
            }

            @Override
            public String getTimeZone() {
                return scimUser.getTimeZone();
            }

            @Override
            public boolean isActive() {
                return scimUser.isActive();
            }

            @Override
            public String getPassword() {
                return scimUser.getPassword();
            }

            @Override
            public List<MASAddress> getAddressList() {
                return scimUser.getAddressList();
            }

            @Override
            public List<MASEmail> getEmailList() {
                return scimUser.getEmailList();
            }

            @Override
            public List<MASPhone> getPhoneList() {
                return scimUser.getPhoneList();
            }

            @Override
            public List<MASIms> getImsList() {
                return scimUser.getImsList();
            }

            @Override
            public List<MASPhoto> getPhotoList() {
                return scimUser.getPhotoList();
            }

            @Override
            public MASMeta getMeta() {
                return scimUser.getMeta();
            }

            @Override
            public List<MASGroup> getGroupList() {
                return scimUser.getGroupList();
            }

            @Override
            public MASName getName() {
                return scimUser.getName();
            }

            @Override
            public JSONObject getSource() {
                return scimUser.getSource();
            }

            @Override
            public String getId() {
                return scimUser.getId();
            }

            @Override
            public String getExternalId() {
                return scimUser.getExternalId();
            }

            @Override
            public String getDisplayName() {
                return scimUser.getDisplayName();
            }

            @Override
            public long getCardinality() {
                return scimUser.getCardinality();
            }

            @Override
            public void populate(@NonNull JSONObject jsonObject) throws JSONException {
                scimUser.populate(jsonObject);
            }

            @Override
            public JSONObject getAsJSONObject() throws JSONException {
                return scimUser.getAsJSONObject();
            }

            @Override
            public void startListeningToTopic(MASTopic topic, MASCallback<Void> callback) {
                throw new UserNotAuthenticatedException();
            }

            @Override
            public void stopListeningToTopic(MASTopic topic, MASCallback<Void> callback) {
                throw new UserNotAuthenticatedException();
            }

            @Override
            public void sendMessage(MASTopic topic, MASMessage message, MASCallback<Void> callback) {
                throw new UserNotAuthenticatedException();
            }

            @Override
            public void sendMessage(MASMessage message, MASUser user, MASCallback<Void> callback) {
                throw new UserNotAuthenticatedException();
            }

            @Override
            public void sendMessage(MASMessage message, MASUser user, String topic, MASCallback<Void> callback) {
                throw new UserNotAuthenticatedException();
            }

            @Override
            public void startListeningToMyMessages(MASCallback<Void> callback) {
                throw new UserNotAuthenticatedException();
            }

            @Override
            public void stopListeningToMyMessages(MASCallback<Void> callback) {
                throw new UserNotAuthenticatedException();
            }

            @Override
            public void logout(MASCallback<Void> callback) {
                throw new UserNotAuthenticatedException();
            }

            @Override
            public void getUserById(String id, MASCallback<MASUser> callback) {
                throw new UserNotAuthenticatedException();
            }

            @Override
            public void getUsersByFilter(MASFilteredRequest filteredRequest, MASCallback<List<MASUser>> callback) {
                throw new UserNotAuthenticatedException();
            }

            @Override
            public void getUserMetaData(MASCallback<UserAttributes> callback) {
                throw new UserNotAuthenticatedException();
            }

            @Override
            public Bitmap getThumbnailImage() {
                return UserIdentityManager.getInstance().getUserThumbnailImage(this);
            }

            @Override
            public void lockSession(MASCallback<Void> callback) {
                throw new UserNotAuthenticatedException();
            }

            @Override
            public void unlockSession(MASSessionUnlockCallback<Void> callback) {
                throw new UserNotAuthenticatedException();
            }

            @Override
            public boolean isSessionLocked() {
                return false;
            }

            @Override
            public void removeSessionLock(MASCallback<Void> callback) {
                throw new UserNotAuthenticatedException();
            }
        };
    }
}

