/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation;

import android.annotation.TargetApi;
import android.content.AsyncTaskLoader;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Handler;
import android.os.Parcel;
import android.security.keystore.UserNotAuthenticatedException;
import android.support.annotation.NonNull;
import android.util.Log;
import com.ca.mas.connecta.client.MASConnectaManager;
import com.ca.mas.core.MAG;
import com.ca.mas.core.MAGResultReceiver;
import com.ca.mas.core.MobileSso;
import com.ca.mas.core.MobileSsoFactory;
import com.ca.mas.core.error.MAGError;
import com.ca.mas.core.http.MAGResponse;
import com.ca.mas.core.security.DefaultEncryptionProvider;
import com.ca.mas.core.security.EncryptionProvider;
import com.ca.mas.core.security.KeyStorageProvider;
import com.ca.mas.core.security.LockableKeyStorageProvider;
import com.ca.mas.core.security.SecureLockException;
import com.ca.mas.core.store.OAuthTokenContainer;
import com.ca.mas.core.store.StorageProvider;
import com.ca.mas.core.store.TokenManager;
import com.ca.mas.core.store.TokenStoreException;
import com.ca.mas.core.token.IdToken;
import com.ca.mas.core.token.JWTValidation;
import com.ca.mas.core.util.Functions;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASAuthorizationResponse;
import com.ca.mas.foundation.MASCallback;
import com.ca.mas.foundation.MASDevice;
import com.ca.mas.foundation.MASGroup;
import com.ca.mas.foundation.MASIdToken;
import com.ca.mas.foundation.MASResultReceiver;
import com.ca.mas.foundation.MASSessionUnlockCallback;
import com.ca.mas.foundation.MASTransformable;
import com.ca.mas.foundation.UserInfoRepository;
import com.ca.mas.foundation.UserRepository;
import com.ca.mas.foundation.notify.Callback;
import com.ca.mas.foundation.util.FoundationUtil;
import com.ca.mas.identity.common.MASFilteredRequest;
import com.ca.mas.identity.user.MASAddress;
import com.ca.mas.identity.user.MASEmail;
import com.ca.mas.identity.user.MASIms;
import com.ca.mas.identity.user.MASMeta;
import com.ca.mas.identity.user.MASName;
import com.ca.mas.identity.user.MASPhone;
import com.ca.mas.identity.user.MASPhoto;
import com.ca.mas.identity.user.MASUserIdentity;
import com.ca.mas.identity.user.ScimUser;
import com.ca.mas.identity.user.ScimUserRepository;
import com.ca.mas.identity.user.User;
import com.ca.mas.identity.user.UserAttributes;
import com.ca.mas.identity.user.UserIdentityManager;
import com.ca.mas.messaging.MASMessage;
import com.ca.mas.messaging.MASMessenger;
import com.ca.mas.messaging.topic.MASTopic;
import com.ca.mas.messaging.topic.MASTopicBuilder;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class MASUser
implements MASTransformable,
MASMessenger,
MASUserIdentity,
ScimUser {
    private static final String SESSION_LOCK_ALIAS = "com.ca.mas.SESSION_LOCK";
    private static List<UserRepository> userRepositories = new ArrayList<UserRepository>();
    protected static final String TAG;
    private static MASUser current;

    @Deprecated
    public static void login(@NonNull String userName, @NonNull String password, MASCallback<MASUser> callback) {
        MASUser.login(userName, password.toCharArray(), callback);
    }

    public static void login(@NonNull String userName, @NonNull char[] cPassword, final MASCallback<MASUser> callback) {
        MobileSso mobileSso = FoundationUtil.getMobileSso();
        mobileSso.authenticate(userName, cPassword, (MAGResultReceiver)new MASResultReceiver<JSONObject>(){

            public void onSuccess(MAGResponse<JSONObject> response) {
                MASUser.login(callback);
            }

            public void onError(MAGError error) {
                current = null;
                Callback.onError(callback, (Throwable)error);
            }
        });
    }

    public static void login(MASIdToken idToken, final MASCallback<MASUser> callback) {
        MobileSso mobileSso = FoundationUtil.getMobileSso();
        mobileSso.authenticate((IdToken)idToken, (MAGResultReceiver)new MASResultReceiver<JSONObject>(){

            public void onSuccess(MAGResponse<JSONObject> response) {
                MASUser.login(callback);
            }

            public void onError(MAGError error) {
                current = null;
                Callback.onError(callback, (Throwable)error);
            }
        });
    }

    public static void login(final MASCallback<MASUser> callback) {
        final MASUser user = MASUser.createMASUser();
        user.requestUserInfo(new MASCallback<Void>(){

            @Override
            public void onSuccess(Void result) {
                current = user;
                Callback.onSuccess(callback, current);
            }

            @Override
            public void onError(Throwable e) {
                Callback.onError(callback, e);
            }
        });
    }

    public static void login(@NonNull MASAuthorizationResponse authorizationResponse, final MASCallback<MASUser> callback) {
        MobileSso mobileSso = FoundationUtil.getMobileSso();
        mobileSso.authenticate(authorizationResponse.getAuthorizationCode(), authorizationResponse.getState(), (MAGResultReceiver)new MASResultReceiver<JSONObject>(){

            public void onSuccess(MAGResponse<JSONObject> response) {
                MASUser.login(callback);
            }

            public void onError(MAGError error) {
                current = null;
                Callback.onError(callback, (Throwable)error);
            }
        });
    }

    public static MASUser getCurrentUser() {
        TokenManager tokenManager;
        if (current == null && (tokenManager = MASDevice.createTokenManager()).getUserProfile() != null) {
            current = MASUser.createMASUser();
        }
        if (current != null && !current.isAuthenticated() && !current.isSessionLocked()) {
            current = null;
        }
        return current;
    }

    private static MASUser createMASUser() {
        return new MASUser(){
            private TokenManager tokenManager = new StorageProvider(MAS.getContext()).createTokenManager();
            private ScimUser scimUser = this.getLocalUserProfile();
            private LockableKeyStorageProvider mKeyStoreProvider = new LockableKeyStorageProvider();

            @Override
            public boolean isAuthenticated() {
                return MobileSsoFactory.getInstance().isLogin();
            }

            @Override
            public boolean isCurrentUser() {
                return true;
            }

            @Override
            public String getUserName() {
                return this.scimUser.getUserName();
            }

            @Override
            public String getNickName() {
                return this.scimUser.getNickName();
            }

            @Override
            public String getProfileUrl() {
                return this.scimUser.getProfileUrl();
            }

            @Override
            public String getUserType() {
                return this.scimUser.getUserType();
            }

            @Override
            public String getTitle() {
                return this.scimUser.getTitle();
            }

            @Override
            public String getPreferredLanguage() {
                return this.scimUser.getPreferredLanguage();
            }

            @Override
            public String getLocale() {
                return this.scimUser.getLocale();
            }

            @Override
            public String getTimeZone() {
                return this.scimUser.getTimeZone();
            }

            @Override
            public boolean isActive() {
                return this.scimUser.isActive();
            }

            @Override
            public String getPassword() {
                return this.scimUser.getPassword();
            }

            @Override
            public List<MASAddress> getAddressList() {
                return this.scimUser.getAddressList();
            }

            @Override
            public List<MASEmail> getEmailList() {
                return this.scimUser.getEmailList();
            }

            @Override
            public List<MASPhone> getPhoneList() {
                return this.scimUser.getPhoneList();
            }

            @Override
            public List<MASIms> getImsList() {
                return this.scimUser.getImsList();
            }

            @Override
            public List<MASPhoto> getPhotoList() {
                return this.scimUser.getPhotoList();
            }

            @Override
            public MASMeta getMeta() {
                return this.scimUser.getMeta();
            }

            @Override
            public List<MASGroup> getGroupList() {
                return this.scimUser.getGroupList();
            }

            @Override
            public MASName getName() {
                return this.scimUser.getName();
            }

            @Override
            public JSONObject getSource() {
                return this.scimUser.getSource();
            }

            @Override
            public String getId() {
                return this.scimUser.getId();
            }

            @Override
            public String getExternalId() {
                return this.scimUser.getExternalId();
            }

            @Override
            public String getDisplayName() {
                return this.scimUser.getDisplayName();
            }

            @Override
            public long getCardinality() {
                return this.scimUser.getCardinality();
            }

            @Override
            public void populate(@NonNull JSONObject jsonObject) throws JSONException {
                throw new UnsupportedOperationException();
            }

            @Override
            public JSONObject getAsJSONObject() throws JSONException {
                return this.scimUser.getAsJSONObject();
            }

            @Override
            public void startListeningToTopic(final MASTopic topic, final MASCallback<Void> callback) {
                this.execute(new Functions.NullaryVoid(){

                    public void call() {
                        MASConnectaManager.getInstance().subscribe(topic, callback);
                    }
                }, callback);
            }

            @Override
            public void stopListeningToTopic(final MASTopic topic, final MASCallback<Void> callback) {
                this.execute(new Functions.NullaryVoid(){

                    public void call() {
                        MASConnectaManager.getInstance().unsubscribe(topic, callback);
                    }
                }, callback);
            }

            @Override
            public void sendMessage(final MASTopic topic, final MASMessage message, final MASCallback<Void> callback) {
                this.execute(new Functions.NullaryVoid(){

                    public void call() {
                        MASConnectaManager.getInstance().publish(topic, message, (MASCallback<Void>)callback);
                    }
                }, callback);
            }

            @Override
            public void sendMessage(@NonNull MASMessage message, MASUser user, MASCallback<Void> callback) {
                String userId = user.getId();
                this.sendMessage(message, user, userId, callback);
            }

            @Override
            public void sendMessage(final @NonNull MASMessage message, final MASUser user, final String topic, final MASCallback<Void> callback) {
                this.execute(new Functions.NullaryVoid(){

                    public void call() {
                        String userId = user.getId();
                        MASTopic masTopic = new MASTopicBuilder().setUserId(userId).setCustomTopic(topic).build();
                        MASConnectaManager.getInstance().publish(masTopic, message, (MASCallback<Void>)callback);
                    }
                }, callback);
            }

            @Override
            public void startListeningToMyMessages(final MASCallback<Void> callback) {
                this.execute(new Functions.NullaryVoid(){

                    public void call() {
                        String userId = current.getId();
                        MASTopic masTopic = new MASTopicBuilder().setUserId(userId).setCustomTopic("#").build();
                        this.startListeningToTopic(masTopic, callback);
                    }
                }, callback);
            }

            @Override
            public void stopListeningToMyMessages(final MASCallback<Void> callback) {
                this.execute(new Functions.NullaryVoid(){

                    public void call() {
                        String userId = current.getId();
                        MASTopic masTopic = new MASTopicBuilder().setUserId(userId).setCustomTopic("#").build();
                        this.stopListeningToTopic(masTopic, callback);
                    }
                }, callback);
            }

            private void execute(final Functions.NullaryVoid function, final MASCallback<Void> callback) {
                if (this.getUserName() == null) {
                    5.login(new MASCallback<MASUser>(){

                        @Override
                        public Handler getHandler() {
                            return Callback.getHandler(callback);
                        }

                        @Override
                        public void onSuccess(MASUser object) {
                            function.call();
                        }

                        @Override
                        public void onError(Throwable e) {
                            Callback.onError(callback, e);
                        }
                    });
                } else {
                    function.call();
                }
            }

            @Override
            public void logout(final MASCallback<Void> callback) {
                current = null;
                new AsyncTaskLoader<Object>(MAS.getContext()){

                    protected void onStartLoading() {
                        super.onStartLoading();
                        this.forceLoad();
                    }

                    public Object loadInBackground() {
                        try {
                            if (!this.isSessionLocked()) {
                                MobileSsoFactory.getInstance().logout(true);
                                Callback.onSuccess(callback, null);
                            } else {
                                Callback.onError(callback, (Throwable)new SecureLockException("The session is currently locked."));
                            }
                        }
                        catch (Exception e) {
                            Callback.onError(callback, e);
                        }
                        return null;
                    }
                }.startLoading();
            }

            @Override
            public void getUserById(String id, MASCallback<MASUser> callback) {
                UserIdentityManager.getInstance().getUserById(id, callback);
            }

            @Override
            public void getUsersByFilter(MASFilteredRequest filteredRequest, MASCallback<List<MASUser>> callback) {
                UserIdentityManager.getInstance().getUsersByFilter(filteredRequest, callback);
            }

            @Override
            public void getUserMetaData(MASCallback<UserAttributes> callback) {
                UserIdentityManager.getInstance().getUserMetaData(callback);
            }

            @Override
            public Bitmap getThumbnailImage() {
                return UserIdentityManager.getInstance().getUserThumbnailImage(this);
            }

            @Override
            public void requestUserInfo(MASCallback<Void> callback) {
                LinkedList<UserRepository> repositories = new LinkedList<UserRepository>(userRepositories);
                this.fetch(repositories, callback, null);
            }

            private void fetch(final LinkedList<UserRepository> repositories, final MASCallback<Void> callback, Throwable e) {
                UserRepository f;
                try {
                    f = repositories.pop();
                }
                catch (NoSuchElementException nse) {
                    Callback.onError(callback, e);
                    return;
                }
                f.findByUsername(this.getUserName(), new MASCallback<ScimUser>(){

                    @Override
                    public void onSuccess(ScimUser result) {
                        block2: {
                            scimUser = result;
                            try {
                                JSONObject source = scimUser.getSource();
                                source.remove("password");
                                tokenManager.saveUserProfile(source.toString());
                            }
                            catch (Exception e) {
                                if (!MAG.DEBUG) break block2;
                                Log.w((String)TAG, (String)"Unable to persist user profile to local storage.", (Throwable)e);
                            }
                        }
                        Callback.onSuccess(callback, null);
                    }

                    @Override
                    public void onError(Throwable e) {
                        this.fetch(repositories, callback, e);
                    }
                });
            }

            private ScimUser getLocalUserProfile() {
                User user;
                block3: {
                    user = new User();
                    try {
                        String userProfile = this.tokenManager.getUserProfile();
                        if (userProfile != null) {
                            user.populate(new JSONObject(userProfile));
                        }
                    }
                    catch (Exception e) {
                        if (!MAG.DEBUG) break block3;
                        Log.w((String)TAG, (String)"Failed to populate MASUser from local storage.", (Throwable)e);
                    }
                }
                return user;
            }

            @Override
            @TargetApi(value=23)
            public void lockSession(MASCallback<Void> callback) {
                if (Build.VERSION.SDK_INT >= 23) {
                    MASUser currentUser = MASUser.getCurrentUser();
                    if (currentUser == null) {
                        Callback.onError(callback, (Throwable)new SecureLockException("No currently authenticated user."));
                    } else if (this.isSessionLocked()) {
                        Callback.onSuccess(callback, null);
                    } else {
                        TokenManager keyChainManager = MASDevice.createTokenManager();
                        IdToken idToken = keyChainManager.getIdToken();
                        if (idToken == null) {
                            Callback.onError(callback, (Throwable)new SecureLockException("Failed to retrieve ID token."));
                            return;
                        }
                        StorageProvider storageProvider = MASDevice.createStorageProvider();
                        OAuthTokenContainer container = storageProvider.createOAuthTokenContainer();
                        container.clear();
                        Parcel idTokenParcel = Parcel.obtain();
                        idToken.writeToParcel(idTokenParcel, 0);
                        byte[] idTokenBytes = idTokenParcel.marshall();
                        this.mKeyStoreProvider.removeKey(MASUser.SESSION_LOCK_ALIAS);
                        EncryptionProvider encryptionProvider = this.getSessionLockEncryptionProvider();
                        byte[] encryptedData = encryptionProvider.encrypt(idTokenBytes);
                        try {
                            keyChainManager.saveSecureIdToken(encryptedData);
                        }
                        catch (TokenStoreException e) {
                            Callback.onError(callback, (Throwable)new SecureLockException("Failed to save encrypted ID token.", (Throwable)e));
                            return;
                        }
                        try {
                            keyChainManager.deleteIdToken();
                        }
                        catch (TokenStoreException e) {
                            Callback.onError(callback, (Throwable)new SecureLockException("Failed to delete encrypted ID token.", (Throwable)e));
                            return;
                        }
                        this.mKeyStoreProvider.lock(MASUser.SESSION_LOCK_ALIAS);
                        idTokenParcel.recycle();
                        Callback.onSuccess(callback, null);
                    }
                }
            }

            @Override
            public void unlockSession(MASSessionUnlockCallback<Void> callback) {
                block13: {
                    if (Build.VERSION.SDK_INT >= 23) {
                        if (this.isSessionLocked()) {
                            TokenManager keyChainManager = MASDevice.createTokenManager();
                            byte[] secureIdToken = keyChainManager.getSecureIdToken();
                            EncryptionProvider encryptionProvider = this.getSessionLockEncryptionProvider();
                            Parcel parcel = Parcel.obtain();
                            try {
                                byte[] decryptedData = encryptionProvider.decrypt(secureIdToken);
                                parcel.unmarshall(decryptedData, 0, decryptedData.length);
                                parcel.setDataPosition(0);
                                IdToken idToken = (IdToken)IdToken.CREATOR.createFromParcel(parcel);
                                try {
                                    keyChainManager.saveIdToken(idToken);
                                }
                                catch (TokenStoreException e) {
                                    Callback.onError(callback, (Throwable)new SecureLockException("Failed to save ID token.", (Throwable)e));
                                    return;
                                }
                                try {
                                    keyChainManager.deleteSecureIdToken();
                                }
                                catch (TokenStoreException e) {
                                    Callback.onError(callback, (Throwable)new SecureLockException("Failed to delete encrypted ID token.", (Throwable)e));
                                    return;
                                }
                                this.mKeyStoreProvider.removeKey(MASUser.SESSION_LOCK_ALIAS);
                                boolean isTokenExpired = JWTValidation.isIdTokenExpired((IdToken)idToken);
                                if (!isTokenExpired) {
                                    Callback.onSuccess(callback, null);
                                    break block13;
                                }
                                this.logout(null);
                                Callback.onError(callback, (Throwable)new SecureLockException("ID token is expired."));
                            }
                            catch (Exception e) {
                                if (e.getCause() != null && e.getCause() instanceof UserNotAuthenticatedException) {
                                    if (callback != null) {
                                        callback.onUserAuthenticationRequired();
                                    }
                                    break block13;
                                }
                                Callback.onError(callback, e);
                            }
                        } else {
                            Callback.onSuccess(callback, null);
                        }
                    } else {
                        Callback.onError(callback, new IllegalAccessException("Device API level does not meet the target API requirements."));
                    }
                }
            }

            @Override
            public boolean isSessionLocked() {
                TokenManager keyChainManager = MASDevice.createTokenManager();
                return keyChainManager.getSecureIdToken() != null;
            }

            @Override
            public void removeSessionLock(MASCallback<Void> callback) {
                if (!this.isSessionLocked()) {
                    Callback.onSuccess(callback, null);
                } else {
                    try {
                        TokenManager keyChainManager = MASDevice.createTokenManager();
                        keyChainManager.deleteSecureIdToken();
                        Callback.onSuccess(callback, null);
                    }
                    catch (TokenStoreException e) {
                        Callback.onError(callback, (Throwable)new SecureLockException("Failed to delete encrypted ID token.", (Throwable)e));
                    }
                }
            }

            private EncryptionProvider getSessionLockEncryptionProvider() {
                return new DefaultEncryptionProvider(MAS.getContext(), (KeyStorageProvider)this.mKeyStoreProvider){

                    protected String getKeyAlias() {
                        return MASUser.SESSION_LOCK_ALIAS;
                    }
                };
            }
        };
    }

    public abstract void logout(MASCallback<Void> var1);

    public abstract boolean isAuthenticated();

    public abstract boolean isCurrentUser();

    public abstract void requestUserInfo(MASCallback<Void> var1);

    @TargetApi(value=23)
    public abstract void lockSession(MASCallback<Void> var1);

    @TargetApi(value=23)
    public abstract void unlockSession(MASSessionUnlockCallback<Void> var1);

    @TargetApi(value=23)
    public abstract boolean isSessionLocked();

    @TargetApi(value=23)
    public abstract void removeSessionLock(MASCallback<Void> var1);

    static {
        userRepositories = new ArrayList<UserRepository>();
        userRepositories.add(new ScimUserRepository());
        userRepositories.add(new UserInfoRepository());
        TAG = MASUser.class.getSimpleName();
    }
}

