/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation;

import android.util.Pair;
import com.ca.mas.core.http.ContentType;
import com.ca.mas.core.http.MAGRequestBody;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.json.JSONObject;

public abstract class MASRequestBody
extends MAGRequestBody {
    public static MASRequestBody byteArrayBody(byte[] body) {
        return MASRequestBody.transform(MAGRequestBody.byteArrayBody((byte[])body));
    }

    public static MASRequestBody stringBody(String body) {
        return MASRequestBody.transform(MAGRequestBody.stringBody((String)body));
    }

    public static MASRequestBody jsonBody(JSONObject jsonObject) {
        return MASRequestBody.transform(MAGRequestBody.jsonBody((JSONObject)jsonObject));
    }

    public static MASRequestBody urlEncodedFormBody(List<? extends Pair<String, String>> form) {
        return MASRequestBody.transform(MAGRequestBody.urlEncodedFormBody(form));
    }

    private static MASRequestBody transform(final MAGRequestBody requestBody) {
        return new MASRequestBody(){

            public ContentType getContentType() {
                return requestBody.getContentType();
            }

            public long getContentLength() {
                return requestBody.getContentLength();
            }

            public void write(OutputStream outputStream) throws IOException {
                requestBody.write(outputStream);
            }
        };
    }
}

