/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation;

import android.net.Uri;
import com.ca.mas.core.conf.ConfigurationManager;
import com.ca.mas.core.http.MAGRequest;
import com.ca.mas.core.http.MAGRequestBody;
import com.ca.mas.core.http.MAGResponseBody;
import com.ca.mas.core.oauth.GrantProvider;
import com.ca.mas.foundation.MASRequestBody;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Map;

public interface MASRequest
extends MAGRequest {
    public boolean notifyOnCancel();

    public static class MASRequestBuilder
    extends MAGRequest.MAGRequestBuilder {
        private boolean notifyOnCancel = false;

        public MASRequestBuilder(URI uri) {
            super(ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getUri(uri.toString()));
        }

        public MASRequestBuilder(Uri uri) {
            super(ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getUri(uri.toString()));
        }

        public MASRequestBuilder(URL url) {
            super(ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getUri(url.toString()));
        }

        public MASRequestBuilder get() {
            return (MASRequestBuilder)super.get();
        }

        public MASRequestBuilder post(MASRequestBody body) {
            return (MASRequestBuilder)super.post((MAGRequestBody)body);
        }

        public MASRequestBuilder put(MASRequestBody body) {
            return (MASRequestBuilder)super.put((MAGRequestBody)body);
        }

        public MASRequestBuilder delete(MASRequestBody body) {
            return (MASRequestBuilder)super.delete((MAGRequestBody)body);
        }

        public MASRequestBuilder password() {
            return (MASRequestBuilder)super.password();
        }

        public MASRequestBuilder clientCredential() {
            return (MASRequestBuilder)super.clientCredential();
        }

        public MASRequestBuilder scope(String scope) {
            return (MASRequestBuilder)super.scope(scope);
        }

        public MASRequestBuilder responseBody(MAGResponseBody responseBody) {
            return (MASRequestBuilder)super.responseBody(responseBody);
        }

        public MASRequestBuilder setPublic() {
            return (MASRequestBuilder)super.setPublic();
        }

        public MASRequestBuilder header(String name, String value) {
            return (MASRequestBuilder)super.header(name, value);
        }

        public MASRequestBuilder removeHeader(String name) {
            return (MASRequestBuilder)super.removeHeader(name);
        }

        public MASRequestBuilder connectionListener(MAGRequest.MAGConnectionListener listener) {
            return (MASRequestBuilder)super.connectionListener(listener);
        }

        public MASRequestBuilder notifyOnCancel() {
            this.notifyOnCancel = true;
            return this;
        }

        public MASRequest build() {
            final MAGRequest request = super.build();
            return new MASRequest(){

                @Override
                public boolean notifyOnCancel() {
                    return MASRequestBuilder.this.notifyOnCancel;
                }

                public URL getURL() {
                    return request.getURL();
                }

                public String getMethod() {
                    return request.getMethod();
                }

                public Map<String, List<String>> getHeaders() {
                    return request.getHeaders();
                }

                public GrantProvider getGrantProvider() {
                    return request.getGrantProvider();
                }

                public MAGRequestBody getBody() {
                    return request.getBody();
                }

                public MAGRequest.MAGConnectionListener getConnectionListener() {
                    return request.getConnectionListener();
                }

                public MAGResponseBody<?> getResponseBody() {
                    return request.getResponseBody();
                }

                public String getScope() {
                    return request.getScope();
                }

                public boolean isPublic() {
                    return request.isPublic();
                }
            };
        }
    }
}

