/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.connecta.util;

import android.support.annotation.NonNull;
import com.ca.mas.foundation.MASUser;
import com.ca.mas.foundation.util.FoundationUtil;
import com.ca.mas.messaging.MASMessage;
import com.ca.mas.messaging.MASMessageException;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class ConnectaUtil
extends FoundationUtil {
    public static String getMqttClientId(String clientId, String magIdentifier, boolean isGateway) {
        String mqttClientId = "";
        if (isGateway) {
            mqttClientId = mqttClientId + magIdentifier + "::";
        }
        mqttClientId = mqttClientId + clientId;
        if (MASUser.getCurrentUser() != null) {
            mqttClientId = mqttClientId + "::" + MASUser.getCurrentUser().getUserName();
        }
        return mqttClientId;
    }

    public static MASMessage createMASMessageFromMqtt(@NonNull MqttMessage mqttMessage) {
        MASMessage masMessage = ConnectaUtil.initMessageFromPayload(mqttMessage.getPayload());
        masMessage.setDuplicate(mqttMessage.isDuplicate());
        masMessage.setRetained(mqttMessage.isRetained());
        return masMessage;
    }

    public static MqttConnectOptions createConnectionOptions(String brokerUrl, long timeOutInMillis) {
        MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
        if (timeOutInMillis >= 30000L) {
            int toSeconds = (int)(timeOutInMillis / 1000L);
            mqttConnectOptions.setConnectionTimeout(toSeconds);
        }
        String[] servers = new String[]{brokerUrl};
        mqttConnectOptions.setServerURIs(servers);
        return mqttConnectOptions;
    }

    private static MASMessage initMessageFromPayload(byte[] payload) {
        String totalPayload = new String(payload);
        MASMessage m = MASMessage.newInstance();
        try {
            m.createMASMessageFromJSONString(totalPayload);
        }
        catch (MASMessageException e) {
            m.setPayload(payload);
        }
        return m;
    }
}

