/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.connecta.client;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.support.annotation.NonNull;
import com.ca.mas.connecta.client.ConnectaException;
import com.ca.mas.connecta.client.MASConnectOptions;
import com.ca.mas.connecta.client.MASConnectaClient;
import com.ca.mas.connecta.client.MASConnectaListener;
import com.ca.mas.connecta.serviceprovider.ConnectaService;
import com.ca.mas.core.EventDispatcher;
import com.ca.mas.core.util.Functions;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASCallback;
import com.ca.mas.foundation.notify.Callback;
import com.ca.mas.messaging.MASMessage;
import com.ca.mas.messaging.topic.MASTopic;
import java.util.Observable;
import java.util.Observer;

public class MASConnectaManager
implements MASConnectaClient,
Observer {
    private static MASConnectaManager instance = new MASConnectaManager();
    private ConnectaService mMASTransportService;
    private long mTimeOutInMillis;
    private MASConnectOptions mConnectOptions;
    private MASConnectaListener connectaListener;
    private MASCallback<Void> connectCallback;
    private String clientId;
    private final ServiceConnection mServiceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            ConnectaService.ServiceBinder masBinder = (ConnectaService.ServiceBinder)iBinder;
            MASConnectaManager.this.mMASTransportService = masBinder.getService();
            if (MASConnectaManager.this.mMASTransportService != null) {
                MASConnectaManager.this.mMASTransportService.setClientId(MASConnectaManager.this.clientId);
                MASConnectaManager.this.mMASTransportService.setConnectaListener(MASConnectaManager.this.connectaListener);
                MASConnectaManager.this.mMASTransportService.setTimeOutInMillis(MASConnectaManager.this.getTimeOutInMillis());
                MASConnectaManager.this.mMASTransportService.setConnectOptions(MASConnectaManager.this.mConnectOptions);
                MASConnectaManager.this.mMASTransportService.connect(new MASCallback<Void>(){

                    @Override
                    public Handler getHandler() {
                        return Callback.getHandler(MASConnectaManager.this.connectCallback);
                    }

                    @Override
                    public void onSuccess(Void object) {
                        if (MASConnectaManager.this.connectaListener != null) {
                            MASConnectaManager.this.mMASTransportService.setConnectaListener(MASConnectaManager.this.connectaListener);
                        }
                        Callback.onSuccess(MASConnectaManager.this.connectCallback, null);
                        MASConnectaManager.this.connectCallback = null;
                    }

                    @Override
                    public void onError(Throwable e) {
                        Callback.onError(MASConnectaManager.this.connectCallback, e);
                        MASConnectaManager.this.connectCallback = null;
                    }
                });
            } else {
                Callback.onError(MASConnectaManager.this.connectCallback, new ConnectaException("Failed to bind Transport Service"));
                MASConnectaManager.this.connectCallback = null;
            }
        }

        public void onServiceDisconnected(ComponentName componentName) {
            MASConnectaManager.this.mMASTransportService = null;
        }
    };

    private MASConnectaManager() {
        EventDispatcher.LOGOUT.addObserver((Observer)this);
        EventDispatcher.DE_REGISTER.addObserver((Observer)this);
        EventDispatcher.RESET_LOCALLY.addObserver((Observer)this);
        EventDispatcher.BEFORE_GATEWAY_SWITCH.addObserver((Observer)this);
    }

    public static MASConnectaManager getInstance() {
        return instance;
    }

    public void setConnectaListener(MASConnectaListener listener) {
        this.connectaListener = listener;
    }

    public void stop() {
        this.disconnect(null);
    }

    @Override
    public synchronized void connect(MASCallback<Void> callback) {
        if (this.isConnected()) {
            Callback.onSuccess(callback, null);
            return;
        }
        if (this.mMASTransportService == null) {
            this.connectCallback = callback;
            Intent intent = new Intent(MAS.getContext(), ConnectaService.class);
            MAS.getContext().bindService(intent, this.mServiceConnection, 1);
        } else {
            this.mMASTransportService.connect(callback);
        }
    }

    @Override
    public void disconnect(MASCallback<Void> callback) {
        this.mConnectOptions = null;
        if (this.mMASTransportService != null) {
            this.mMASTransportService.disconnect(callback);
            MAS.getContext().unbindService(this.mServiceConnection);
            this.mMASTransportService = null;
        }
    }

    @Override
    public void subscribe(final @NonNull MASTopic masTopic, final MASCallback<Void> callback) {
        this.connectAndExecute(new Functions.NullaryVoid(){

            public void call() {
                MASConnectaManager.this.subscribeTopic(masTopic, callback);
            }
        }, callback);
    }

    private void subscribeTopic(final @NonNull MASTopic topic, final MASCallback<Void> callback) {
        Handler h = new Handler(MAS.getContext().getMainLooper());
        h.post(new Runnable(){

            @Override
            public void run() {
                MASConnectaManager.this.mMASTransportService.subscribe(topic, callback);
            }
        });
    }

    private void connectAndExecute(final @NonNull Functions.NullaryVoid function, final MASCallback<Void> callback) {
        if (!this.isConnected()) {
            this.connect(new MASCallback<Void>(){

                @Override
                public Handler getHandler() {
                    return Callback.getHandler(callback);
                }

                @Override
                public void onSuccess(Void result) {
                    function.call();
                }

                @Override
                public void onError(Throwable e) {
                    Callback.onError(callback, e);
                }
            });
        } else {
            function.call();
        }
    }

    @Override
    public void unsubscribe(final @NonNull MASTopic masTopic, final MASCallback<Void> callback) {
        this.connectAndExecute(new Functions.NullaryVoid(){

            public void call() {
                MASConnectaManager.this.unsubscribeTopic(masTopic, callback);
            }
        }, callback);
    }

    private void unsubscribeTopic(@NonNull MASTopic topic, MASCallback<Void> callback) {
        this.mMASTransportService.unsubscribe(topic, callback);
    }

    public void publish(@NonNull MASTopic masTopic, @NonNull String message, MASCallback<Void> callback) {
        this.publish(masTopic, message.getBytes(), callback);
    }

    @Override
    public void publish(final @NonNull MASTopic masTopic, final @NonNull byte[] message, final MASCallback<Void> callback) {
        this.connectAndExecute(new Functions.NullaryVoid(){

            public void call() {
                MASConnectaManager.this.publishTopic(masTopic, message, callback);
            }
        }, callback);
    }

    @Override
    public void publish(final @NonNull MASTopic masTopic, final @NonNull MASMessage masMessage, final MASCallback<Void> callback) {
        this.connectAndExecute(new Functions.NullaryVoid(){

            public void call() {
                MASConnectaManager.this.mMASTransportService.publish(masTopic, masMessage, (MASCallback<Void>)callback);
            }
        }, callback);
    }

    private void publishTopic(final @NonNull MASTopic masTopic, final @NonNull byte[] message, final MASCallback<Void> callback) {
        Handler h = new Handler(MAS.getContext().getMainLooper());
        h.post(new Runnable(){

            @Override
            public void run() {
                MASConnectaManager.this.mMASTransportService.publish(masTopic, message, (MASCallback<Void>)callback);
            }
        });
    }

    @Override
    public boolean isConnected() {
        return this.mMASTransportService != null && this.mMASTransportService.isConnected();
    }

    @Override
    public void setConnectOptions(MASConnectOptions connectOptions) {
        this.mConnectOptions = connectOptions;
        if (this.mMASTransportService != null) {
            this.mMASTransportService.setConnectOptions(connectOptions);
        }
    }

    @Override
    public void setTimeOutInMillis(long timeOutInMillis) {
        this.mTimeOutInMillis = timeOutInMillis;
    }

    @Override
    public long getTimeOutInMillis() {
        return this.mTimeOutInMillis;
    }

    @Override
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @Override
    public void update(Observable o, Object arg) {
        try {
            this.disconnect(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

