/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.websocket;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.paho.client.mqttv3.internal.websocket.Base64;
import org.eclipse.paho.client.mqttv3.internal.websocket.HandshakeFailedException;

public class WebSocketHandshake {
    private static final String ACCEPT_SALT = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private static final String SHA1_PROTOCOL = "SHA1";
    private static final String HTTP_HEADER_SEC_WEBSOCKET_ACCEPT = "sec-websocket-accept";
    private static final String HTTP_HEADER_UPGRADE = "upgrade";
    private static final String HTTP_HEADER_UPGRADE_WEBSOCKET = "websocket";
    private static final String EMPTY = "";
    private static final String LINE_SEPARATOR = "\r\n";
    InputStream input;
    OutputStream output;
    String host;
    int port;

    public WebSocketHandshake(InputStream input, OutputStream output, String host, int port) {
        this.input = input;
        this.output = output;
        this.host = host;
        this.port = port;
    }

    public void execute() throws IOException {
        String key = "mqtt-" + System.currentTimeMillis() / 1000L;
        String b64Key = Base64.encode(key);
        this.sendHandshakeRequest(b64Key);
        this.receiveHandshakeResponse(b64Key);
    }

    private void sendHandshakeRequest(String key) throws IOException {
        PrintWriter pw = new PrintWriter(this.output);
        pw.print("GET /mqtt HTTP/1.1\r\n");
        pw.print("Host: " + this.host + ":" + this.port + LINE_SEPARATOR);
        pw.print("Upgrade: websocket\r\n");
        pw.print("Connection: Upgrade\r\n");
        pw.print("Sec-WebSocket-Key: " + key + LINE_SEPARATOR);
        pw.print("Sec-WebSocket-Protocol: mqtt\r\n");
        pw.print("Sec-WebSocket-Version: 13\r\n");
        pw.print(LINE_SEPARATOR);
        pw.flush();
    }

    /*
     * Unable to fully structure code
     */
    private void receiveHandshakeResponse(String key) throws IOException {
        in = new BufferedReader(new InputStreamReader(this.input));
        responseLines = new ArrayList<String>();
        line = in.readLine();
        if (line != null) ** GOTO lbl9
        throw new IOException("WebSocket Response header: Invalid response from Server, It may not support WebSockets.");
lbl-1000:
        // 1 sources

        {
            responseLines.add(line);
            line = in.readLine();
lbl9:
            // 2 sources

            ** while (!line.equals((Object)""))
        }
lbl10:
        // 1 sources

        headerMap = this.getHeaders(responseLines);
        upgradeHeader = (String)headerMap.get("upgrade");
        if (!upgradeHeader.toLowerCase().contains("websocket")) {
            throw new IOException("WebSocket Response header: Incorrect upgrade.");
        }
        if (!headerMap.containsKey("sec-websocket-accept")) {
            throw new IOException("WebSocket Response header: Missing Sec-WebSocket-Accept");
        }
        try {
            this.verifyWebSocketKey(key, (String)headerMap.get("sec-websocket-accept"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e.getMessage());
        }
        catch (HandshakeFailedException v0) {
            throw new IOException("WebSocket Response header: Incorrect Sec-WebSocket-Key");
        }
    }

    private Map getHeaders(ArrayList headers) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        int i = 1;
        while (i < headers.size()) {
            String headerPre = (String)headers.get(i);
            String[] header = headerPre.split(":");
            headerMap.put(header[0].toLowerCase(), header[1]);
            ++i;
        }
        return headerMap;
    }

    private void verifyWebSocketKey(String key, String accept) throws NoSuchAlgorithmException, HandshakeFailedException {
        byte[] sha1Bytes = this.sha1(String.valueOf(key) + ACCEPT_SALT);
        String encodedSha1Bytes = Base64.encodeBytes(sha1Bytes).trim();
        if (!encodedSha1Bytes.equals(encodedSha1Bytes)) {
            throw new HandshakeFailedException();
        }
    }

    private byte[] sha1(String input) throws NoSuchAlgorithmException {
        MessageDigest mDigest = MessageDigest.getInstance(SHA1_PROTOCOL);
        byte[] result = mDigest.digest(input.getBytes());
        return result;
    }
}

