/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.websocket;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.internal.SSLNetworkModule;
import org.eclipse.paho.client.mqttv3.internal.websocket.WebSocketFrame;
import org.eclipse.paho.client.mqttv3.internal.websocket.WebSocketHandshake;
import org.eclipse.paho.client.mqttv3.internal.websocket.WebSocketReceiver;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class WebSocketSecureNetworkModule
extends SSLNetworkModule {
    private static final String CLASS_NAME;
    private static final Logger log;
    private PipedInputStream pipedInputStream;
    private WebSocketReceiver webSocketReceiver;
    private String host;
    private int port;
    ByteBuffer recievedPayload;
    private ByteArrayOutputStream outputStream = new ByteArrayOutputStream(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            ByteBuffer byteBuffer;
            1 var2_1 = this;
            synchronized (var2_1) {
                byteBuffer = ByteBuffer.wrap(this.toByteArray());
                this.reset();
            }
            WebSocketFrame frame = new WebSocketFrame(2, true, byteBuffer.array());
            byte[] rawFrame = frame.encodeFrame();
            WebSocketSecureNetworkModule.this.getSocketOutputStream().write(rawFrame);
            WebSocketSecureNetworkModule.this.getSocketOutputStream().flush();
        }
    };
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.paho.client.mqttv3.internal.websocket.WebSocketSecureNetworkModule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CLASS_NAME = clazz.getName();
        log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", CLASS_NAME);
    }

    public WebSocketSecureNetworkModule(SSLSocketFactory factory, String host, int port, String clientId) {
        super(factory, host, port, clientId);
        this.host = host;
        this.port = port;
        this.pipedInputStream = new PipedInputStream();
        log.setResourceName(clientId);
    }

    public void start() throws IOException, MqttException {
        super.start();
        WebSocketHandshake handshake = new WebSocketHandshake(super.getInputStream(), super.getOutputStream(), this.host, this.port);
        handshake.execute();
        this.webSocketReceiver = new WebSocketReceiver(this.getSocketInputStream(), this.pipedInputStream);
        this.webSocketReceiver.start("WssSocketReceiver");
    }

    private OutputStream getSocketOutputStream() throws IOException {
        return super.getOutputStream();
    }

    private InputStream getSocketInputStream() throws IOException {
        return super.getInputStream();
    }

    public InputStream getInputStream() throws IOException {
        return this.pipedInputStream;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    public void stop() throws IOException {
        if (this.webSocketReceiver != null) {
            this.webSocketReceiver.stop();
        }
        super.stop();
    }

    public String getServerURI() {
        return "wss://" + this.host + ":" + this.port;
    }
}

