/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.storage;

import android.net.Uri;
import android.support.annotation.NonNull;
import com.ca.mas.core.conf.ConfigurationManager;
import com.ca.mas.core.error.TargetApiException;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASCallback;
import com.ca.mas.foundation.MASRequest;
import com.ca.mas.foundation.MASRequestBody;
import com.ca.mas.foundation.MASResponse;
import com.ca.mas.foundation.notify.Callback;
import com.ca.mas.storage.AbstractMASStorage;
import com.ca.mas.storage.DataMarshaller;
import com.ca.mas.storage.StorageItem;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MASSecureStorage
extends AbstractMASStorage {
    public MASSecureStorage() {
        this.setDefaultDataMarshallers();
    }

    private void setDefaultDataMarshallers() {
        this.register(new AbstractMASStorage.StringDataMarshaller());
        this.register(new AbstractMASStorage.ByteArrayDataMarshaller());
        this.register(new AbstractMASStorage.JsonDataMarshaller());
        this.register(new AbstractMASStorage.BitmapDataMarshaller());
    }

    @Override
    public void save(@NonNull String key, Object value, int segment, final MASCallback<Void> callback) {
        byte[] data;
        DataMarshaller relevantM;
        this.checkNull(key, value);
        try {
            relevantM = this.findMarshaller(value);
            data = relevantM.marshall(value);
        }
        catch (Exception e) {
            Callback.onError(callback, e);
            return;
        }
        StorageItem item = new StorageItem();
        item.setKey(key);
        item.setType(relevantM.getTypeAsString());
        item.setValue(data);
        final MASRequest.MASRequestBuilder builder = this.getRequestBuilder(key, segment);
        JSONObject itemJson = null;
        try {
            itemJson = item.getAsJSONObject();
        }
        catch (JSONException je) {
            Callback.onError(callback, je);
            return;
        }
        builder.put(MASRequestBody.jsonBody(itemJson));
        final JSONObject finalItemJson = itemJson;
        MAS.invoke(builder.build(), new MASCallback<MASResponse<Void>>(){

            @Override
            public void onSuccess(MASResponse<Void> result) {
                Callback.onSuccess(callback, null);
            }

            @Override
            public void onError(Throwable e) {
                if (e.getCause() instanceof TargetApiException) {
                    if (((TargetApiException)e.getCause()).getResponse().getResponseCode() == 404) {
                        builder.post(MASRequestBody.jsonBody(finalItemJson));
                        MAS.invoke(builder.build(), new MASCallback<MASResponse<Void>>(){

                            @Override
                            public void onSuccess(MASResponse<Void> result) {
                                Callback.onSuccess(callback, null);
                            }

                            @Override
                            public void onError(Throwable e) {
                                Callback.onError(callback, e);
                            }
                        });
                    } else {
                        Callback.onError(callback, e);
                    }
                } else {
                    Callback.onError(callback, e);
                }
            }
        });
    }

    @Override
    public void findByKey(@NonNull String key, int segment, final MASCallback callback) {
        this.checkNull(key);
        MASRequest request = this.getRequestBuilder(key, segment).build();
        MAS.invoke(request, new MASCallback<MASResponse<JSONObject>>(){

            @Override
            public void onSuccess(MASResponse<JSONObject> response) {
                StorageItem item = new StorageItem();
                try {
                    JSONObject jobj = (JSONObject)response.getBody().getContent();
                    item.populate(jobj);
                    DataMarshaller relevantM = MASSecureStorage.this.findMarshaller(item.getType());
                    Object result = relevantM.unmarshall(item.getValue());
                    Callback.onSuccess(callback, result);
                }
                catch (Exception je) {
                    Callback.onError(callback, je);
                }
            }

            @Override
            public void onError(Throwable e) {
                if (e.getCause() instanceof TargetApiException) {
                    if (((TargetApiException)e.getCause()).getResponse().getResponseCode() == 404) {
                        Callback.onSuccess(callback, null);
                    } else {
                        Callback.onError(callback, e);
                    }
                } else {
                    Callback.onError(callback, e);
                }
            }
        });
    }

    @Override
    public void keySet(int segment, final MASCallback<Set<String>> callback) {
        MASRequest request = this.getRequestBuilder(null, segment).build();
        MAS.invoke(request, new MASCallback<MASResponse<JSONObject>>(){

            @Override
            public void onSuccess(MASResponse<JSONObject> response) {
                HashSet<String> itemsL = new HashSet<String>();
                try {
                    JSONObject items = (JSONObject)response.getBody().getContent();
                    JSONArray itemArr = items.getJSONArray("results");
                    for (int i = 0; i < itemArr.length(); ++i) {
                        JSONObject jobj = itemArr.getJSONObject(i);
                        StorageItem storageKey = new StorageItem();
                        storageKey.populate(jobj);
                        itemsL.add(storageKey.getKey());
                    }
                    Callback.onSuccess(callback, itemsL);
                }
                catch (JSONException je) {
                    Callback.onError(callback, je);
                }
            }

            @Override
            public void onError(Throwable e) {
                Callback.onError(callback, e);
            }
        });
    }

    public void delete(@NonNull String key, int segment, final MASCallback callback) {
        this.checkNull(key);
        MASRequest request = this.getRequestBuilder(key, segment).delete(null).build();
        MAS.invoke(request, new MASCallback<MASResponse<JSONObject>>(){

            @Override
            public void onSuccess(MASResponse<JSONObject> result) {
                Callback.onSuccess(callback, null);
            }

            @Override
            public void onError(Throwable e) {
                if (e.getCause() instanceof TargetApiException) {
                    if (((TargetApiException)e.getCause()).getResponse().getResponseCode() == 404) {
                        Callback.onSuccess(callback, null);
                    } else {
                        Callback.onError(callback, e);
                    }
                } else {
                    Callback.onError(callback, e);
                }
            }
        });
    }

    private MASRequest.MASRequestBuilder getRequestBuilder(String dataKey, int segment) {
        Uri.Builder uriBuilder = new Uri.Builder();
        String storagePath = (String)ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getProperty("mas.url.mas_storage_path");
        if (storagePath == null) {
            uriBuilder.appendPath("MASS").appendPath("v1");
        } else {
            String[] paths;
            for (String p : paths = storagePath.split("/")) {
                if (p.equalsIgnoreCase("Client")) continue;
                uriBuilder.appendPath(p);
            }
        }
        boolean userSessionRequired = false;
        switch (segment) {
            case 1: {
                uriBuilder.appendPath("User");
                userSessionRequired = true;
                break;
            }
            case 2: {
                uriBuilder.appendPath("Client");
                break;
            }
            case 3: {
                uriBuilder.appendPath("Client").appendPath("User");
                userSessionRequired = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Storage segment is not supported");
            }
        }
        uriBuilder.appendPath("Data");
        if (dataKey != null) {
            uriBuilder.appendPath(dataKey);
        }
        MASRequest.MASRequestBuilder requestBuilder = new MASRequest.MASRequestBuilder(uriBuilder.build());
        if (userSessionRequired) {
            return requestBuilder.password();
        }
        return requestBuilder;
    }
}

