/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.messaging.topic;

import com.ca.mas.core.conf.ConfigurationManager;
import com.ca.mas.messaging.topic.MASTopic;

public class MASTopicBuilder {
    private String mUserId;
    private int mSegment = 3;
    private String mCustomTopic;
    private boolean mEnforceTopicStructure = true;
    private int mQos = 2;

    public MASTopicBuilder setQos(int qos) {
        if (qos < 0 || qos > 2) {
            throw new IllegalArgumentException("Only QoS 0, 1, and 2 are supported.");
        }
        this.mQos = qos;
        return this;
    }

    public MASTopicBuilder setUserId(String userId) {
        this.mUserId = userId;
        return this;
    }

    public MASTopicBuilder setMessagingSegment(int segment) {
        this.mSegment = segment;
        return this;
    }

    public MASTopicBuilder setCustomTopic(String customTopic) {
        this.mCustomTopic = customTopic;
        return this;
    }

    public MASTopicBuilder enforceTopicStructure(boolean enforce) {
        this.mEnforceTopicStructure = enforce;
        return this;
    }

    public MASTopic build() {
        if (this.mCustomTopic == null) {
            throw new IllegalArgumentException("Custom name is required");
        }
        if (this.mEnforceTopicStructure && this.mUserId == null && this.mSegment != 2) {
            throw new IllegalArgumentException("User id is required");
        }
        return new MASTopic(){

            @Override
            public int getQos() {
                return MASTopicBuilder.this.mQos;
            }

            public String toString() {
                String topicStructure = MASTopicBuilder.this.mEnforceTopicStructure ? MASTopicBuilder.this.createTopic() : MASTopicBuilder.this.mCustomTopic;
                return topicStructure;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                return o.toString().equals(this.toString());
            }
        };
    }

    private String createTopic() {
        String prefix = ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getPrefix().trim();
        if (prefix.length() > 0) {
            prefix = "/" + prefix;
        }
        switch (this.mSegment) {
            case 1: {
                return String.format("%s/%s/users/%s/custom/%s", prefix, "2.0", this.mUserId, this.mCustomTopic);
            }
            case 3: {
                return String.format("%s/%s/client/users/%s/custom/%s", prefix, "2.0", this.mUserId, this.mCustomTopic);
            }
            case 2: {
                return String.format("%s/%s/client/custom/%s", prefix, "2.0", this.mCustomTopic);
            }
        }
        throw new IllegalArgumentException("Messaging segment is not supported");
    }
}

