/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation.util;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import com.ca.mas.connecta.client.MASConnectOptions;
import com.ca.mas.connecta.util.ConnectaConsts;
import com.ca.mas.core.MobileSso;
import com.ca.mas.core.MobileSsoFactory;
import com.ca.mas.core.conf.ConfigurationManager;
import java.util.HashMap;
import java.util.Map;

public class FoundationUtil {
    private static String deviceId;

    public static Uri getUserInfo() {
        String userInfo = (String)ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getProperty("mas.url.user_info");
        if (userInfo == null) {
            userInfo = "/openid/connect/v1/userinfo";
        }
        return new Uri.Builder().path(userInfo).build();
    }

    public static Map<String, String> getStandardHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        headers.put("User-Agent", FoundationUtil.getUserAgentId());
        return headers;
    }

    private static String getUserAgentId() {
        return "Mozilla/5.0 (Linux; " + Build.VERSION.RELEASE + ";" + Build.VERSION.CODENAME + ')' + " " + "(KHTML, like Gecko)" + " " + "Application/MobileApplicationServices";
    }

    public static MobileSso getMobileSso() {
        return MobileSsoFactory.getInstance();
    }

    public static String getHost() {
        return ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getTokenHost();
    }

    public static int getPort() {
        return ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getTokenPort();
    }

    public static String getFqdn() {
        String scheme = "https";
        String host = FoundationUtil.getHost();
        int port = FoundationUtil.getPort();
        return scheme + ":" + "/" + "/" + host + ":" + port;
    }

    public static String getBrokerUrl(Context context) throws IllegalStateException {
        return FoundationUtil.getBrokerUrl(context, null);
    }

    public static String getBrokerUrl(Context context, MASConnectOptions connectOptions) throws IllegalStateException {
        if (connectOptions != null && connectOptions.getServerURIs() != null && connectOptions.getServerURIs().length > 0) {
            return connectOptions.getServerURIs()[0];
        }
        return ConnectaConsts.SSL_MESSAGING_SCHEME + ":" + "/" + "/" + FoundationUtil.getHost() + ":" + ConnectaConsts.SSL_MESSAGING_PORT;
    }

    public static void setDeviceId(String deviceId) {
        FoundationUtil.deviceId = deviceId;
    }

    public static String getDeviceId() {
        return deviceId;
    }
}

