/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation.auth;

import android.annotation.TargetApi;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASCallback;
import com.ca.mas.foundation.MASConfiguration;
import com.ca.mas.foundation.MASRequest;
import com.ca.mas.foundation.MASResponse;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class MASWebApplication {
    private String authUrl;

    public MASWebApplication(WebView webView, String authUrl) {
        this.authUrl = authUrl;
        webView.getSettings().setJavaScriptEnabled(true);
        webView.setWebViewClient(this.getWebViewClient());
        try {
            if (!new URL(authUrl).getHost().equals(MASConfiguration.getCurrentConfiguration().getGatewayHostName())) {
                throw new IllegalArgumentException("This auth url is valid only for the host that has issued the access_token");
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        webView.loadUrl(authUrl);
    }

    protected int getRequestTimeout() {
        return 5000;
    }

    protected WebViewClient getWebViewClient() {
        return new WebViewClient(){

            @TargetApi(value=21)
            public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
                return this.shouldInterceptRequest(view, request.getUrl().toString());
            }

            public WebResourceResponse shouldInterceptRequest(WebView view, String url) {
                if (url.equals(MASWebApplication.this.authUrl)) {
                    final CountDownLatch latch = new CountDownLatch(1);
                    final WebResourceResponse webResourceResponse = new WebResourceResponse(null, null, null);
                    MASRequest request = null;
                    try {
                        request = new MASRequest.MASRequestBuilder(new URL(url)).build();
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException(e);
                    }
                    MAS.invoke(request, new MASCallback<MASResponse<byte[]>>(){

                        @Override
                        public void onSuccess(MASResponse<byte[]> result) {
                            try {
                                webResourceResponse.setData((InputStream)new ByteArrayInputStream((byte[])result.getBody().getContent()));
                                webResourceResponse.setEncoding("UTF-8");
                                webResourceResponse.setMimeType("text/html");
                            }
                            catch (Exception e) {
                                webResourceResponse.setData((InputStream)new ByteArrayInputStream(e.getMessage().getBytes()));
                                webResourceResponse.setEncoding("UTF-8");
                                webResourceResponse.setMimeType("plain/text");
                            }
                            latch.countDown();
                        }

                        @Override
                        public void onError(Throwable e) {
                            latch.countDown();
                        }
                    });
                    try {
                        latch.await(MASWebApplication.this.getRequestTimeout(), TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        webResourceResponse.setData((InputStream)new ByteArrayInputStream("No response from Server".getBytes()));
                        webResourceResponse.setEncoding("UTF-8");
                        webResourceResponse.setMimeType("plain/text");
                    }
                    return webResourceResponse;
                }
                return null;
            }
        };
    }
}

