/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation.auth;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.net.http.SslCertificate;
import android.net.http.SslError;
import android.os.Bundle;
import android.os.Parcelable;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.webkit.WebViewDatabase;
import com.ca.mas.core.cert.TrustedCertificateConfiguration;
import com.ca.mas.core.conf.ConfigurationManager;
import com.ca.mas.core.conf.ConfigurationProvider;
import com.ca.mas.core.creds.AuthorizationCodeCredentials;
import com.ca.mas.core.io.http.TrustedCertificateConfigurationTrustManager;
import com.ca.mas.core.service.MssoService;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.auth.MASAuthenticationProvider;
import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;

@Deprecated
public abstract class MASSocialLogin {
    public MASSocialLogin(final Context context, final WebView webView, final long requestId, MASAuthenticationProvider provider) {
        CookieSyncManager.createInstance((Context)context);
        CookieManager cookieManager = CookieManager.getInstance();
        cookieManager.removeAllCookie();
        WebViewDatabase.getInstance((Context)context).clearFormData();
        WebViewDatabase.getInstance((Context)context).clearHttpAuthUsernamePassword();
        WebViewDatabase.getInstance((Context)context).clearUsernamePassword();
        webView.clearCache(true);
        webView.clearFormData();
        webView.getSettings().setSaveFormData(false);
        webView.getSettings().setJavaScriptEnabled(true);
        webView.clearSslPreferences();
        webView.loadUrl("about:blank");
        webView.setVisibility(0);
        webView.setWebViewClient(new WebViewClient(){

            public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
                Collection<? extends Certificate> x509Certificates;
                Bundle bundle = SslCertificate.saveState((SslCertificate)error.getCertificate());
                byte[] bytes = bundle.getByteArray("x509-certificate");
                if (bytes == null) {
                    x509Certificates = null;
                } else {
                    try {
                        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                        x509Certificates = certFactory.generateCertificates(new ByteArrayInputStream(bytes));
                    }
                    catch (CertificateException e) {
                        x509Certificates = null;
                    }
                }
                if (x509Certificates != null && !x509Certificates.isEmpty()) {
                    ConfigurationProvider configurationProvider = ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider();
                    TrustedCertificateConfigurationTrustManager tm = new TrustedCertificateConfigurationTrustManager((TrustedCertificateConfiguration)configurationProvider);
                    try {
                        X509Certificate[] chain = new X509Certificate[x509Certificates.size()];
                        x509Certificates.toArray(chain);
                        String authType = chain[0].getSigAlgName();
                        tm.checkServerTrusted(chain, authType);
                        handler.proceed();
                    }
                    catch (Exception e) {
                        this.onError(e.getMessage(), e);
                        handler.cancel();
                    }
                } else {
                    this.onError("Certificate is not provided.", null);
                    handler.cancel();
                }
            }

            private void onError(String msg, Exception e) {
                webView.clearSslPreferences();
                MAS.cancelRequest(requestId);
                MASSocialLogin.this.onError(msg, e);
            }

            @TargetApi(value=24)
            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
                Uri uri = request.getUrl();
                return this.shouldOverrideUrlLoading(view, uri);
            }

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                return this.shouldOverrideUrlLoading(view, Uri.parse((String)url));
            }

            private boolean shouldOverrideUrlLoading(WebView view, Uri url) {
                String redirectUri = (String)ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getProperty("msso.authorize.redirect.uri");
                if (url.toString().startsWith(redirectUri)) {
                    String code = url.getQueryParameter("code");
                    String state = url.getQueryParameter("state");
                    Intent intent = new Intent("com.ca.mas.core.service.action.CREDENTIALS_OBTAINED", null, context, MssoService.class);
                    intent.putExtra("com.ca.mas.core.service.req.extra.requestId", requestId);
                    intent.putExtra("com.ca.mas.core.service.req.extra.credentials", (Parcelable)new AuthorizationCodeCredentials(code, state));
                    context.startService(intent);
                    MASSocialLogin.this.onAuthCodeReceived(code);
                    return true;
                }
                view.loadUrl(url.toString());
                return true;
            }
        });
        webView.loadUrl(provider.getAuthenticationUrl());
    }

    protected abstract void onError(String var1, Exception var2);

    protected abstract void onAuthCodeReceived(String var1);
}

