/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation.auth;

import android.content.Context;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.ca.mas.core.http.MAGHttpClient;
import com.ca.mas.core.http.MAGRequest;
import com.ca.mas.core.http.MAGResponse;
import com.ca.mas.core.http.MAGResponseBody;
import com.ca.mas.core.service.Provider;
import com.ca.mas.foundation.MASCallback;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class MASAuthenticationProvider
implements Parcelable {
    private Provider provider;
    public static final Parcelable.Creator<MASAuthenticationProvider> CREATOR = new Parcelable.Creator<MASAuthenticationProvider>(){

        public MASAuthenticationProvider createFromParcel(Parcel source) {
            return new MASAuthenticationProvider(source);
        }

        public MASAuthenticationProvider[] newArray(int size) {
            return new MASAuthenticationProvider[size];
        }
    };

    protected MASAuthenticationProvider(Provider provider) {
        this.provider = provider;
    }

    public String getIdentifier() {
        return this.provider.getId();
    }

    public String getAuthenticationUrl() {
        return this.provider.getUrl();
    }

    public String getPollUrl() {
        return this.provider.getPollUrl();
    }

    public boolean isEnterprise() {
        return this.provider.getId().equalsIgnoreCase("enterprise");
    }

    public boolean isFacebook() {
        return this.provider.getId().equalsIgnoreCase("facebook");
    }

    public boolean isGoogle() {
        return this.provider.getId().equalsIgnoreCase("google");
    }

    public boolean isLinkedIn() {
        return this.provider.getId().equalsIgnoreCase("linkedin");
    }

    public boolean isSalesForce() {
        return this.provider.getId().equalsIgnoreCase("salesforce");
    }

    public boolean isProximityLogin() {
        return this.provider.getId().equalsIgnoreCase("qrcode");
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.provider, flags);
    }

    protected MASAuthenticationProvider(Parcel in) {
        this.provider = (Provider)in.readParcelable(Provider.class.getClassLoader());
    }

    public void getAuthConfiguration(Context context, MASAuthenticationProvider provider, MASCallback<Uri> callback) {
        MAGRequest request = new MAGRequest.MAGRequestBuilder(Uri.parse((String)provider.getAuthenticationUrl())).get().responseBody(MAGResponseBody.jsonBody()).build();
        MagTask magTask = new MagTask(context, request, callback);
        magTask.execute(new Void[0]);
    }

    private static class MagTask
    extends AsyncTask<Void, Void, MAGResponse> {
        Context context;
        MAGRequest request;
        MASCallback<Uri> callback;

        MagTask(Context context, MAGRequest request, MASCallback<Uri> callback) {
            this.context = context;
            this.request = request;
            this.callback = callback;
        }

        protected MAGResponse<JSONObject> doInBackground(Void ... params) {
            MAGHttpClient magHttpClient = new MAGHttpClient(this.context){

                protected void onConnectionObtained(HttpURLConnection connection) {
                    connection.setInstanceFollowRedirects(false);
                }
            };
            try {
                return magHttpClient.execute(this.request);
            }
            catch (IOException e) {
                Log.d((String)"", (String)e.getMessage());
                return null;
            }
        }

        protected void onPostExecute(MAGResponse magResponse) {
            super.onPostExecute((Object)magResponse);
            String location = null;
            Map headers = magResponse.getHeaders();
            location = (String)((List)headers.get("Location")).get(0);
            this.callback.onSuccess(Uri.parse((String)location));
        }
    }
}

