/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation.auth;

import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.net.Uri;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import com.ca.mas.core.MAG;
import com.ca.mas.core.app.App;
import com.ca.mas.core.app.ImageFetcher;
import com.ca.mas.core.ent.InvalidResponseException;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASCallback;
import com.ca.mas.foundation.MASConfiguration;
import com.ca.mas.foundation.MASRequest;
import com.ca.mas.foundation.MASResponse;
import com.ca.mas.foundation.notify.Callback;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class MASApplication {
    private static String TAG = MASApplication.class.getCanonicalName();
    private static MASApplicationLauncher mLauncher = new MASApplicationLauncher(){

        @Override
        public void onWebAppLaunch(MASApplication application) {
        }
    };

    private MASApplication() {
    }

    public abstract String getIdentifier();

    public abstract String getName();

    public abstract String getIconUrl();

    public abstract String getAuthUrl();

    public abstract String getNativeUri();

    public abstract JSONObject getCustom();

    public static void setApplicationLauncher(MASApplicationLauncher launcher) {
        mLauncher = launcher;
    }

    public abstract void renderEnterpriseIcon(ImageView var1);

    public static void retrieveEnterpriseApps(final MASCallback<List<MASApplication>> callback) {
        String path = MASConfiguration.getCurrentConfiguration().getEndpointPath("msso.url.enterprise_apps");
        try {
            MASRequest r = new MASRequest.MASRequestBuilder(new URI(path)).build();
            MAS.invoke(r, new MASCallback<MASResponse<JSONObject>>(){

                @Override
                public void onSuccess(MASResponse<JSONObject> result) {
                    try {
                        ArrayList<1> applications = new ArrayList<1>();
                        JSONArray apps = ((JSONObject)result.getBody().getContent()).optJSONArray("enterprise-apps");
                        if (apps != null) {
                            for (int i = 0; i < apps.length(); ++i) {
                                final App a = new App(((JSONObject)apps.get(i)).getJSONObject("app"));
                                applications.add(new MASApplication(){

                                    @Override
                                    public String getIdentifier() {
                                        return a.getId();
                                    }

                                    @Override
                                    public String getName() {
                                        return a.getName();
                                    }

                                    @Override
                                    public String getIconUrl() {
                                        return a.getIconUrl();
                                    }

                                    @Override
                                    public String getAuthUrl() {
                                        return a.getAuthUrl();
                                    }

                                    @Override
                                    public String getNativeUri() {
                                        return a.getNativeUri();
                                    }

                                    @Override
                                    public JSONObject getCustom() {
                                        return a.getCustom();
                                    }

                                    @Override
                                    public void renderEnterpriseIcon(ImageView imageView) {
                                        new ImageFetcher(imageView).execute(new Object[]{this.getIconUrl()});
                                        final 1 t = this;
                                        imageView.setOnClickListener(new View.OnClickListener(){

                                            public void onClick(View v) {
                                                if (this.getNativeUri() != null && this.getNativeUri().length() > 0) {
                                                    if (mLauncher != null) {
                                                        mLauncher.onNativeAppLaunch(t);
                                                    }
                                                    return;
                                                }
                                                if (this.getAuthUrl() != null && this.getAuthUrl().length() > 0 && mLauncher != null) {
                                                    mLauncher.onWebAppLaunch(t);
                                                }
                                            }
                                        });
                                    }
                                });
                            }
                        }
                        Callback.onSuccess(callback, applications);
                    }
                    catch (Exception e) {
                        if (e.getCause() != null && e.getCause() instanceof JSONException) {
                            Callback.onError(callback, (Throwable)new InvalidResponseException(e.getCause()));
                            return;
                        }
                        Callback.onError(callback, e);
                    }
                }

                @Override
                public void onError(Throwable e) {
                    Callback.onError(callback, e);
                }
            });
        }
        catch (URISyntaxException e) {
            Callback.onError(callback, e);
        }
    }

    public static abstract class MASApplicationLauncher {
        public void onNativeAppLaunch(MASApplication application) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)application.getNativeUri()));
            intent.setFlags(0x10000000);
            try {
                MAS.getContext().startActivity(intent);
            }
            catch (ActivityNotFoundException e) {
                if (MAG.DEBUG) {
                    Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
                }
                throw e;
            }
        }

        public abstract void onWebAppLaunch(MASApplication var1);
    }
}

