/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation;

import android.support.annotation.NonNull;
import com.ca.mas.foundation.MASCallback;
import com.ca.mas.foundation.MASTransformable;
import com.ca.mas.foundation.MASUser;
import com.ca.mas.foundation.notify.Callback;
import com.ca.mas.identity.common.MASFilteredRequest;
import com.ca.mas.identity.group.GroupAttributes;
import com.ca.mas.identity.group.GroupIdentityManager;
import com.ca.mas.identity.group.MASGroupIdentity;
import com.ca.mas.identity.group.MASMember;
import com.ca.mas.identity.group.MASOwner;
import com.ca.mas.identity.user.MASMeta;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class MASGroup
implements MASTransformable,
MASGroupIdentity {
    public static MASGroup newInstance() {
        return new MASGroup(){
            private String mId;
            private String mValue;
            private String mReference;
            private String mGroupName;
            private MASOwner mOwner;
            private MASMeta mMeta;
            private List<MASMember> mMembersList = new ArrayList<MASMember>();

            @Override
            public String getId() {
                return this.mId;
            }

            @Override
            public String getValue() {
                return this.mValue;
            }

            @Override
            public String getReference() {
                return this.mReference;
            }

            @Override
            public String getGroupName() {
                return this.mGroupName;
            }

            @Override
            public void setGroupName(String groupName) {
                this.mGroupName = groupName;
            }

            @Override
            public List<MASMember> getMembers() {
                return this.mMembersList;
            }

            @Override
            public MASOwner getOwner() {
                if (this.mOwner == null) {
                    return new MASOwner(MASUser.getCurrentUser());
                }
                return this.mOwner;
            }

            @Override
            public void populate(@NonNull JSONObject jobj) throws JSONException {
                JSONObject ownerObj;
                this.mId = jobj.optString("id");
                this.mGroupName = jobj.optString("displayName");
                this.mValue = jobj.optString("value");
                this.mReference = jobj.optString("$ref");
                if (jobj.has("owner") && (ownerObj = jobj.getJSONObject("owner")) != null && ownerObj.has("value")) {
                    String id = ownerObj.getString("value");
                    String ref = ownerObj.getString("$ref");
                    String display = ownerObj.getString("display");
                    this.mOwner = new MASOwner(id, ref, display);
                }
                if (jobj.has("members")) {
                    JSONArray membersArr = jobj.getJSONArray("members");
                    for (int i = 0; i < membersArr.length(); ++i) {
                        JSONObject memberObj = membersArr.getJSONObject(i);
                        if (memberObj == null || !memberObj.has("value")) continue;
                        MASMember member = new MASMember(memberObj.getString("type"), memberObj.getString("value"), memberObj.getString("$ref"), memberObj.getString("display"));
                        this.addMember(member);
                    }
                }
                if (jobj.has("meta")) {
                    JSONObject metaObj = jobj.getJSONObject("meta");
                    this.mMeta = new MASMeta();
                    this.mMeta.populate(metaObj);
                }
            }

            @Override
            public JSONObject getAsJSONObject() throws JSONException {
                JSONObject jobj = new JSONObject();
                JSONArray schemas = new JSONArray();
                schemas.put((Object)"urn:ietf:params:scim:schemas:core:2.0:Group");
                jobj.put("schemas", (Object)schemas);
                jobj.put("displayName", (Object)this.mGroupName);
                JSONObject owner = new JSONObject();
                owner.put("value", (Object)this.getOwner().getValue());
                owner.put("display", (Object)this.getOwner().getDisplay());
                jobj.put("owner", (Object)owner);
                JSONArray members = new JSONArray();
                for (MASMember m : this.mMembersList) {
                    JSONObject member = new JSONObject();
                    member.put("value", (Object)m.getValue());
                    member.put("display", (Object)m.getDisplay());
                    member.put("type", (Object)m.getType());
                    members.put((Object)member);
                }
                jobj.put("members", (Object)members);
                return jobj;
            }

            private boolean isGroupMember(MASMember member) {
                for (MASMember m : this.mMembersList) {
                    if (!m.getValue().equals(member.getValue())) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void addMember(MASMember member) {
                if (!this.isGroupMember(member)) {
                    this.mMembersList.add(member);
                }
            }

            @Override
            public void removeMember(MASMember member) {
                MASMember m = this.getGroupMember(member.getValue());
                if (m != null) {
                    this.mMembersList.remove(m);
                }
            }

            private MASMember getGroupMember(String id) {
                for (MASMember m : this.mMembersList) {
                    if (!m.getValue().equals(id)) continue;
                    return m;
                }
                return null;
            }

            @Override
            public MASMeta getMeta() {
                return this.mMeta;
            }

            @Override
            public void save(MASCallback<MASGroup> callback) {
                GroupIdentityManager.getInstance().save(this, callback);
            }

            @Override
            public void delete(MASCallback<Void> callback) {
                GroupIdentityManager.getInstance().deleteAdHocGroup(this, callback);
            }

            @Override
            public void getAllGroups(String userId, final MASCallback<List<MASGroup>> callback) {
                if (MASUser.getCurrentUser() != null && MASUser.getCurrentUser().getUserName() != null) {
                    GroupIdentityManager.getInstance().getAllGroups(MASUser.getCurrentUser().getUserName(), callback);
                } else {
                    MASUser.login(new MASCallback<MASUser>(){

                        @Override
                        public void onSuccess(MASUser result) {
                            GroupIdentityManager.getInstance().getAllGroups(result.getUserName(), callback);
                        }

                        @Override
                        public void onError(Throwable e) {
                            Callback.onError(callback, e);
                        }
                    });
                }
            }

            @Override
            public void getGroupByGroupName(String groupName, MASCallback<List<MASGroup>> callback) {
                GroupIdentityManager.getInstance().getGroupByGroupName(groupName, callback);
            }

            @Override
            public void getGroupById(String id, MASCallback<MASGroup> callback) {
                GroupIdentityManager.getInstance().getGroupById(id, callback);
            }

            @Override
            public void getGroupByMember(MASUser user, MASCallback<List<MASGroup>> callback) {
                GroupIdentityManager.getInstance().getGroupByMember(user, callback);
            }

            @Override
            public void getGroupsByFilter(MASFilteredRequest filteredRequest, MASCallback<List<MASGroup>> callback) {
                GroupIdentityManager.getInstance().getGroupsByFilter(filteredRequest, callback);
            }

            @Override
            public void getGroupMetaData(MASCallback<GroupAttributes> callback) {
                GroupIdentityManager.getInstance().getGroupMetaData(callback);
            }
        };
    }

    public abstract String getId();

    public abstract String getValue();

    public abstract String getReference();

    public abstract String getGroupName();

    public abstract void setGroupName(String var1);

    public abstract MASOwner getOwner();

    public abstract List<MASMember> getMembers();

    public abstract void addMember(MASMember var1);

    public abstract void removeMember(MASMember var1);

    public abstract MASMeta getMeta();

    public abstract void save(MASCallback<MASGroup> var1);

    public abstract void delete(MASCallback<Void> var1);

    static enum PatchOp {
        ADD,
        REMOVE,
        REPLACE;

    }
}

