/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.connecta.serviceprovider;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.support.annotation.NonNull;
import android.util.Log;
import com.ca.mas.R;
import com.ca.mas.connecta.client.ConnectaException;
import com.ca.mas.connecta.client.MASConnectOptions;
import com.ca.mas.connecta.client.MASConnectaClient;
import com.ca.mas.connecta.client.MASConnectaListener;
import com.ca.mas.connecta.serviceprovider.MessageBroadcaster;
import com.ca.mas.connecta.util.ConnectaUtil;
import com.ca.mas.core.MAG;
import com.ca.mas.core.conf.ConfigurationManager;
import com.ca.mas.foundation.MASCallback;
import com.ca.mas.foundation.notify.Callback;
import com.ca.mas.foundation.util.FoundationUtil;
import com.ca.mas.messaging.MASMessage;
import com.ca.mas.messaging.MASMessageException;
import com.ca.mas.messaging.topic.MASTopic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

public class ConnectaService
extends Service
implements MASConnectaClient {
    private MqttAsyncClient mMqttClient;
    private long mTimeOutInMillis;
    private MASConnectOptions mConnectOptions;
    private MessageBroadcaster mMessageBroadcaster;
    private MASConnectaListener connectaListener;
    private final IBinder mBinder = new ServiceBinder();
    private String clientId;
    private List<MASTopic> subscribedTopic = Collections.synchronizedList(new ArrayList());

    public void setConnectaListener(MASConnectaListener connectaListener) {
        this.connectaListener = connectaListener;
    }

    public IBinder onBind(Intent intent) {
        return this.mBinder;
    }

    @Override
    public void connect(final MASCallback<Void> callback) {
        try {
            this.mMessageBroadcaster = new MessageBroadcaster((Context)this);
            if (MAG.DEBUG) {
                Log.d((String)MAG.TAG, (String)"CONNECTA: connect()");
            }
            MASCallback<Map<String, Object>> masCallback = new MASCallback<Map<String, Object>>(){

                @Override
                public Handler getHandler() {
                    return Callback.getHandler(callback);
                }

                @Override
                public void onSuccess(Map<String, Object> result) {
                    try {
                        if (MAG.DEBUG) {
                            Log.d((String)MAG.TAG, (String)"CONNECTA: onSuccess()");
                        }
                        ConnectaService.this.initMqttClient((String)result.get("mag_identifier"));
                        MqttConnectOptions mqttConnectOptions = (MqttConnectOptions)result.get(MASConnectOptions.class.getName());
                        ConnectaService.this.mMqttClient.connect(mqttConnectOptions, null, new IMqttActionListener(){

                            public void onSuccess(IMqttToken iMqttToken) {
                                for (MASTopic topic : ConnectaService.this.subscribedTopic) {
                                    ConnectaService.this.subscribe(topic, null);
                                }
                                Callback.onSuccess(callback, null);
                            }

                            public void onFailure(IMqttToken iMqttToken, Throwable throwable) {
                                Callback.onError(callback, new ConnectaException("Not connected to message broker!"));
                            }
                        });
                    }
                    catch (Exception e) {
                        if (MAG.DEBUG) {
                            Log.e((String)MAG.TAG, (String)e.getMessage());
                        }
                        Callback.onError(callback, e);
                    }
                }

                @Override
                public void onError(Throwable error) {
                    Callback.onError(callback, error);
                }
            };
            if (this.mConnectOptions == null || this.mConnectOptions.getServerURIs() == null) {
                this.mConnectOptions = new MASConnectOptions();
                this.mConnectOptions.initConnectOptions((Context)this, this.mTimeOutInMillis, masCallback);
            } else {
                this.mConnectOptions.setConnectionTimeout(ConnectaUtil.createConnectionOptions(ConnectaUtil.getBrokerUrl((Context)this), this.mTimeOutInMillis).getConnectionTimeout());
                if (MAG.DEBUG) {
                    Log.d((String)MAG.TAG, (String)"CONNECTA: onSuccess()");
                }
                this.initMqttClient();
                this.mMqttClient.connect((MqttConnectOptions)this.mConnectOptions, null, new IMqttActionListener(){

                    public void onSuccess(IMqttToken iMqttToken) {
                        Callback.onSuccess(callback, null);
                    }

                    public void onFailure(IMqttToken iMqttToken, Throwable throwable) {
                        Callback.onError(callback, new ConnectaException("Not connected to message broker!"));
                    }
                });
            }
        }
        catch (Exception e) {
            if (MAG.DEBUG) {
                Log.e((String)MAG.TAG, (String)e.getMessage(), (Throwable)e);
            }
            Callback.onError(callback, e);
        }
    }

    private void initMqttClient() throws MASMessageException, MqttException {
        this.initMqttClient(null);
    }

    private void initMqttClient(String magIdentifier) throws MASMessageException, MqttException {
        if (this.mMqttClient != null) {
            return;
        }
        String brokerUrl = ConnectaUtil.getBrokerUrl(this.getApplicationContext(), this.mConnectOptions);
        if (MAG.DEBUG) {
            Log.d((String)MAG.TAG, (String)("CONNECTA: brokerUrl: " + brokerUrl));
        }
        String brokerClientId = this.clientId == null || brokerUrl.contains(FoundationUtil.getHost()) ? ConnectaUtil.getMqttClientId(ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getClientId(), magIdentifier, this.mConnectOptions.isGateway()) : this.clientId;
        if (MAG.DEBUG) {
            Log.d((String)MAG.TAG, (String)("CONNECTA: clientId: " + this.clientId + ", CONNECTA: brokerClientId: " + brokerClientId));
        }
        MemoryPersistence memoryPersistence = new MemoryPersistence();
        this.mMqttClient = new MqttAsyncClient(brokerUrl, brokerClientId, (MqttClientPersistence)memoryPersistence);
        this.mMqttClient.setCallback(new MqttCallback(){

            public void connectionLost(Throwable throwable) {
                if (MAG.DEBUG) {
                    Log.d((String)MAG.TAG, (String)("Connections was lost: " + throwable.getMessage() + ", " + throwable.getCause()));
                }
                if (ConnectaService.this.mConnectOptions.isGateway()) {
                    ConnectaService.this.mConnectOptions = null;
                    ConnectaService.this.connect(null);
                }
                if (ConnectaService.this.connectaListener != null) {
                    ConnectaService.this.connectaListener.onConnectionLost();
                }
            }

            public void messageArrived(String topic, MqttMessage mqttMessage) throws Exception {
                block3: {
                    if (MAG.DEBUG) {
                        Log.d((String)MAG.TAG, (String)("Message Arrived: QOS: " + mqttMessage.getQos() + ", duplicate?" + mqttMessage.isDuplicate() + ", retained? " + mqttMessage.isRetained()));
                    }
                    try {
                        MASMessage masMessage = ConnectaUtil.createMASMessageFromMqtt(mqttMessage);
                        masMessage.setTopic(topic);
                        ConnectaService.this.mMessageBroadcaster.broadcastMessage(masMessage);
                    }
                    catch (Exception je) {
                        if (ConnectaService.this.connectaListener == null) break block3;
                        ConnectaService.this.connectaListener.onInvalidMessageFormat();
                    }
                }
            }

            public void deliveryComplete(IMqttDeliveryToken iMqttDeliveryToken) {
                block4: {
                    try {
                        if (MAG.DEBUG) {
                            Log.d((String)MAG.TAG, (String)("Delivery Complete: token message: " + iMqttDeliveryToken.getMessage()));
                        }
                        if (ConnectaService.this.connectaListener != null) {
                            ConnectaService.this.connectaListener.onDeliveryCompletedSuccess();
                        }
                    }
                    catch (MqttException me) {
                        if (ConnectaService.this.connectaListener == null) break block4;
                        ConnectaService.this.connectaListener.onDeliveryCompletedFailed((Exception)((Object)me));
                    }
                }
            }
        });
    }

    @Override
    public void setConnectOptions(MASConnectOptions connectOptions) {
        this.mConnectOptions = connectOptions;
    }

    @Override
    public void disconnect(final MASCallback<Void> callback) {
        this.subscribedTopic.clear();
        this.mConnectOptions = null;
        this.mMqttClient = null;
        if (this.isConnected()) {
            if (MAG.DEBUG) {
                Log.d((String)MAG.TAG, (String)"MQTT Client Disconnected.");
            }
            try {
                this.mMqttClient.disconnect(null, new IMqttActionListener(){

                    public void onSuccess(IMqttToken iMqttToken) {
                        Callback.onSuccess(callback, null);
                    }

                    public void onFailure(IMqttToken iMqttToken, Throwable throwable) {
                        Callback.onError(callback, throwable);
                    }
                });
            }
            catch (Exception e) {
                Callback.onError(callback, e);
            }
        } else {
            Callback.onError(callback, new ConnectaException(this.getResources().getString(R.string.client_already_disconnected)));
        }
    }

    @Override
    public void subscribe(final @NonNull MASTopic masTopic, final MASCallback<Void> callback) {
        if (this.isConnected()) {
            try {
                this.mMqttClient.subscribe(masTopic.toString(), masTopic.getQos(), null, new IMqttActionListener(){

                    public void onSuccess(IMqttToken iMqttToken) {
                        if (!ConnectaService.this.subscribedTopic.contains(masTopic)) {
                            ConnectaService.this.subscribedTopic.add(masTopic);
                        }
                        Callback.onSuccess(callback, null);
                    }

                    public void onFailure(IMqttToken iMqttToken, Throwable throwable) {
                        Callback.onError(callback, throwable);
                    }
                });
            }
            catch (Exception e) {
                Callback.onError(callback, e);
            }
        } else {
            Callback.onError(callback, new ConnectaException(this.getResources().getString(R.string.could_not_subscribe)));
        }
    }

    @Override
    public void unsubscribe(final @NonNull MASTopic topic, final MASCallback<Void> callback) {
        if (this.isConnected()) {
            try {
                this.mMqttClient.unsubscribe(topic.toString(), null, new IMqttActionListener(){

                    public void onSuccess(IMqttToken iMqttToken) {
                        ConnectaService.this.subscribedTopic.remove(topic);
                        Callback.onSuccess(callback, null);
                    }

                    public void onFailure(IMqttToken iMqttToken, Throwable throwable) {
                        Callback.onError(callback, throwable);
                    }
                });
            }
            catch (Exception e) {
                Callback.onError(callback, e);
            }
        } else {
            Callback.onError(callback, new ConnectaException(this.getResources().getString(R.string.could_not_unsubscribe)));
        }
    }

    @Override
    public void publish(@NonNull MASTopic masTopic, @NonNull MASMessage message, MASCallback<Void> callback) {
        try {
            MqttMessage mqttMessage = new MqttMessage();
            byte[] bytes = message.createJSONStringFromMASMessage(this.getApplicationContext()).getBytes();
            mqttMessage.setPayload(bytes);
            mqttMessage.setQos(message.getQos());
            mqttMessage.setRetained(message.isRetained());
            this.publish(masTopic, mqttMessage, callback);
        }
        catch (MASMessageException me) {
            Callback.onError(callback, me);
        }
    }

    @Override
    public void publish(@NonNull MASTopic topic, @NonNull byte[] message, MASCallback<Void> callback) {
        MqttMessage mqttMessage = new MqttMessage();
        mqttMessage.setPayload(message);
        mqttMessage.setQos(topic.getQos());
        this.publish(topic, mqttMessage, callback);
    }

    private void publish(@NonNull MASTopic topic, @NonNull MqttMessage mqttMessage, final MASCallback<Void> callback) {
        if (this.isConnected()) {
            try {
                this.mMqttClient.publish(topic.toString(), mqttMessage, null, new IMqttActionListener(){

                    public void onSuccess(IMqttToken iMqttToken) {
                        Callback.onSuccess(callback, null);
                    }

                    public void onFailure(IMqttToken iMqttToken, Throwable throwable) {
                        Callback.onError(callback, throwable);
                    }
                });
            }
            catch (Exception e) {
                Callback.onError(callback, e);
            }
        } else {
            Callback.onError(callback, new ConnectaException(this.getResources().getString(R.string.could_not_publish)));
        }
    }

    @Override
    public boolean isConnected() {
        if (this.mMqttClient != null) {
            return this.mMqttClient.isConnected();
        }
        return false;
    }

    @Override
    public void setTimeOutInMillis(long timeOutInMillis) {
        this.mTimeOutInMillis = timeOutInMillis;
    }

    @Override
    public long getTimeOutInMillis() {
        return this.mTimeOutInMillis;
    }

    @Override
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public class ServiceBinder
    extends Binder {
        public ConnectaService getService() {
            return ConnectaService.this;
        }
    }
}

