/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.connecta.client;

import android.content.Context;
import com.ca.mas.connecta.util.ConnectaUtil;
import com.ca.mas.core.MobileSsoFactory;
import com.ca.mas.core.error.MAGError;
import com.ca.mas.core.http.MAGRequest;
import com.ca.mas.core.http.MAGResponse;
import com.ca.mas.core.io.ssl.MAGSocketFactory;
import com.ca.mas.core.request.internal.StateRequest;
import com.ca.mas.foundation.MASCallback;
import com.ca.mas.foundation.MASResultReceiver;
import com.ca.mas.foundation.MASUser;
import com.ca.mas.foundation.notify.Callback;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.json.JSONObject;

public class MASConnectOptions
extends MqttConnectOptions {
    boolean isGateway = false;

    public boolean isGateway() {
        return this.isGateway;
    }

    public void initConnectOptions(final Context context, final long timeOutInMillis, final MASCallback<Map<String, Object>> callback) {
        this.isGateway = true;
        final MASResultReceiver<JSONObject> receiver = new MASResultReceiver<JSONObject>(Callback.getHandler(callback)){

            public void onSuccess(MAGResponse<JSONObject> response) {
                JSONObject jobj = (JSONObject)response.getBody().getContent();
                String oauthToken = jobj.optString("access_token");
                MqttConnectOptions connectOptions = ConnectaUtil.createConnectionOptions(ConnectaUtil.getBrokerUrl(context), timeOutInMillis);
                SSLSocketFactory sslSocketFactory = new MAGSocketFactory(context).createTLSSocketFactory();
                connectOptions.setSocketFactory((SocketFactory)sslSocketFactory);
                String uname = MASUser.getCurrentUser().getUserName();
                connectOptions.setUserName(uname);
                connectOptions.setPassword(oauthToken.toCharArray());
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("mag_identifier", jobj.optString("mag_identifier"));
                info.put(MASConnectOptions.class.getName(), (String)connectOptions);
                Callback.onSuccess(callback, info);
            }

            public void onError(MAGError magError) {
                Callback.onError(callback, (Throwable)magError);
            }
        };
        if (MASUser.getCurrentUser() != null && MASUser.getCurrentUser().getUserName() != null) {
            this.retrieveOauthToken(receiver);
        } else {
            MASUser.login(new MASCallback<MASUser>(){

                @Override
                public void onSuccess(MASUser result) {
                    MASConnectOptions.this.retrieveOauthToken(receiver);
                }

                @Override
                public void onError(Throwable e) {
                    Callback.onError(callback, e);
                }
            });
        }
    }

    private void retrieveOauthToken(MASResultReceiver<JSONObject> result) {
        MobileSsoFactory.getInstance().processRequest((MAGRequest)new StateRequest(), result);
    }

    public Properties getDebug() {
        Properties p = super.getDebug();
        String s = "";
        if (this.getServerURIs() != null && this.getServerURIs().length > 0) {
            s = this.getServerURIs()[0];
        }
        p.put("ServerURI", s);
        return p;
    }
}

