/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.storage;

import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import androidx.annotation.NonNull;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASTransformable;
import com.ca.mas.storage.StorageKey;
import org.json.JSONException;
import org.json.JSONObject;

class StorageItem
implements MASTransformable {
    private StorageKey storageKey;
    private String key;
    private byte[] value;
    private String type;

    StorageItem() {
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(final @NonNull String key) {
        this.key = key;
        this.storageKey = new StorageKey(){

            @Override
            public String getDataKey() {
                return key;
            }
        };
    }

    public void populate(@NonNull JSONObject jobj) throws JSONException {
        if (MAS.DEBUG) {
            Log.d((String)"MAS", (String)("Raw Storage Item: " + jobj.toString()));
        }
        if (this.storageKey == null) {
            this.storageKey = new StorageKey();
        }
        this.storageKey.populate(jobj);
        this.key = this.storageKey.getDataKey();
        String dataValue = jobj.optString("value");
        String valueStr = new String(Base64.decode((String)dataValue, (int)2));
        if (this.storageKey.getContentType() != null && this.storageKey.getContentType().contains("application/json")) {
            JSONObject doc = new JSONObject(valueStr);
            this.type = doc.optString("type", "application/json");
            this.value = Base64.decode((String)doc.optString("value"), (int)2);
        } else {
            this.type = "text/plain";
            this.value = valueStr.getBytes();
        }
    }

    public byte[] getValue() {
        return this.value;
    }

    public JSONObject getAsJSONObject() throws JSONException {
        JSONObject jobj = new JSONObject();
        if (TextUtils.isEmpty((CharSequence)this.key)) {
            throw new JSONException("Required key value is missing.");
        }
        jobj.put("key", (Object)this.key);
        jobj.put("type", (Object)this.type);
        if (this.value != null) {
            String val = Base64.encodeToString((byte[])this.value, (int)2);
            jobj.put("value", (Object)val);
        }
        return jobj;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

