/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.storage;

import android.content.AsyncTaskLoader;
import android.content.Context;
import androidx.annotation.NonNull;
import com.ca.mas.core.datasource.DataSource;
import com.ca.mas.core.datasource.DataSourceFactory;
import com.ca.mas.core.datasource.LocalStoreDataSource;
import com.ca.mas.core.datasource.LocalStoreEntity;
import com.ca.mas.core.datasource.LocalStoreKey;
import com.ca.mas.core.security.DefaultEncryptionProvider;
import com.ca.mas.core.security.EncryptionProvider;
import com.ca.mas.core.security.SecureLockException;
import com.ca.mas.core.util.Functions;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASCallback;
import com.ca.mas.foundation.MASUser;
import com.ca.mas.foundation.notify.Callback;
import com.ca.mas.storage.AbstractMASStorage;
import com.ca.mas.storage.DataMarshaller;
import java.util.HashSet;
import java.util.Set;

public class MASSecureLocalStorage
extends AbstractMASStorage {
    private DataSource<LocalStoreKey, LocalStoreEntity> dataSource;
    private Context context = MAS.getContext();
    private EncryptionProvider encProvider;

    public MASSecureLocalStorage() {
        this((EncryptionProvider)new DefaultEncryptionProvider(MAS.getContext()));
    }

    public MASSecureLocalStorage(EncryptionProvider encryptionProvider) {
        this.setEncryptionProvider(encryptionProvider);
        this.setDefaultDataMarshallers();
        this.dataSource = DataSourceFactory.getStorage((Context)this.context, LocalStoreDataSource.class, null, null);
    }

    @Override
    public void save(final @NonNull String key, final @NonNull Object value, final int segment, final MASCallback<Void> callback) {
        this.checkNull(key, value);
        this.execute(new Functions.UnaryVoid<String>(){

            public void call(String s) {
                try {
                    byte[] data;
                    String createdBy = s;
                    DataMarshaller relevantM = MASSecureLocalStorage.this.findMarshaller(value);
                    byte[] encryptedData = data = relevantM.marshall(value);
                    if (MASSecureLocalStorage.this.encProvider != null) {
                        encryptedData = MASSecureLocalStorage.this.encProvider.encrypt(data);
                    }
                    if (segment == 2) {
                        createdBy = MASSecureLocalStorage.this.context.getPackageName();
                    }
                    MASSecureLocalStorage.this.dataSource.put((Object)new Key(key, segment, createdBy), (Object)new LocalStoreEntity(relevantM.getTypeAsString(), encryptedData));
                    Callback.onSuccess((MASCallback)callback, null);
                }
                catch (Exception e) {
                    Callback.onError((MASCallback)callback, (Throwable)e);
                }
            }
        }, segment, callback);
    }

    @Override
    public void findByKey(final @NonNull String key, final int segment, final MASCallback callback) {
        this.checkNull(key);
        this.execute(new Functions.UnaryVoid<String>(){

            public void call(String s) {
                try {
                    Object value = null;
                    LocalStoreEntity result = (LocalStoreEntity)MASSecureLocalStorage.this.dataSource.get((Object)new Key(key, segment, s));
                    if (result != null) {
                        byte[] decryptedData = result.getData();
                        if (MASSecureLocalStorage.this.encProvider != null) {
                            decryptedData = MASSecureLocalStorage.this.encProvider.decrypt(result.getData());
                        }
                        DataMarshaller relevantM = MASSecureLocalStorage.this.findMarshaller(result.getType());
                        value = relevantM.unmarshall(decryptedData);
                    }
                    Callback.onSuccess((MASCallback)callback, value);
                }
                catch (Exception e) {
                    Callback.onError((MASCallback)callback, (Throwable)e);
                }
            }
        }, segment, callback);
    }

    @Override
    public void delete(final @NonNull String key, final int segment, final MASCallback<Void> callback) {
        this.checkNull(key);
        this.execute(new Functions.UnaryVoid<String>(){

            public void call(String s) {
                try {
                    MASSecureLocalStorage.this.dataSource.remove((Object)new Key(key, segment, s));
                    Callback.onSuccess((MASCallback)callback, null);
                }
                catch (Exception e) {
                    Callback.onError((MASCallback)callback, (Throwable)e);
                }
            }
        }, segment, callback);
    }

    public void deleteAll(final int segment, final MASCallback<Void> callback) {
        this.execute(new Functions.UnaryVoid<String>(){

            public void call(String s) {
                try {
                    MASSecureLocalStorage.this.dataSource.removeAll((Object)new Key(null, segment, s));
                    Callback.onSuccess((MASCallback)callback, null);
                }
                catch (Exception e) {
                    Callback.onError((MASCallback)callback, (Throwable)e);
                }
            }
        }, segment, callback);
    }

    @Override
    public void keySet(final int segment, final MASCallback<Set<String>> callback) {
        this.execute(new Functions.UnaryVoid<String>(){

            public void call(String s) {
                try {
                    HashSet localStoreKeys = new HashSet(MASSecureLocalStorage.this.dataSource.getKeys((Object)new Key(null, segment, s)));
                    HashSet<String> keys = new HashSet<String>();
                    for (LocalStoreKey k : localStoreKeys) {
                        keys.add(k.getKey());
                    }
                    Callback.onSuccess((MASCallback)callback, keys);
                }
                catch (Exception e) {
                    Callback.onError((MASCallback)callback, (Throwable)e);
                }
            }
        }, segment, callback);
    }

    private void setEncryptionProvider(@NonNull EncryptionProvider provider) {
        this.encProvider = provider;
    }

    private void execute(Functions.UnaryVoid<String> function, int segment, MASCallback callback) {
        switch (segment) {
            case 1: 
            case 3: {
                this.execute(function, callback);
                break;
            }
            case 2: {
                this.execute(function, (String)null);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported storage segment");
            }
        }
    }

    private void execute(final Functions.UnaryVoid<String> function, final MASCallback callback) {
        if (MASUser.getCurrentUser() != null && MASUser.getCurrentUser().getUserName() != null) {
            if (!MASUser.getCurrentUser().isSessionLocked()) {
                this.execute(function, MASUser.getCurrentUser().getUserName());
            } else {
                Callback.onError((MASCallback)callback, (Throwable)new SecureLockException("The session is currently locked."));
            }
        } else {
            MASUser.login((MASCallback)new MASCallback<MASUser>(){

                public void onSuccess(MASUser result) {
                    MASSecureLocalStorage.this.execute((Functions.UnaryVoid<String>)function, result.getUserName());
                }

                public void onError(Throwable e) {
                    Callback.onError((MASCallback)callback, (Throwable)e);
                }
            });
        }
    }

    private void execute(final Functions.UnaryVoid<String> function, final String username) {
        new AsyncTaskLoader<Void>(this.context){

            protected void onStartLoading() {
                super.onStartLoading();
                this.forceLoad();
            }

            public Void loadInBackground() {
                function.call((Object)username);
                return null;
            }
        }.startLoading();
    }

    private void setDefaultDataMarshallers() {
        this.register(new AbstractMASStorage.StringDataMarshaller());
        this.register(new AbstractMASStorage.ByteArrayDataMarshaller());
        this.register(new AbstractMASStorage.JsonDataMarshaller());
        this.register(new AbstractMASStorage.BitmapDataMarshaller());
    }

    private static class Key
    extends LocalStoreKey {
        public Key(String key, Integer segment, String createdBy) {
            super(key, segment, createdBy);
        }

        public Integer getSegment() {
            switch (super.getSegment()) {
                case 1: 
                case 3: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
            }
            throw new IllegalArgumentException("Unsupported storage segment");
        }
    }
}

