/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.store;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import com.ca.mas.core.conf.ConfigurationManager;
import com.ca.mas.core.datasource.AccountManagerStoreDataSource;
import com.ca.mas.core.datasource.DataSource;
import com.ca.mas.core.datasource.MASSecureStorageDataSource;
import com.ca.mas.core.io.Charsets;
import com.ca.mas.core.security.KeyStoreException;
import com.ca.mas.core.store.TokenManager;
import com.ca.mas.core.store.TokenStoreException;
import com.ca.mas.core.token.IdToken;
import com.ca.mas.core.util.KeyUtilsAsymmetric;
import com.ca.mas.foundation.MAS;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;

class DefaultTokenManager
implements TokenManager {
    private static final String MSSO_USER_PROFILE = "msso.userProfile";
    private static final String MSSO_MAG_IDENTIFIER = "msso.magIdentifier";
    private static final String MSSO_CLIENT_PRIVATE_KEY = "msso.clientCertPrivateKey";
    private static final String MSSO_CLIENT_CERT_CHAIN_PREFIX = "msso.clientCertChain_";
    private static final String MSSO_DN = "cn=msso";
    private static final String MSSO_ID_TOKEN = "msso.idToken";
    private static final String MSSO_ID_TOKEN_TYPE = "msso.idTokenType";
    private static final String MSSO_SECURE_ID_TOKEN = "msso.secureIdToken";
    private static final String MSSO_DEVICE_IDENTIFIER = "com.ca.mas.foundation.msso.DEVICE_IDENTIFIER";
    protected DataSource<String, byte[]> storage;

    DefaultTokenManager(@NonNull DataSource storage) {
        this.storage = storage;
    }

    @Override
    public void saveUserProfile(String userProfile) throws TokenStoreException {
        this.storeSecureItem(MSSO_USER_PROFILE, userProfile.getBytes(Charsets.UTF8));
    }

    @Override
    public void saveMagIdentifier(String deviceIdentifier) throws TokenStoreException {
        this.storeSecureItem(MSSO_MAG_IDENTIFIER, deviceIdentifier.getBytes(Charsets.UTF8));
    }

    @Override
    public void saveClientCertificateChain(X509Certificate[] chain) throws TokenStoreException {
        try {
            KeyUtilsAsymmetric.setCertificateChain(this.getKey(MSSO_CLIENT_CERT_CHAIN_PREFIX), chain);
        }
        catch (Exception e) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)("Unable to save client certificate chain: " + e.getMessage()), (Throwable)e);
            }
            throw new TokenStoreException("Unable to save client certificate chain: " + e.getMessage());
        }
    }

    @Override
    public void saveIdToken(IdToken idToken) throws TokenStoreException {
        this.storeSecureItem(MSSO_ID_TOKEN, idToken.getValue().getBytes(Charsets.UTF8));
        this.storeSecureItem(MSSO_ID_TOKEN_TYPE, idToken.getType().getBytes(Charsets.UTF8));
    }

    @Override
    public void deleteIdToken() throws TokenStoreException {
        this.deleteSecureItem(MSSO_ID_TOKEN);
        this.deleteSecureItem(MSSO_ID_TOKEN_TYPE);
    }

    @Override
    public void saveSecureIdToken(byte[] idToken) throws TokenStoreException {
        this.storeSecureItem(MSSO_SECURE_ID_TOKEN, idToken);
    }

    @Override
    public void deleteSecureIdToken() throws TokenStoreException {
        this.deleteSecureItem(MSSO_SECURE_ID_TOKEN);
    }

    @Override
    public void deleteUserProfile() throws TokenStoreException {
        this.deleteSecureItem(MSSO_USER_PROFILE);
    }

    @Override
    public void clear() throws TokenStoreException {
        this.deleteIdToken();
        this.deleteUserProfile();
        this.deleteSecureIdToken();
        KeyUtilsAsymmetric.deletePrivateKey(this.getKey(MSSO_CLIENT_PRIVATE_KEY));
        KeyUtilsAsymmetric.clearCertificateChain(this.getKey(MSSO_CLIENT_CERT_CHAIN_PREFIX));
        this.deleteSecureItem(MSSO_MAG_IDENTIFIER);
        KeyUtilsAsymmetric.deletePrivateKey(MSSO_DEVICE_IDENTIFIER);
    }

    @Override
    public void clearAll() {
        this.storage.removeAll(null);
        KeyUtilsAsymmetric.deletePrivateKey(this.getKey(MSSO_CLIENT_PRIVATE_KEY));
        KeyUtilsAsymmetric.clearCertificateChain(this.getKey(MSSO_CLIENT_CERT_CHAIN_PREFIX));
        KeyUtilsAsymmetric.deletePrivateKey(MSSO_DEVICE_IDENTIFIER);
    }

    @Override
    public boolean isTokenStoreReady() {
        return this.storage.isReady();
    }

    @Override
    public DataSource getTokenStore() {
        return this.storage;
    }

    @Override
    public String getUserProfile() {
        try {
            byte[] userProfileBytes = this.retrieveSecureItem(MSSO_USER_PROFILE);
            if (userProfileBytes == null) {
                return null;
            }
            return new String(userProfileBytes, Charsets.UTF8);
        }
        catch (TokenStoreException e) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)("Unable to access client username: " + e.getMessage()), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public String getMagIdentifier() {
        try {
            byte[] identBytes = this.retrieveSecureItem(MSSO_MAG_IDENTIFIER);
            if (identBytes == null) {
                return null;
            }
            return new String(identBytes, Charsets.UTF8);
        }
        catch (TokenStoreException e) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)("Unable to access client device identifier: " + e.getMessage()), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public PrivateKey createPrivateKey(Context ctx, int keyBits) throws KeyStoreException {
        if (this.storage instanceof AccountManagerStoreDataSource || this.storage instanceof MASSecureStorageDataSource) {
            return KeyUtilsAsymmetric.generateRsaPrivateKey(keyBits, this.getKey(MSSO_CLIENT_PRIVATE_KEY), MSSO_DN, false, false, -1, false);
        }
        return KeyUtilsAsymmetric.generateRsaPrivateKey(keyBits, this.getKey(MSSO_CLIENT_PRIVATE_KEY), MSSO_DN, true, false, -1, false);
    }

    @Override
    public PrivateKey getClientPrivateKey() {
        try {
            return KeyUtilsAsymmetric.getRsaPrivateKey(this.getKey(MSSO_CLIENT_PRIVATE_KEY));
        }
        catch (Exception e) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)("Unable to get client private key: " + e.getMessage()), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public PublicKey getClientPublicKey() {
        try {
            return KeyUtilsAsymmetric.getRsaPublicKey(this.getKey(MSSO_CLIENT_PRIVATE_KEY));
        }
        catch (Exception e) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)("Unable to get client public key: " + e.getMessage()), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public boolean isClientCertificateChainAvailable() {
        try {
            return KeyUtilsAsymmetric.getCertificateChain(this.getKey(MSSO_CLIENT_CERT_CHAIN_PREFIX)) != null;
        }
        catch (Exception e) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)("Unable to access client cert chain: " + e.getMessage()), (Throwable)e);
            }
            return false;
        }
    }

    @Override
    public X509Certificate[] getClientCertificateChain() {
        try {
            return KeyUtilsAsymmetric.getCertificateChain(this.getKey(MSSO_CLIENT_CERT_CHAIN_PREFIX));
        }
        catch (Exception e) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)("Unable to access client cert chain: " + e.getMessage()), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public IdToken getIdToken() {
        try {
            byte[] bytes = this.retrieveSecureItem(MSSO_ID_TOKEN);
            if (bytes == null) {
                return null;
            }
            String idToken = new String(bytes, Charsets.UTF8);
            bytes = this.retrieveSecureItem(MSSO_ID_TOKEN_TYPE);
            String idTokenType = null;
            if (bytes != null) {
                idTokenType = new String(bytes, Charsets.UTF8);
            }
            return new IdToken(idToken, idTokenType);
        }
        catch (TokenStoreException e) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)("Unable to access ID token: " + e.getMessage()), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public byte[] getSecureIdToken() {
        try {
            return this.retrieveSecureItem(MSSO_SECURE_ID_TOKEN);
        }
        catch (TokenStoreException e) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)("Unable to retrieve encrypted ID token: " + e.getMessage()), (Throwable)e);
            }
            return null;
        }
    }

    private void deleteSecureItem(String name) throws TokenStoreException {
        try {
            this.storage.remove(this.getKey(name));
        }
        catch (Exception e) {
            throw new TokenStoreException(e);
        }
    }

    private void storeSecureItem(String name, byte[] item) throws TokenStoreException {
        try {
            this.storage.put(this.getKey(name), item);
        }
        catch (Exception e) {
            throw new TokenStoreException(e);
        }
    }

    private byte[] retrieveSecureItem(String name) throws TokenStoreException {
        try {
            return this.storage.get(this.getKey(name));
        }
        catch (Exception e) {
            throw new TokenStoreException(e);
        }
    }

    private String getKey(String name) {
        return ConfigurationManager.getInstance().getConnectedGateway().toString() + name;
    }
}

