/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.storage.sharedstorage;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Base64;
import androidx.annotation.NonNull;
import com.ca.mas.core.storage.sharedstorage.StorageActions;
import com.ca.mas.foundation.MAS;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SharedPreferencesUtil
implements StorageActions {
    private String prefsName;
    private Context context;
    private SharedPreferences sharedpreferences;

    public SharedPreferencesUtil(String prefsName) {
        if (prefsName == null || prefsName.isEmpty()) {
            return;
        }
        this.prefsName = prefsName;
        this.context = MAS.getContext();
        this.sharedpreferences = this.context.getSharedPreferences(prefsName, 0);
    }

    @Override
    public void save(@NonNull String key, byte[] value) {
        this.put(key, value == null ? "" : Base64.encodeToString((byte[])value, (int)0));
    }

    @Override
    public void save(@NonNull String key, String value) {
        this.put(key, value);
    }

    private void put(@NonNull String key, String value) {
        SharedPreferences.Editor editor = this.sharedpreferences.edit();
        editor.putString(key, value);
        editor.apply();
    }

    @Override
    public String getString(@NonNull String key) {
        return this.sharedpreferences.getString(key, null);
    }

    @Override
    public byte[] getBytes(@NonNull String key) {
        String retrieve = this.sharedpreferences.getString(key, null);
        if (retrieve != null) {
            return retrieve.getBytes();
        }
        return null;
    }

    @Override
    public List<String> getKeys() {
        Map allEntries = this.sharedpreferences.getAll();
        ArrayList<String> retData = new ArrayList<String>();
        for (Map.Entry entry : allEntries.entrySet()) {
            retData.add((String)entry.getKey());
        }
        return retData;
    }

    @Override
    public void delete(@NonNull String key) {
        SharedPreferences.Editor editor = this.sharedpreferences.edit();
        editor.remove(key);
        editor.apply();
    }

    @Override
    public void removeAll() {
        List<String> keys = this.getKeys();
        for (String key : keys) {
            this.delete(key);
        }
    }
}

