/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.storage.sharedstorage;

import android.content.Context;
import androidx.annotation.NonNull;
import com.ca.mas.core.security.EncryptionProvider;
import com.ca.mas.core.storage.sharedstorage.AccountManagerUtil;
import com.ca.mas.core.storage.sharedstorage.SharedPreferencesUtil;
import com.ca.mas.core.storage.sharedstorage.StorageActions;
import com.ca.mas.foundation.MAS;
import java.util.List;

public class MASSharedStorage {
    private StorageActions storageProvider;
    private boolean isSharedStorage;
    private boolean storageMode;
    private Context context;
    private String mAccountName;

    public MASSharedStorage(@NonNull String accountName, boolean shared, boolean storageSource) {
        if (accountName == null || accountName.isEmpty()) {
            throw new IllegalArgumentException("Account name cannot be null.");
        }
        this.context = MAS.getContext();
        if (this.context == null) {
            throw new IllegalStateException("MAS SDK has not been initialized.");
        }
        this.mAccountName = accountName;
        this.isSharedStorage = shared;
        this.storageMode = storageSource;
        this.storageProvider = this.getStorageProvider();
    }

    public MASSharedStorage(String accountName) {
        this(accountName, true, true);
    }

    protected void preconditionCheck(String key) {
        if (MAS.getContext() == null) {
            throw new IllegalArgumentException("The SDK should be initialized.");
        }
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Data key should be a String that cannot be null or empty.");
        }
    }

    public void save(@NonNull String key, String value) {
        this.preconditionCheck(key);
        this.storageProvider.save(key, value);
    }

    public void save(@NonNull String key, byte[] value) {
        this.preconditionCheck(key);
        this.storageProvider.save(key, value);
    }

    public void delete(@NonNull String key) {
        this.preconditionCheck(key);
        this.storageProvider.delete(key);
    }

    public String getString(String key) {
        this.preconditionCheck(key);
        return this.storageProvider.getString(key);
    }

    public byte[] getBytes(String key) {
        this.preconditionCheck(key);
        return this.storageProvider.getBytes(key);
    }

    protected EncryptionProvider getEncryptionProvider() {
        return new EncryptionProvider(){

            @Override
            public byte[] encrypt(byte[] data) {
                return data;
            }

            @Override
            public byte[] decrypt(byte[] data) {
                return data;
            }
        };
    }

    private StorageActions getStorageProvider() {
        StorageActions storage = this.storageMode ? new AccountManagerUtil(this.context, this.mAccountName, this.isSharedStorage) : new SharedPreferencesUtil(this.mAccountName);
        return storage;
    }

    public List<String> getKeys() {
        return this.storageProvider.getKeys();
    }

    public void removeAll() {
        this.storageProvider.removeAll();
    }
}

