/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.storage.sharedstorage;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.content.res.XmlResourceParser;
import android.os.Parcel;
import android.util.Base64;
import android.util.Log;
import androidx.annotation.NonNull;
import com.ca.mas.core.storage.sharedstorage.MASAuthenticatorService;
import com.ca.mas.core.storage.sharedstorage.SharedStorageIdentifier;
import com.ca.mas.core.storage.sharedstorage.StorageActions;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASSharedStorageException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AccountManagerUtil
implements StorageActions {
    private static final Object mutex = new Object();
    private static final String KEYINDEX_COLUMN_NAME = "mas_shared_storage_lookup_index";
    private AccountManager mAccountManager;
    private boolean shared;
    private Account mAccount;

    public AccountManagerUtil(Context context, String accountName, boolean sharedStorage) {
        String accountType = this.getAccountType(context);
        if (accountType == null || accountType.isEmpty()) {
            throw new IllegalArgumentException("Account type cannot be null.");
        }
        this.shared = sharedStorage;
        try {
            Account[] accounts;
            SharedStorageIdentifier identifier = new SharedStorageIdentifier();
            this.mAccountManager = AccountManager.get((Context)MAS.getContext());
            for (Account account : accounts = this.mAccountManager.getAccountsByType(accountType)) {
                String savedPassword;
                if (!accountName.equals(account.name)) continue;
                String password = this.mAccountManager.getPassword(account);
                if (password.equals(savedPassword = identifier.toString())) {
                    this.mAccount = account;
                    continue;
                }
                this.mAccount = null;
                identifier = new SharedStorageIdentifier();
            }
            if (this.mAccount == null) {
                this.mAccount = new Account(accountName, accountType);
                this.mAccountManager.addAccountExplicitly(this.mAccount, identifier.toString(), null);
            }
        }
        catch (Exception e) {
            throw new MASSharedStorageException(e.getMessage(), e);
        }
    }

    private String getAccountType(Context context) {
        try {
            ComponentName cn = new ComponentName(context, MASAuthenticatorService.class);
            ServiceInfo info = context.getPackageManager().getServiceInfo(cn, 128);
            int resourceId = info.metaData.getInt("android.accounts.AccountAuthenticator");
            return this.parseResourceXml(context, resourceId);
        }
        catch (PackageManager.NameNotFoundException | NullPointerException e) {
            Log.e((String)"MAS", (String)("Failed to load meta-data from the service: " + e.getMessage()));
            return null;
        }
    }

    private String parseResourceXml(Context context, int resourceId) {
        try {
            XmlResourceParser xrp = context.getResources().getXml(resourceId);
            xrp.next();
            int eventType = xrp.getEventType();
            while (eventType != 1) {
                if (eventType == 2 || eventType == 3) {
                    for (int i = 0; i < xrp.getAttributeCount(); ++i) {
                        String name = xrp.getAttributeName(i);
                        if (!"accountType".equals(name)) continue;
                        return xrp.getAttributeValue(i);
                    }
                }
                eventType = xrp.next();
            }
        }
        catch (Exception e) {
            Log.e((String)"MAS", (String)("Failed to load meta-data from the service: " + e.getMessage()));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIndex(@NonNull String key, boolean add) {
        Object object = mutex;
        synchronized (object) {
            Set<String> keys = this.getKeySet();
            if (add) {
                keys.add(key);
            } else {
                keys.remove(key);
            }
            byte[] bytes = this.marshall(keys);
            String encoded = Base64.encodeToString((byte[])bytes, (int)0);
            this.mAccountManager.setUserData(this.mAccount, KEYINDEX_COLUMN_NAME, encoded);
        }
    }

    private byte[] marshall(Set<String> keys) {
        Parcel p = Parcel.obtain();
        ArrayList<String> strings = new ArrayList<String>(keys);
        p.writeStringList(strings);
        byte[] bytes = p.marshall();
        p.recycle();
        return bytes;
    }

    private List<String> unmarshall(String encodedKeyString) {
        ArrayList result = new ArrayList();
        if (encodedKeyString == null) {
            return result;
        }
        byte[] bytes = Base64.decode((String)encodedKeyString, (int)0);
        Parcel p = Parcel.obtain();
        p.unmarshall(bytes, 0, bytes.length);
        p.setDataPosition(0);
        result = p.createStringArrayList();
        p.recycle();
        return result;
    }

    private Set<String> getKeySet() {
        String keyString = this.mAccountManager.getUserData(this.mAccount, KEYINDEX_COLUMN_NAME);
        return new HashSet<String>(this.unmarshall(keyString));
    }

    @Override
    public void save(@NonNull String key, String value) {
        this.mAccountManager.setUserData(this.mAccount, this.proxyKey(key), value == null ? "" : value);
        this.updateIndex(key, true);
    }

    @Override
    public void save(@NonNull String key, byte[] value) {
        this.mAccountManager.setUserData(this.mAccount, this.proxyKey(key), value == null ? "" : Base64.encodeToString((byte[])value, (int)0));
        this.updateIndex(key, true);
    }

    @Override
    public void delete(@NonNull String key) {
        this.mAccountManager.setUserData(this.mAccount, this.proxyKey(key), null);
        this.updateIndex(key, false);
    }

    @Override
    public String getString(@NonNull String key) {
        return this.mAccountManager.getUserData(this.mAccount, this.proxyKey(key));
    }

    @Override
    public byte[] getBytes(@NonNull String key) {
        String byteString = this.mAccountManager.getUserData(this.mAccount, this.proxyKey(key));
        if (byteString != null) {
            return Base64.decode((String)byteString, (int)0);
        }
        return null;
    }

    @Override
    public List<String> getKeys() {
        String keyBlob = this.mAccountManager.getUserData(this.mAccount, KEYINDEX_COLUMN_NAME);
        return this.unmarshall(keyBlob);
    }

    @Override
    public void removeAll() {
        List<String> keys = this.getKeys();
        for (String key : keys) {
            this.delete(key);
        }
    }

    private String proxyKey(String key) {
        if (key == null || key.isEmpty()) {
            return null;
        }
        String retVal = key;
        if (!this.shared) {
            retVal = MAS.getContext().getPackageName() + "_" + retVal;
        }
        return retVal;
    }
}

