/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.service;

import android.app.Service;
import android.content.Intent;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.ResultReceiver;
import android.util.Log;
import com.ca.mas.core.MobileSsoListener;
import com.ca.mas.core.ResponseInterceptor;
import com.ca.mas.core.conf.ConfigurationManager;
import com.ca.mas.core.context.MssoContext;
import com.ca.mas.core.error.MAGError;
import com.ca.mas.core.error.MAGServerException;
import com.ca.mas.core.oauth.OAuthClient;
import com.ca.mas.core.oauth.OAuthException;
import com.ca.mas.core.oauth.OAuthServerException;
import com.ca.mas.core.policy.exceptions.CredentialRequiredException;
import com.ca.mas.core.policy.exceptions.TokenStoreUnavailableException;
import com.ca.mas.core.service.AuthenticationProvider;
import com.ca.mas.core.service.MssoActiveQueue;
import com.ca.mas.core.service.MssoExecutorService;
import com.ca.mas.core.service.MssoRequest;
import com.ca.mas.core.service.MssoRequestQueue;
import com.ca.mas.core.service.MssoResponse;
import com.ca.mas.core.service.MssoResponseQueue;
import com.ca.mas.core.service.MssoServiceState;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASAuthCredentials;
import com.ca.mas.foundation.MASRequest;
import com.ca.mas.foundation.MASResponse;
import java.io.Serializable;
import java.util.ArrayList;

public class MssoService
extends Service {
    private final IBinder binder = new MASBinder();
    private Looper mServiceLooper;
    private volatile ServiceHandler mServiceHandler;

    public void onCreate() {
        super.onCreate();
        HandlerThread handlerThread = new HandlerThread("BoundService Thread");
        handlerThread.start();
        this.mServiceLooper = handlerThread.getLooper();
        this.mServiceHandler = new ServiceHandler(this.mServiceLooper);
    }

    public IBinder onBind(Intent intent) {
        if (MAS.DEBUG) {
            Log.d((String)"MAS", (String)"MssoService onBind");
        }
        return this.binder;
    }

    public boolean onUnbind(Intent intent) {
        if (MAS.DEBUG) {
            Log.d((String)"MAS", (String)"MssoService onUnBind");
        }
        return super.onUnbind(intent);
    }

    public void handleWork(Intent work) {
        Message msg = new Message();
        msg.obj = work;
        this.mServiceHandler.sendMessage(msg);
    }

    public void onHandleWork(Intent intent) {
        String action;
        if (MAS.DEBUG) {
            Log.d((String)"MAS", (String)"MssoService onHandleWork");
        }
        if ((action = intent.getAction()) == null) {
            if (MAS.DEBUG) {
                Log.w((String)"MAS", (String)"Intent did not contain an action");
            }
            return;
        }
        Bundle extras = intent.getExtras();
        if (extras == null || !extras.containsKey("com.ca.mas.core.service.req.extra.requestId")) {
            if (MAS.DEBUG) {
                Log.w((String)"MAS", (String)"Intent did not contain extras that included a request ID");
            }
            return;
        }
        long requestId = extras.getLong("com.ca.mas.core.service.req.extra.requestId");
        if (requestId == -1L) {
            this.onProcessAllPendingRequests();
            return;
        }
        MssoRequest request = this.takeActiveRequest(requestId);
        if (request == null) {
            if (MAS.DEBUG) {
                Log.d((String)"MAS", (String)"Request ID not found, assuming request is canceled or already processed");
            }
            return;
        }
        if ("com.ca.mas.core.service.action.PROCESS_REQUEST".equals(action)) {
            this.startThreadedRequest(extras, request);
            return;
        }
        if ("com.ca.mas.core.service.action.CREDENTIALS_OBTAINED".equals(action)) {
            this.onCredentialsObtained(extras, request);
            return;
        }
        if (MAS.DEBUG) {
            Log.w((String)"MAS", (String)("Ignoring intent with unrecognized action " + action));
        }
    }

    private void startThreadedRequest(Bundle extras, final MssoRequest request) {
        request.setRunning(true);
        request.setExtra(extras);
        try {
            MssoExecutorService.getInstance().execute(new Runnable(){

                @Override
                public void run() {
                    MssoService.this.onProcessRequest(request);
                }
            });
        }
        catch (Exception e) {
            request.setRunning(false);
            this.requestFinished(request);
            this.respondError(request.getResultReceiver(), new MAGError(e));
        }
    }

    private void onCredentialsObtained(Bundle extras, MssoRequest request) {
        MASAuthCredentials creds = (MASAuthCredentials)extras.getParcelable("com.ca.mas.core.service.req.extra.credentials");
        request.getMssoContext().setCredentials(creds);
        this.onProcessRequest(request);
    }

    private void onProcessAllPendingRequests() {
        ArrayList<MssoRequest> requests = new ArrayList<MssoRequest>(MssoActiveQueue.getInstance().getAllRequest());
        for (MssoRequest mssoRequest : requests) {
            if (mssoRequest.isRunning()) continue;
            this.startThreadedRequest(null, mssoRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onProcessRequest(MssoRequest request) {
        request.setRunning(true);
        ResultReceiver receiver = request.getResultReceiver();
        MssoContext mssoContext = request.getMssoContext();
        try {
            MASResponse magResponse = mssoContext.executeRequest(request.getExtra(), request.getRequest());
            if (this.handleInterceptors(request.getId(), request.getRequest(), request.getExtra(), magResponse)) {
                return;
            }
            if (this.requestFinished(request)) {
                MssoResponse response = this.createMssoResponse(request, magResponse);
                MssoResponseQueue.getInstance().addResponse(response);
                this.respondSuccess(receiver, response.getId(), "OK");
            }
        }
        catch (CredentialRequiredException e) {
            if (MAS.DEBUG) {
                Log.d((String)"MAS", (String)"Request for user credentials");
            }
            MobileSsoListener mobileSsoListener = ConfigurationManager.getInstance().getMobileSsoListener();
            AuthenticationProvider authProvider = null;
            if (!MAS.isBrowserBasedAuthenticationEnabled()) {
                try {
                    authProvider = new OAuthClient(request.getMssoContext()).getSocialPlatformProvider(this.getApplicationContext());
                }
                catch (OAuthException | OAuthServerException e1) {
                    if (MAS.DEBUG) {
                        Log.e((String)"MAS", (String)e1.getMessage(), (Throwable)e1);
                    }
                    authProvider = null;
                }
            }
            if (mobileSsoListener != null) {
                mobileSsoListener.onAuthenticateRequest(request.getId(), authProvider);
            } else if (MAS.DEBUG) {
                Log.w((String)"MAS", (String)"No Authentication listener is registered");
            }
        }
        catch (TokenStoreUnavailableException e) {
            try {
                mssoContext.getTokenManager().getTokenStore().unlock();
            }
            catch (Exception e1) {
                this.handleErrorResponse(request, e1);
            }
        }
        catch (MAGServerException e) {
            if (this.handleInterceptors(request.getId(), request.getRequest(), request.getExtra(), e.getResponse())) {
                return;
            }
            this.handleErrorResponse(request, e);
        }
        catch (Exception e) {
            this.handleErrorResponse(request, e);
        }
        finally {
            request.setRunning(false);
        }
    }

    private void handleErrorResponse(MssoRequest request, Exception e) {
        if (MAS.DEBUG) {
            Log.e((String)"MAS", (String)e.getMessage(), (Throwable)e);
        }
        if (this.requestFinished(request)) {
            this.respondError(request.getResultReceiver(), new MAGError(e));
        }
    }

    private boolean handleInterceptors(long requestId, MASRequest request, Bundle requestExtra, MASResponse response) {
        for (ResponseInterceptor ri : ConfigurationManager.getInstance().getResponseInterceptors()) {
            if (!ri.intercept(requestId, request, requestExtra, response)) continue;
            return true;
        }
        return false;
    }

    private MssoResponse createMssoResponse(MssoRequest request, MASResponse response) {
        return new MssoResponse(request, response);
    }

    private MssoRequest takeActiveRequest(long requestId) {
        MssoRequest request = MssoRequestQueue.getInstance().takeRequest(requestId);
        if (request != null) {
            MssoActiveQueue.getInstance().addRequest(request);
            return request;
        }
        request = MssoActiveQueue.getInstance().getRequest(requestId);
        return request;
    }

    private boolean requestFinished(MssoRequest request) {
        return null != MssoActiveQueue.getInstance().takeRequest(request.getId());
    }

    private void respondError(ResultReceiver receiver, MAGError error) {
        if (receiver != null) {
            Bundle resultData = new Bundle();
            resultData.putSerializable("com.ca.mas.core.service.result.error", (Serializable)error);
            resultData.putString("com.ca.mas.core.service.result.errorMessage", error.getMessage());
            receiver.send(1, resultData);
        }
    }

    private void respondSuccess(ResultReceiver receiver, long requestId, String errorMessage) {
        if (receiver != null) {
            Bundle resultData = new Bundle();
            resultData.putString("com.ca.mas.core.service.result.errorMessage", errorMessage);
            resultData.putLong("com.ca.mas.core.service.result.requestId", requestId);
            receiver.send(0, resultData);
        }
    }

    public void onDestroy() {
        if (MAS.DEBUG) {
            Log.d((String)"MAS", (String)"MssoService onDestroy");
        }
        if (Build.VERSION.SDK_INT >= 18) {
            this.mServiceLooper.quitSafely();
        } else {
            this.mServiceLooper.quit();
        }
        MssoServiceState.getInstance().setBound(false);
        super.onDestroy();
    }

    public class MASBinder
    extends Binder {
        public MssoService getService() {
            return MssoService.this;
        }
    }

    private final class ServiceHandler
    extends Handler {
        public ServiceHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            MssoService.this.onHandleWork((Intent)msg.obj);
        }
    }
}

