/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.security;

import android.content.Context;
import androidx.annotation.NonNull;
import com.ca.mas.core.security.KeyStoreKeyStorageProvider;
import com.ca.mas.core.storage.sharedstorage.AccountManagerUtil;
import com.ca.mas.foundation.MAS;

public class MASSecretKeyProvider
extends KeyStoreKeyStorageProvider {
    private AccountManagerUtil storage;
    private String acName;

    public MASSecretKeyProvider(@NonNull Context ctx, String accountName) {
        super(ctx);
        this.acName = accountName;
        this.createStorageInstance();
    }

    @Override
    boolean storeSecretKeyLocally(String alias, byte[] encryptedSecretKey) {
        this.createStorageInstance();
        this.storage.save(alias, encryptedSecretKey);
        return true;
    }

    @Override
    byte[] getEncryptedSecretKey(String alias) {
        this.createStorageInstance();
        return this.storage.getBytes(alias);
    }

    @Override
    boolean deleteSecretKeyLocally(String alias) {
        this.createStorageInstance();
        this.storage.delete(alias);
        return true;
    }

    private void createStorageInstance() {
        if (this.storage == null) {
            this.storage = new AccountManagerUtil(MAS.getContext(), this.acName, true);
        }
    }
}

