/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.security;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.ca.mas.core.security.EncryptionProvider;
import com.ca.mas.core.util.KeyUtilsAsymmetric;
import com.ca.mas.core.util.KeyUtilsSymmetric;
import com.ca.mas.foundation.MAS;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.SecretKey;

public class LockableEncryptionProvider
implements EncryptionProvider {
    protected Context ctx = null;
    private String keyAlias = "com.ca.mas.LOCKABLE_KEY";

    public LockableEncryptionProvider(@NonNull Context ctx) {
        this.ctx = ctx;
    }

    public LockableEncryptionProvider(@NonNull Context ctx, @NonNull String keyAlias) {
        this.ctx = ctx;
        this.keyAlias = keyAlias;
    }

    @Override
    @RequiresApi(value=23)
    public byte[] encrypt(byte[] data) {
        try {
            KeyUtilsAsymmetric.generateRsaPrivateKey(this.keyAlias, "cn=" + this.keyAlias, true, true, 4, false);
            PublicKey pubkey = KeyUtilsAsymmetric.getRsaPublicKey(this.keyAlias);
            return KeyUtilsAsymmetric.encrypt(pubkey, data);
        }
        catch (Exception x) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)"Unable to encrypt given data");
            }
            throw new RuntimeException(x);
        }
    }

    @Override
    @RequiresApi(value=23)
    public byte[] decrypt(byte[] encryptedData) {
        try {
            Key keyStoreKey = KeyUtilsAsymmetric.getKeystoreKey(this.keyAlias);
            if (keyStoreKey instanceof PrivateKey) {
                PrivateKey privkey = KeyUtilsAsymmetric.getRsaPrivateKey(this.keyAlias);
                return KeyUtilsAsymmetric.decrypt(privkey, encryptedData);
            }
            SecretKey secretKey = (SecretKey)keyStoreKey;
            return KeyUtilsSymmetric.decrypt(encryptedData, secretKey, this.keyAlias);
        }
        catch (Exception x) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)"Unable to decrypt given data.");
            }
            throw new RuntimeException(x);
        }
    }

    public boolean clear() {
        KeyUtilsAsymmetric.deletePrivateKey(this.keyAlias);
        return true;
    }
}

