/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.request;

import com.ca.mas.core.context.MssoContext;
import com.ca.mas.core.request.internal.LocalRequest;
import com.ca.mas.core.request.internal.MAGRequestProxy;
import com.ca.mas.foundation.MASRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MAGInternalRequest
extends MAGRequestProxy {
    private Map<String, List<String>> magHeaders = new HashMap<String, List<String>>();
    private MssoContext context;

    public MAGInternalRequest(MssoContext context, MASRequest request) {
        this.context = context;
        this.request = request;
    }

    public void addHeader(String name, String value) {
        List<String> values = this.magHeaders.get(name);
        if (values == null) {
            values = new ArrayList<String>();
            this.magHeaders.put(name, values);
        }
        values.add(value);
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>(super.getHeaders());
        for (String key : this.magHeaders.keySet()) {
            List<String> value = this.magHeaders.get(key);
            result.put(key, value);
        }
        return result;
    }

    @Override
    public String getScope() {
        String scope = super.getScope();
        if (scope == null) {
            return this.context.getConfigurationProvider().getClientScope();
        }
        return scope;
    }

    public boolean isLocalRequest() {
        return this.request instanceof LocalRequest;
    }

    public MASRequest getRequest() {
        return this.request;
    }
}

