/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.oauth;

import com.ca.mas.core.client.ServerResponse;
import com.ca.mas.core.token.IdToken;
import org.json.JSONException;

public class OAuthTokenResponse
extends ServerResponse {
    public OAuthTokenResponse(int status, String json) throws JSONException {
        super(status, json);
    }

    public OAuthTokenResponse(int status, int errorCode, String json) throws JSONException {
        super(status, errorCode, json);
    }

    public OAuthTokenResponse(ServerResponse response) throws JSONException {
        super(response.getStatus(), response.getErrorCode(), response.getJson());
    }

    public String getAccessToken() {
        return this.parsed.optString("access_token", null);
    }

    public String getRefreshToken() {
        return this.parsed.optString("refresh_token", null);
    }

    public String getGrantedScope() {
        return this.parsed.optString("scope");
    }

    public boolean isBearer() {
        return "bearer".equalsIgnoreCase(this.parsed.optString("token_type"));
    }

    public long getExpiresIn() {
        try {
            return this.parsed.getLong("expires_in");
        }
        catch (JSONException e) {
            return 0L;
        }
    }

    public IdToken getIdToken() {
        String idToken = this.parsed.optString("id_token", null);
        if (idToken != null) {
            return new IdToken(idToken, this.parsed.optString("id_token_type", null));
        }
        return null;
    }
}

