/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.http;

import android.os.Build;
import android.util.Log;
import com.ca.mas.core.conf.ConfigurationManager;
import com.ca.mas.core.http.SSLSocketFactoryProvider;
import com.ca.mas.core.store.StorageProvider;
import com.ca.mas.core.store.TokenManager;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASRequest;
import com.ca.mas.foundation.MASRequestBody;
import com.ca.mas.foundation.MASResponse;
import com.ca.mas.foundation.MASResponseBody;
import com.ca.mas.foundation.MASSecurityConfiguration;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSocketFactory;

public class MAGHttpClient {
    public <T> MASResponse<T> execute(MASRequest request, MASSecurityConfiguration securityConfiguration) throws IOException {
        return this.execute(request, SSLSocketFactoryProvider.getInstance().createSSLSocketFactory(securityConfiguration));
    }

    public <T> MASResponse<T> execute(MASRequest request) throws IOException {
        return this.execute(request, SSLSocketFactoryProvider.getInstance().get(request.getURL()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> MASResponse<T> execute(MASRequest request, SSLSocketFactory sslSocketFactory) throws IOException {
        HttpURLConnection urlConnection = (HttpURLConnection)request.getURL().openConnection();
        if (MAS.DEBUG) {
            Log.d((String)"MAS", (String)String.format("API Request Url: %s", request.getURL()));
            Log.d((String)"MAS", (String)String.format("API Request Method: %s", request.getMethod()));
        }
        try {
            String responseMessage;
            int responseCode;
            Object sp;
            TokenManager tm;
            Object magIdentifier;
            if (!request.isPublic() && (magIdentifier = (tm = ((StorageProvider)(sp = StorageProvider.getInstance())).getTokenManager()).getMagIdentifier()) != null) {
                urlConnection.setRequestProperty("mag-identifier", (String)magIdentifier);
            }
            this.onConnectionObtained(urlConnection);
            if (request.getConnectionListener() != null) {
                request.getConnectionListener().onObtained(urlConnection);
            }
            if (urlConnection instanceof HttpsURLConnection) {
                ((HttpsURLConnection)urlConnection).setSSLSocketFactory(sslSocketFactory);
            }
            if (ConfigurationManager.getInstance().getConnectionListener() != null) {
                ConfigurationManager.getInstance().getConnectionListener().onObtained(urlConnection);
            }
            if (request.getMethod().equals("PATCH") && Build.VERSION.SDK_INT <= 18) {
                urlConnection.setRequestProperty("X-HTTP-Method-Override", "PATCH");
                urlConnection.setRequestMethod("POST");
            } else {
                urlConnection.setRequestMethod(request.getMethod());
            }
            urlConnection.setDoInput(true);
            urlConnection.setRequestProperty("Connection", "Keep-Alive");
            for (String key : request.getHeaders().keySet()) {
                if (request.getHeaders().get(key) == null) continue;
                for (String value : request.getHeaders().get(key)) {
                    urlConnection.setRequestProperty(key, value);
                }
            }
            MASRequestBody body = request.getBody();
            if (body != null) {
                List<String> reqHeader;
                urlConnection.setDoOutput(true);
                if (Build.VERSION.SDK_INT > 19) {
                    if (body.getContentLength() > 0L) {
                        urlConnection.setFixedLengthStreamingMode(body.getContentLength());
                    } else {
                        urlConnection.setChunkedStreamingMode(0);
                    }
                }
                if (body.getContentType() != null && request.getHeaders() != null && (reqHeader = request.getHeaders().get("Content-Type")) == null) {
                    urlConnection.setRequestProperty("Content-Type", body.getContentType().toString());
                }
                if (request.getConnectionListener() != null) {
                    request.getConnectionListener().onConnected(urlConnection);
                }
                if (ConfigurationManager.getInstance().getConnectionListener() != null) {
                    ConfigurationManager.getInstance().getConnectionListener().onConnected(urlConnection);
                }
                body.write(urlConnection.getOutputStream());
            } else {
                if (request.getConnectionListener() != null) {
                    request.getConnectionListener().onConnected(urlConnection);
                }
                if (ConfigurationManager.getInstance().getConnectionListener() != null) {
                    ConfigurationManager.getInstance().getConnectionListener().onConnected(urlConnection);
                }
            }
            final MASResponseBody responseBody = request.getResponseBody();
            try {
                try {
                    responseCode = urlConnection.getResponseCode();
                }
                catch (IOException e) {
                    responseCode = urlConnection.getResponseCode();
                }
                responseMessage = urlConnection.getResponseMessage();
                if (MAS.DEBUG) {
                    Log.d((String)"MAS", (String)String.format("Response code: %d", responseCode));
                    Log.d((String)"MAS", (String)String.format("Response message: %s", responseMessage));
                }
                List<String> requestType = request.getHeaders().get("request-type");
                responseBody.read(urlConnection);
            }
            catch (SSLHandshakeException e) {
                if (Build.VERSION.SDK_INT < 21) {
                    if (e.getCause() != null && e.getCause() instanceof SSLProtocolException) {
                        if (MAS.DEBUG) {
                            Log.w((String)"MAS", (String)"SSLHandshakeException occurs, setting it to response 204");
                        }
                        responseCode = 204;
                        responseMessage = null;
                    }
                    throw e;
                }
                throw e;
            }
            final Map<String, List<String>> headers = urlConnection.getHeaderFields();
            final int finalResponseCode = responseCode;
            final String finalResponseMessage = responseMessage;
            MASResponse mASResponse = new MASResponse<T>(){

                @Override
                public Map<String, List<String>> getHeaders() {
                    return headers;
                }

                @Override
                public int getResponseCode() {
                    return finalResponseCode;
                }

                @Override
                public String getResponseMessage() {
                    return finalResponseMessage;
                }

                @Override
                public MASResponseBody<T> getBody() {
                    return responseBody;
                }
            };
            return mASResponse;
        }
        finally {
            urlConnection.disconnect();
        }
    }

    protected void onConnectionObtained(HttpURLConnection connection) {
    }
}

