/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.core.auth.ble;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.os.Build;
import android.os.ParcelUuid;
import android.util.Log;
import android.view.View;
import com.ca.mas.core.auth.PollingRenderer;
import com.ca.mas.core.auth.ble.BluetoothLeCentralCallback;
import com.ca.mas.core.conf.ConfigurationManager;
import com.ca.mas.core.conf.ConfigurationProvider;
import com.ca.mas.foundation.MAS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

@TargetApi(value=21)
public class BluetoothLeCentralRenderer
extends PollingRenderer {
    public static final int MAX = 20;
    private static final UUID NOTIFY_UUID = UUID.fromString("00002902-0000-1000-8000-00805f9b34fb");
    private BluetoothGatt bluetoothGatt;
    private BluetoothLeScanner scanner;
    private ScanCallback scanCallback;
    private UUID serviceUUID;
    private UUID characteristicUUID;
    private BluetoothLeCentralCallback callback;
    private int rssi = -80;

    public BluetoothLeCentralRenderer(BluetoothLeCentralCallback callback) {
        this.callback = this.getCallback(callback);
    }

    @Override
    public View render() {
        return null;
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public void onRenderCompleted() {
        super.onRenderCompleted();
        if (Build.VERSION.SDK_INT < 21) {
            this.onError(103, "Bluetooth LE session sharing not supported", null);
            return;
        }
        BluetoothManager manager = (BluetoothManager)this.context.getSystemService("bluetooth");
        if (manager == null) {
            this.onError(101, "Bluetooth LE not supported", null);
            return;
        }
        BluetoothAdapter btAdapter = manager.getAdapter();
        if (btAdapter == null) {
            this.onError(101, "Bluetooth LE not supported", null);
            return;
        }
        if (!btAdapter.isEnabled()) {
            this.onError(100, "Bluetooth LE Disabled", null);
            return;
        }
        ConfigurationProvider configurationProvider = ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider();
        String uuid = (String)configurationProvider.getProperty("msso.ble.service.uuid");
        if (uuid == null || uuid.trim().length() == 0) {
            this.onError(102, "Service UUID is not provided", null);
            return;
        }
        try {
            this.serviceUUID = UUID.fromString(uuid);
        }
        catch (IllegalArgumentException e) {
            this.onError(102, "Invalid Service UUID", e);
            return;
        }
        uuid = (String)configurationProvider.getProperty("msso.ble.characteristic.uuid");
        if (uuid == null || uuid.trim().length() == 0) {
            this.onError(102, "Characteristic UUID is not provided", null);
            return;
        }
        try {
            this.characteristicUUID = UUID.fromString(uuid);
        }
        catch (IllegalArgumentException e) {
            this.onError(102, "Invalid Characteristic UUID", e);
            return;
        }
        Integer r = (Integer)configurationProvider.getProperty("msso.ble.rssi");
        if (r != null) {
            this.rssi = r;
        }
        this.scanner = manager.getAdapter().getBluetoothLeScanner();
        this.startScan();
        this.callback.onStatusUpdate(0);
    }

    @Override
    protected void onError(int code, String message, Exception e) {
        this.close();
    }

    @Override
    public void close() {
        super.close();
        this.stopScan();
        if (this.bluetoothGatt != null) {
            this.bluetoothGatt.disconnect();
            this.bluetoothGatt.close();
        }
    }

    @SuppressLint(value={"MissingPermission"})
    private void startScan() {
        if (MAS.DEBUG) {
            Log.d((String)"MAS", (String)"Start BLE Scanning...");
        }
        this.scanCallback = new ScanCallback(){

            public synchronized void onScanResult(int callbackType, ScanResult result) {
                BluetoothLeCentralRenderer.this.callback.onStatusUpdate(2);
                if (MAS.DEBUG) {
                    Log.d((String)"MAS", (String)("BLE advertisement has been found with Rssi: " + result.getRssi()));
                }
                if (result.getRssi() > BluetoothLeCentralRenderer.this.rssi && BluetoothLeCentralRenderer.this.scanner != null) {
                    BluetoothLeCentralRenderer.this.stopScan();
                    if (MAS.DEBUG) {
                        Log.d((String)"MAS", (String)"Start process BLE session sharing.");
                    }
                    BluetoothLeCentralRenderer.this.startProcess(result.getDevice());
                }
            }
        };
        ScanFilter.Builder scanFilterBuilder = new ScanFilter.Builder();
        scanFilterBuilder.setServiceUuid(new ParcelUuid(this.serviceUUID));
        ArrayList<ScanFilter> filters = new ArrayList<ScanFilter>();
        filters.add(scanFilterBuilder.build());
        ScanSettings.Builder scanSettingBuilder = new ScanSettings.Builder();
        if (Build.VERSION.SDK_INT >= 23) {
            scanSettingBuilder.setScanMode(1).setCallbackType(1);
        } else {
            scanSettingBuilder.setScanMode(1);
        }
        this.scanner.startScan(filters, scanSettingBuilder.build(), this.scanCallback);
    }

    @SuppressLint(value={"MissingPermission"})
    private void stopScan() {
        if (this.scanner != null) {
            this.scanner.stopScan(this.scanCallback);
            this.scanner = null;
            this.callback.onStatusUpdate(1);
        }
    }

    private void startProcess(BluetoothDevice bluetoothDevice) {
        this.bluetoothGatt = bluetoothDevice.connectGatt(this.context, false, new BluetoothGattCallback(){
            private List<byte[]> session;
            private int i = 0;

            public void onServicesDiscovered(BluetoothGatt gatt, int status) {
                super.onServicesDiscovered(gatt, status);
                BluetoothGattService service = gatt.getService(BluetoothLeCentralRenderer.this.serviceUUID);
                if (service == null) {
                    BluetoothLeCentralRenderer.this.callback.onStatusUpdate(4);
                    return;
                }
                BluetoothLeCentralRenderer.this.callback.onStatusUpdate(5);
                BluetoothGattCharacteristic characteristic = service.getCharacteristic(BluetoothLeCentralRenderer.this.characteristicUUID);
                if (characteristic != null) {
                    BluetoothLeCentralRenderer.this.callback.onStatusUpdate(6);
                    BluetoothLeCentralRenderer.this.bluetoothGatt.setCharacteristicNotification(characteristic, true);
                    this.session = BluetoothLeCentralRenderer.this.splitArray(BluetoothLeCentralRenderer.this.getSessionRequest(), 20);
                    byte[] first = this.session.get(this.i);
                    characteristic.setValue(first);
                    gatt.writeCharacteristic(characteristic);
                    BluetoothGattDescriptor d = characteristic.getDescriptor(NOTIFY_UUID);
                    if (d != null) {
                        d.setValue(BluetoothGattDescriptor.ENABLE_INDICATION_VALUE);
                        BluetoothLeCentralRenderer.this.bluetoothGatt.writeDescriptor(d);
                    }
                }
            }

            public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
                if (newState == 2) {
                    BluetoothLeCentralRenderer.this.callback.onStatusUpdate(3);
                    gatt.discoverServices();
                } else if (newState == 0) {
                    BluetoothLeCentralRenderer.this.callback.onStatusUpdate(4);
                }
            }

            public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
                if (characteristic != null) {
                    byte[] result = characteristic.getValue();
                    String s = new String(result);
                    if ("0".equals(s)) {
                        BluetoothLeCentralRenderer.this.proceed();
                    } else {
                        BluetoothLeCentralRenderer.this.callback.onStatusUpdate(9);
                        BluetoothLeCentralRenderer.this.close();
                    }
                }
            }

            public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
                characteristic.setWriteType(1);
                ++this.i;
                if (this.i == this.session.size()) {
                    characteristic.setValue("EOM");
                    gatt.writeCharacteristic(characteristic);
                    return;
                }
                if (this.i > this.session.size()) {
                    BluetoothLeCentralRenderer.this.callback.onStatusUpdate(7);
                    BluetoothLeCentralRenderer.this.poll();
                    return;
                }
                characteristic.setValue(this.session.get(this.i));
                gatt.writeCharacteristic(characteristic);
            }
        });
    }

    @Override
    protected void onAuthCodeReceived(String code, String state) {
        super.onAuthCodeReceived(code, state);
        this.callback.onStatusUpdate(8);
    }

    private List<byte[]> splitArray(byte[] items, int max) {
        byte[] slice;
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        if (items == null || items.length == 0) {
            return result;
        }
        int from = 0;
        int to = 0;
        for (int slicedLength = 0; slicedLength < items.length; slicedLength += slice.length) {
            to = from + Math.min(max, items.length - to);
            slice = Arrays.copyOfRange(items, from, to);
            result.add(slice);
            from = to;
        }
        return result;
    }

    private BluetoothLeCentralCallback getCallback(BluetoothLeCentralCallback callback) {
        if (callback == null) {
            return new BluetoothLeCentralCallback(){

                @Override
                public void onStatusUpdate(int state) {
                }
            };
        }
        return callback;
    }

    private byte[] getSessionRequest() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("provider_url", (Object)this.provider.getUrl());
            jsonObject.putOpt("device_name", (Object)Build.MODEL);
            return jsonObject.toString().getBytes();
        }
        catch (JSONException e) {
            if (MAS.DEBUG) {
                Log.e((String)"MAS", (String)e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    protected boolean startPollingOnStartup() {
        return false;
    }
}

