/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.TimeZone;
import sun.security.util.BitArray;
import sun.security.util.ByteArrayLexOrder;
import sun.security.util.ByteArrayTagOrder;
import sun.security.util.DerEncoder;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

public class DerOutputStream
extends ByteArrayOutputStream
implements DerEncoder {
    private static ByteArrayLexOrder lexOrder = new ByteArrayLexOrder();
    private static ByteArrayTagOrder tagOrder = new ByteArrayTagOrder();

    public DerOutputStream(int size) {
        super(size);
    }

    public DerOutputStream() {
    }

    public void write(byte tag, byte[] buf) throws IOException {
        this.write(tag);
        this.putLength(buf.length);
        this.write(buf, 0, buf.length);
    }

    public void write(byte tag, DerOutputStream out) throws IOException {
        this.write(tag);
        this.putLength(out.count);
        this.write(out.buf, 0, out.count);
    }

    public void writeImplicit(byte tag, DerOutputStream value) throws IOException {
        this.write(tag);
        this.write(value.buf, 1, value.count - 1);
    }

    public void putDerValue(DerValue val) throws IOException {
        val.encode(this);
    }

    public void putBoolean(boolean val) throws IOException {
        this.write(1);
        this.putLength(1);
        if (val) {
            this.write(255);
        } else {
            this.write(0);
        }
    }

    public void putEnumerated(int i) throws IOException {
        this.write(10);
        this.putIntegerContents(i);
    }

    public void putInteger(BigInteger i) throws IOException {
        this.write(2);
        byte[] buf = i.toByteArray();
        this.putLength(buf.length);
        this.write(buf, 0, buf.length);
    }

    public void putInteger(Integer i) throws IOException {
        this.putInteger((int)i);
    }

    public void putInteger(int i) throws IOException {
        this.write(2);
        this.putIntegerContents(i);
    }

    private void putIntegerContents(int i) throws IOException {
        int j;
        byte[] bytes = new byte[4];
        int start = 0;
        bytes[3] = (byte)(i & 0xFF);
        bytes[2] = (byte)((i & 0xFF00) >>> 8);
        bytes[1] = (byte)((i & 0xFF0000) >>> 16);
        bytes[0] = (byte)((i & 0xFF000000) >>> 24);
        if (bytes[0] == 255) {
            for (j = 0; j < 3 && bytes[j] == 255 && (bytes[j + 1] & 0x80) == 128; ++j) {
                ++start;
            }
        } else if (bytes[0] == 0) {
            for (j = 0; j < 3 && bytes[j] == 0 && (bytes[j + 1] & 0x80) == 0; ++j) {
                ++start;
            }
        }
        this.putLength(4 - start);
        for (int k = start; k < 4; ++k) {
            this.write(bytes[k]);
        }
    }

    public void putBitString(byte[] bits) throws IOException {
        this.write(3);
        this.putLength(bits.length + 1);
        this.write(0);
        this.write(bits);
    }

    public void putUnalignedBitString(BitArray ba) throws IOException {
        byte[] bits = ba.toByteArray();
        this.write(3);
        this.putLength(bits.length + 1);
        this.write(bits.length * 8 - ba.length());
        this.write(bits);
    }

    public void putTruncatedUnalignedBitString(BitArray ba) throws IOException {
        this.putUnalignedBitString(ba.truncate());
    }

    public void putOctetString(byte[] octets) throws IOException {
        this.write((byte)4, octets);
    }

    public void putNull() throws IOException {
        this.write(5);
        this.putLength(0);
    }

    public void putOID(ObjectIdentifier oid) throws IOException {
        oid.encode(this);
    }

    public void putSequence(DerValue[] seq) throws IOException {
        DerOutputStream bytes = new DerOutputStream();
        for (int i = 0; i < seq.length; ++i) {
            seq[i].encode(bytes);
        }
        this.write((byte)48, bytes);
    }

    public void putSet(DerValue[] set) throws IOException {
        DerOutputStream bytes = new DerOutputStream();
        for (int i = 0; i < set.length; ++i) {
            set[i].encode(bytes);
        }
        this.write((byte)49, bytes);
    }

    public void putOrderedSetOf(byte tag, DerEncoder[] set) throws IOException {
        this.putOrderedSet(tag, set, lexOrder);
    }

    public void putOrderedSet(byte tag, DerEncoder[] set) throws IOException {
        this.putOrderedSet(tag, set, tagOrder);
    }

    private void putOrderedSet(byte tag, DerEncoder[] set, Comparator<byte[]> order) throws IOException {
        DerOutputStream[] streams = new DerOutputStream[set.length];
        for (int i = 0; i < set.length; ++i) {
            streams[i] = new DerOutputStream();
            set[i].derEncode(streams[i]);
        }
        byte[][] bufs = new byte[streams.length][];
        for (int i = 0; i < streams.length; ++i) {
            bufs[i] = streams[i].toByteArray();
        }
        Arrays.sort(bufs, order);
        DerOutputStream bytes = new DerOutputStream();
        for (int i = 0; i < streams.length; ++i) {
            bytes.write(bufs[i]);
        }
        this.write(tag, bytes);
    }

    public void putUTF8String(String s) throws IOException {
        this.writeString(s, (byte)12, "UTF8");
    }

    public void putPrintableString(String s) throws IOException {
        this.writeString(s, (byte)19, "ASCII");
    }

    public void putT61String(String s) throws IOException {
        this.writeString(s, (byte)20, "ISO-8859-1");
    }

    public void putIA5String(String s) throws IOException {
        this.writeString(s, (byte)22, "ASCII");
    }

    public void putBMPString(String s) throws IOException {
        this.writeString(s, (byte)30, "UnicodeBigUnmarked");
    }

    public void putGeneralString(String s) throws IOException {
        this.writeString(s, (byte)27, "ASCII");
    }

    private void writeString(String s, byte stringTag, String enc) throws IOException {
        byte[] data = s.getBytes(enc);
        this.write(stringTag);
        this.putLength(data.length);
        this.write(data);
    }

    public void putUTCTime(Date d) throws IOException {
        this.putTime(d, (byte)23);
    }

    public void putGeneralizedTime(Date d) throws IOException {
        this.putTime(d, (byte)24);
    }

    private void putTime(Date d, byte tag) throws IOException {
        TimeZone tz = TimeZone.getTimeZone("GMT");
        String pattern = null;
        if (tag == 23) {
            pattern = "yyMMddHHmmss'Z'";
        } else {
            tag = (byte)24;
            pattern = "yyyyMMddHHmmss'Z'";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        sdf.setTimeZone(tz);
        byte[] time = sdf.format(d).getBytes("ISO-8859-1");
        this.write(tag);
        this.putLength(time.length);
        this.write(time);
    }

    public void putLength(int len) throws IOException {
        if (len < 128) {
            this.write((byte)len);
        } else if (len < 256) {
            this.write(-127);
            this.write((byte)len);
        } else if (len < 65536) {
            this.write(-126);
            this.write((byte)(len >> 8));
            this.write((byte)len);
        } else if (len < 0x1000000) {
            this.write(-125);
            this.write((byte)(len >> 16));
            this.write((byte)(len >> 8));
            this.write((byte)len);
        } else {
            this.write(-124);
            this.write((byte)(len >> 24));
            this.write((byte)(len >> 16));
            this.write((byte)(len >> 8));
            this.write((byte)len);
        }
    }

    public void putTag(byte tagClass, boolean form, byte val) {
        byte tag = (byte)(tagClass | val);
        if (form) {
            tag = (byte)(tag | 0x20);
        }
        this.write(tag);
    }

    @Override
    public void derEncode(OutputStream out) throws IOException {
        out.write(this.toByteArray());
    }
}

