/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.identity.util;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import androidx.annotation.NonNull;
import com.ca.mas.core.conf.ConfigurationManager;
import com.ca.mas.foundation.MAS;
import com.ca.mas.identity.user.MASPhoto;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class IdentityUtil {
    public static final Map<String, JSONObject> SCHEMA_MAP = new HashMap<String, JSONObject>();

    public static Bitmap getThumbnail(List<MASPhoto> photoList) {
        return IdentityUtil.getPhoto(photoList);
    }

    public static List<String> normalizeAttributes(@NonNull List<String> providedAttributes, @NonNull List<String> allowedAttributes) {
        ArrayList<String> replacements = new ArrayList<String>();
        for (String attribute : providedAttributes) {
            if (allowedAttributes.contains(attribute)) {
                replacements.add(attribute);
                continue;
            }
            for (String s : allowedAttributes) {
                if (!s.startsWith(attribute + '.')) continue;
                replacements.add(s);
            }
        }
        return replacements;
    }

    public static String getSchemasPath() {
        return IdentityUtil.getPath("Schemas");
    }

    public static String getUserPath() {
        return IdentityUtil.getPath("Users");
    }

    public static String getGroupPath() {
        return IdentityUtil.getPath("Groups");
    }

    private static String getPath(String entity) {
        StringBuilder sb = new StringBuilder();
        String scimPath = (String)ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getProperty("mas.url.scim_path");
        if (scimPath == null) {
            scimPath = "/SCIM/MAS/v2";
        }
        sb.append(scimPath);
        if (!TextUtils.isEmpty((CharSequence)entity)) {
            sb.append("/");
            sb.append(entity);
        }
        if (MAS.DEBUG) {
            Log.d((String)"MAS", (String)("SCIM URL Path: " + sb.toString()));
        }
        return sb.toString();
    }

    public static Bitmap getPhoto(List<MASPhoto> photoList) {
        if (photoList != null) {
            for (MASPhoto photo : photoList) {
                if (photo == null || !photo.getType().equals("thumbnail")) continue;
                String value = photo.getValue();
                int offset = value.indexOf("base64,") + "base64,".length();
                byte[] subVal = Base64.decode((String)value.substring(offset), (int)0);
                return BitmapFactory.decodeByteArray((byte[])subVal, (int)0, (int)subVal.length);
            }
        }
        return null;
    }
}

