/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.identity.user;

import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Keep;
import com.ca.mas.core.conf.ConfigurationManager;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASCallback;
import com.ca.mas.foundation.MASRequest;
import com.ca.mas.foundation.MASResponse;
import com.ca.mas.foundation.MASResponseBody;
import com.ca.mas.foundation.MASUser;
import com.ca.mas.foundation.notify.Callback;
import com.ca.mas.identity.common.MASFilteredRequest;
import com.ca.mas.identity.user.MASUserRepository;
import com.ca.mas.identity.user.User;
import com.ca.mas.identity.user.UserAttributes;
import com.ca.mas.identity.util.IdentityUtil;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Keep
public class MASUserRepositoryImpl
implements MASUserRepository {
    @Override
    public void getUsersByFilter(MASFilteredRequest filteredRequest, final MASCallback<List<MASUser>> callback) {
        Uri uri = filteredRequest.createUri(MAS.getContext());
        MASRequest masRequest = new MASRequest.MASRequestBuilder(uri).header("Accept", "application/scim+json").header("Content-Type", "application/scim+json").responseBody(MASResponseBody.jsonBody()).get().build();
        MAS.invoke(masRequest, new MASCallback<MASResponse<JSONObject>>(){

            @Override
            public void onSuccess(MASResponse<JSONObject> result) {
                try {
                    Callback.onSuccess(callback, MASUserRepositoryImpl.this.parse(result.getBody().getContent()));
                }
                catch (JSONException e) {
                    Callback.onError(callback, e);
                }
            }

            @Override
            public void onError(Throwable e) {
                Callback.onError(callback, e);
            }
        });
    }

    @Override
    public void getUserById(String id, final MASCallback<MASUser> callback) {
        Uri.Builder builder = new Uri.Builder();
        String path = IdentityUtil.getUserPath();
        builder.appendEncodedPath(path.startsWith("/") ? path.substring(1) : path);
        builder.appendPath(id);
        MASRequest masRequest = new MASRequest.MASRequestBuilder(builder.build()).header("Accept", "application/scim+json").header("Content-Type", "application/scim+json").responseBody(MASResponseBody.jsonBody()).get().build();
        MAS.invoke(masRequest, new MASCallback<MASResponse<JSONObject>>(){

            @Override
            public void onSuccess(MASResponse<JSONObject> result) {
                try {
                    Callback.onSuccess(callback, MASUserRepositoryImpl.this.processUserById(result.getBody().getContent()));
                }
                catch (JSONException e) {
                    Callback.onError(callback, e);
                }
            }

            @Override
            public void onError(Throwable e) {
                Callback.onError(callback, e);
            }
        });
    }

    @Override
    public void me(final MASCallback<MASUser> callback) {
        MASRequest request = new MASRequest.MASRequestBuilder(ConfigurationManager.getInstance().getConnectedGatewayConfigurationProvider().getUserInfoUri()).password().build();
        MAS.invoke(request, new MASCallback<MASResponse<JSONObject>>(){

            @Override
            public void onSuccess(MASResponse<JSONObject> response) {
                try {
                    String u = response.getBody().getContent().getString("preferred_username");
                    MASUserRepositoryImpl.this.getUserById(u, new MASCallback<MASUser>(){

                        @Override
                        public void onSuccess(MASUser user) {
                            Callback.onSuccess(callback, user);
                        }

                        @Override
                        public void onError(Throwable e) {
                            Callback.onError(callback, e);
                        }
                    });
                }
                catch (JSONException e) {
                    Callback.onError(callback, e);
                }
            }

            @Override
            public void onError(Throwable e) {
                Callback.onError(callback, e);
            }
        });
    }

    @Override
    public void getUserMetaData(final MASCallback<UserAttributes> callback) {
        String schemaPath = IdentityUtil.getSchemasPath() + "/";
        MASRequest masRequest = new MASRequest.MASRequestBuilder(Uri.parse((String)(schemaPath + "urn:ietf:params:scim:schemas:core:2.0:User"))).responseBody(MASResponseBody.jsonBody()).get().build();
        MAS.invoke(masRequest, new MASCallback<MASResponse<JSONObject>>(){

            @Override
            public void onSuccess(MASResponse<JSONObject> result) {
                try {
                    JSONObject jsonObject = result.getBody().getContent();
                    UserAttributes userAttributes = MASUserRepositoryImpl.this.getAttributes(jsonObject);
                    Callback.onSuccess(callback, userAttributes);
                }
                catch (JSONException e) {
                    Callback.onError(callback, e);
                }
            }

            @Override
            public void onError(Throwable e) {
                Callback.onError(callback, e);
            }
        });
    }

    private MASUser processUserById(JSONObject jsonObject) throws JSONException {
        User user = new User();
        if (jsonObject.has("Resources")) {
            JSONArray jsonArray = jsonObject.getJSONArray("Resources");
            int totalResults = jsonObject.optInt("totalResults");
            if (totalResults != 1) {
                throw new IllegalStateException("Should not return more than 1 user");
            }
            JSONObject arrElem = jsonArray.getJSONObject(0);
            user.populate(arrElem);
        } else {
            user.populate(jsonObject);
        }
        return user;
    }

    private UserAttributes getAttributes(JSONObject jsonObject) throws JSONException {
        String id = jsonObject.optString("id");
        if (TextUtils.isEmpty((CharSequence)id)) {
            throw new IllegalArgumentException("The ID cannot be null!");
        }
        if (id.equals("urn:ietf:params:scim:schemas:core:2.0:User")) {
            UserAttributes userAttributes = new UserAttributes();
            userAttributes.populate(jsonObject);
            return userAttributes;
        }
        return null;
    }

    private List<MASUser> parse(JSONObject jsonObject) throws JSONException {
        JSONArray jsonArray;
        ArrayList<MASUser> result = new ArrayList<MASUser>();
        if (jsonObject.has("Resources") && (jsonArray = jsonObject.getJSONArray("Resources")).length() > 0) {
            for (int i = 0; i < jsonArray.length(); ++i) {
                User ident = new User();
                JSONObject arrElem = jsonArray.getJSONObject(i);
                ident.populate(arrElem);
                result.add(ident);
            }
        }
        return result;
    }
}

