/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.identity.group;

import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Keep;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASCallback;
import com.ca.mas.foundation.MASGroup;
import com.ca.mas.foundation.MASRequest;
import com.ca.mas.foundation.MASRequestBody;
import com.ca.mas.foundation.MASResponse;
import com.ca.mas.foundation.MASResponseBody;
import com.ca.mas.foundation.notify.Callback;
import com.ca.mas.identity.common.MASFilteredRequest;
import com.ca.mas.identity.group.GroupAttributes;
import com.ca.mas.identity.group.MASGroupRepository;
import com.ca.mas.identity.util.IdentityUtil;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Keep
public class MASGroupRepositoryImpl
implements MASGroupRepository {
    @Override
    public void getGroupById(String id, final MASCallback<MASGroup> callback) {
        MASRequest masRequest = new MASRequest.MASRequestBuilder(Uri.parse((String)(IdentityUtil.getGroupPath() + "/" + id))).header("Accept", "application/scim+json").header("Content-Type", "application/scim+json").responseBody(MASResponseBody.jsonBody()).get().build();
        MAS.invoke(masRequest, new MASCallback<MASResponse<JSONObject>>(){

            @Override
            public void onSuccess(MASResponse<JSONObject> result) {
                try {
                    Callback.onSuccess(callback, MASGroupRepositoryImpl.this.processGroupById(result.getBody().getContent()));
                }
                catch (JSONException je) {
                    Callback.onError(callback, je);
                }
            }

            @Override
            public void onError(Throwable e) {
                Callback.onError(callback, e);
            }
        });
    }

    @Override
    public void getGroupsByFilter(MASFilteredRequest filteredRequest, final MASCallback<List<MASGroup>> callback) {
        Uri uri = filteredRequest.createUri(MAS.getContext());
        MASRequest masRequest = new MASRequest.MASRequestBuilder(uri).header("Accept", "application/scim+json").header("Content-Type", "application/scim+json").responseBody(MASResponseBody.jsonBody()).get().build();
        MAS.invoke(masRequest, new MASCallback<MASResponse<JSONObject>>(){

            @Override
            public void onSuccess(MASResponse<JSONObject> result) {
                try {
                    Callback.onSuccess(callback, MASGroupRepositoryImpl.this.parse(result.getBody().getContent()));
                }
                catch (JSONException je) {
                    Callback.onError(callback, je);
                }
            }

            @Override
            public void onError(Throwable e) {
                Callback.onError(callback, e);
            }
        });
    }

    private void createAdHocGroup(MASGroup group, final MASCallback<MASGroup> callback) {
        try {
            MASRequest masRequest = new MASRequest.MASRequestBuilder(Uri.parse((String)IdentityUtil.getGroupPath())).header("Accept", "application/scim+json").header("Content-Type", "application/scim+json").responseBody(MASResponseBody.jsonBody()).post(MASRequestBody.jsonBody(group.getAsJSONObject())).build();
            MAS.invoke(masRequest, new MASCallback<MASResponse<JSONObject>>(){

                @Override
                public void onSuccess(MASResponse<JSONObject> result) {
                    MASGroup group = MASGroup.newInstance();
                    try {
                        group.populate(result.getBody().getContent());
                        Callback.onSuccess(callback, group);
                    }
                    catch (JSONException je) {
                        Callback.onError(callback, je);
                    }
                }

                @Override
                public void onError(Throwable e) {
                    Callback.onError(callback, e);
                }
            });
        }
        catch (JSONException e) {
            Callback.onError(callback, e);
        }
    }

    private void updateAdHocGroup(MASGroup group, MASCallback<MASGroup> callback) {
        this.groupUpdate(group, callback);
    }

    @Override
    public void delete(MASGroup group, final MASCallback<Void> callback) {
        String url = IdentityUtil.getGroupPath() + "/" + group.getId();
        MASRequest masRequest = new MASRequest.MASRequestBuilder(Uri.parse((String)url)).header("Accept", "application/scim+json").header("Content-Type", "application/scim+json").responseBody(MASResponseBody.jsonBody()).delete(null).build();
        MAS.invoke(masRequest, new MASCallback<MASResponse<JSONObject>>(){

            @Override
            public void onSuccess(MASResponse<JSONObject> result) {
                Callback.onSuccess(callback, null);
            }

            @Override
            public void onError(Throwable e) {
                Callback.onError(callback, e);
            }
        });
    }

    @Override
    public void getGroupMetaData(final MASCallback<GroupAttributes> callback) {
        String schemaPath = IdentityUtil.getSchemasPath() + "/";
        MASRequest masRequest = new MASRequest.MASRequestBuilder(Uri.parse((String)(schemaPath + "urn:ietf:params:scim:schemas:core:2.0:Group"))).responseBody(MASResponseBody.jsonBody()).get().build();
        MAS.invoke(masRequest, new MASCallback<MASResponse<JSONObject>>(){

            @Override
            public void onSuccess(MASResponse<JSONObject> result) {
                try {
                    Callback.onSuccess(callback, MASGroupRepositoryImpl.this.doPopulateAttributes(result.getBody().getContent()));
                }
                catch (JSONException e) {
                    Callback.onError(callback, e);
                }
            }

            @Override
            public void onError(Throwable e) {
                Callback.onError(callback, e);
            }
        });
    }

    @Override
    public void save(MASGroup group, MASCallback<MASGroup> callback) {
        if (group.getId() == null) {
            this.createAdHocGroup(group, callback);
        } else {
            this.updateAdHocGroup(group, callback);
        }
    }

    private GroupAttributes doPopulateAttributes(JSONObject jsonObject) throws JSONException {
        String id = jsonObject.optString("id");
        if (TextUtils.isEmpty((CharSequence)id)) {
            throw new IllegalArgumentException("The ID cannot be null!");
        }
        if (id.equals("urn:ietf:params:scim:schemas:core:2.0:Group")) {
            GroupAttributes groupAttributes = new GroupAttributes();
            groupAttributes.populate(jsonObject);
            return groupAttributes;
        }
        return null;
    }

    private void groupUpdate(MASGroup group, final MASCallback<MASGroup> callback) {
        try {
            String updateUrl = IdentityUtil.getGroupPath() + "/" + group.getId();
            MASRequest masRequest = new MASRequest.MASRequestBuilder(Uri.parse((String)updateUrl)).header("Accept", "application/scim+json").header("Content-Type", "application/scim+json").responseBody(MASResponseBody.jsonBody()).put(MASRequestBody.jsonBody(group.getAsJSONObject())).build();
            MAS.invoke(masRequest, new MASCallback<MASResponse<JSONObject>>(){

                @Override
                public void onSuccess(MASResponse<JSONObject> result) {
                    try {
                        MASGroup updated = MASGroup.newInstance();
                        updated.populate(result.getBody().getContent());
                        Callback.onSuccess(callback, updated);
                    }
                    catch (JSONException e) {
                        Callback.onError(callback, e);
                    }
                }

                @Override
                public void onError(Throwable e) {
                    Callback.onError(callback, e);
                }
            });
        }
        catch (JSONException e) {
            Callback.onError(callback, e);
        }
    }

    private MASGroup processGroupById(JSONObject jsonObject) throws JSONException {
        if (MAS.DEBUG) {
            Log.d((String)"MAS", (String)String.format("Group raw JSON data: %s", jsonObject.toString(4)));
        }
        MASGroup group = MASGroup.newInstance();
        if (jsonObject.has("Resources")) {
            JSONArray jsonArray = jsonObject.getJSONArray("Resources");
            int totalResults = jsonObject.optInt("totalResults");
            if (totalResults != 1) {
                throw new IllegalStateException("Should not return more than 1 group");
            }
            JSONObject arrElem = jsonArray.getJSONObject(0);
            group.populate(arrElem);
        } else {
            group.populate(jsonObject);
        }
        return group;
    }

    private List<MASGroup> parse(JSONObject jsonObject) throws JSONException {
        JSONArray jsonArray;
        ArrayList<MASGroup> result = new ArrayList<MASGroup>();
        if (jsonObject.has("Resources") && (jsonArray = jsonObject.getJSONArray("Resources")).length() > 0) {
            for (int i = 0; i < jsonArray.length(); ++i) {
                MASGroup ident = MASGroup.newInstance();
                JSONObject arrElem = jsonArray.getJSONObject(i);
                ident.populate(arrElem);
                result.add(ident);
            }
        }
        return result;
    }
}

