/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation;

import android.app.KeyguardManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Handler;
import android.os.Parcel;
import android.security.keystore.UserNotAuthenticatedException;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.ca.mas.core.EventDispatcher;
import com.ca.mas.core.MAGResultReceiver;
import com.ca.mas.core.MobileSso;
import com.ca.mas.core.MobileSsoFactory;
import com.ca.mas.core.datasource.DataSourceException;
import com.ca.mas.core.error.MAGError;
import com.ca.mas.core.oauth.OAuthClientUtil;
import com.ca.mas.core.security.LockableEncryptionProvider;
import com.ca.mas.core.security.SecureLockException;
import com.ca.mas.core.store.StorageProvider;
import com.ca.mas.core.store.TokenManager;
import com.ca.mas.core.store.TokenStoreException;
import com.ca.mas.core.token.IdToken;
import com.ca.mas.core.token.JWTValidation;
import com.ca.mas.core.util.Functions;
import com.ca.mas.foundation.Extension;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASAuthCredentials;
import com.ca.mas.foundation.MASAuthCredentialsAuthorizationCode;
import com.ca.mas.foundation.MASAuthCredentialsJWT;
import com.ca.mas.foundation.MASAuthCredentialsPassword;
import com.ca.mas.foundation.MASAuthorizationRequest;
import com.ca.mas.foundation.MASAuthorizationRequestHandler;
import com.ca.mas.foundation.MASAuthorizationResponse;
import com.ca.mas.foundation.MASCallback;
import com.ca.mas.foundation.MASExtension;
import com.ca.mas.foundation.MASIdToken;
import com.ca.mas.foundation.MASRequest;
import com.ca.mas.foundation.MASResponse;
import com.ca.mas.foundation.MASSessionUnlockCallback;
import com.ca.mas.foundation.UserInfoRepository;
import com.ca.mas.foundation.UserRepository;
import com.ca.mas.foundation.notify.Callback;
import com.ca.mas.identity.common.MASFilteredRequest;
import com.ca.mas.identity.user.MASUserIdentity;
import com.ca.mas.identity.user.MASUserRepository;
import com.ca.mas.identity.user.ScimUser;
import com.ca.mas.identity.user.User;
import com.ca.mas.identity.user.UserAttributes;
import com.ca.mas.identity.util.IdentityUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class MASUser
implements MASUserIdentity,
ScimUser {
    private static final String SESSION_LOCK_ALIAS = "com.ca.mas.SESSION_LOCK";
    private static MASUser current;

    public static void login(MASAuthorizationRequest request, MASAuthorizationRequestHandler handler) {
        handler.authorize(request);
    }

    public static void login(@NonNull String userName, @NonNull char[] cPassword, MASCallback<MASUser> callback) {
        MASUser.login(new MASAuthCredentialsPassword(userName, cPassword), callback);
    }

    public static void login(MASIdToken idToken, MASCallback<MASUser> callback) {
        MASUser.login(new MASAuthCredentialsJWT(idToken), callback);
    }

    public static void login(MASAuthCredentials credentials, final MASCallback<MASUser> callback) {
        if (StorageProvider.getInstance().getTokenManager().getSecureIdToken() != null) {
            Callback.onError(callback, new SecureLockException("The session is currently locked."));
        } else {
            MobileSso mobileSso = MobileSsoFactory.getInstance();
            mobileSso.authenticate(credentials, new MAGResultReceiver<JSONObject>(){

                @Override
                public void onSuccess(MASResponse<JSONObject> response) {
                    MASUser.login(callback);
                }

                @Override
                public void onError(MAGError error) {
                    current = null;
                    Callback.onError(callback, error);
                }
            });
        }
    }

    public static void login(final MASCallback<MASUser> callback) {
        final MASUser user = MASUser.createMASUser();
        user.requestUserInfo(new MASCallback<Void>(){

            @Override
            public void onSuccess(Void result) {
                current = user;
                Callback.onSuccess(callback, current);
                MAS.processPendingRequests();
            }

            @Override
            public void onError(Throwable e) {
                Callback.onError(callback, e);
                MAS.processPendingRequests();
            }
        });
    }

    public static void login(@NonNull MASAuthorizationResponse authorizationResponse, MASCallback<MASUser> callback) {
        MASUser.login(new MASAuthCredentialsAuthorizationCode(authorizationResponse.getAuthorizationCode(), authorizationResponse.getState()), callback);
    }

    public static MASUser getCurrentUser() {
        TokenManager tokenManager;
        if (current == null && (tokenManager = StorageProvider.getInstance().getTokenManager()).getUserProfile() != null) {
            current = MASUser.createMASUser();
        }
        if (current != null && !current.isAuthenticated() && !current.isSessionLocked()) {
            current = null;
        }
        return current;
    }

    public abstract String getAccessToken();

    private static MASUser createMASUser() {
        User user;
        block3: {
            user = new User(){
                @MASExtension
                private MASUserRepository userRepository;

                @Override
                public boolean isAuthenticated() {
                    return MobileSsoFactory.getInstance().isLogin();
                }

                @Override
                public boolean isCurrentUser() {
                    return true;
                }

                private void execute(final Functions.NullaryVoid function, final MASCallback<Void> callback) {
                    if (this.getUserName() == null) {
                        4.login(new MASCallback<MASUser>(){

                            @Override
                            public Handler getHandler() {
                                return Callback.getHandler(callback);
                            }

                            @Override
                            public void onSuccess(MASUser object) {
                                function.call();
                            }

                            @Override
                            public void onError(Throwable e) {
                                Callback.onError(callback, e);
                            }
                        });
                    } else {
                        function.call();
                    }
                }

                @Override
                @Deprecated
                public void logout(MASCallback<Void> callback) {
                    current = null;
                    this.logout(true, callback);
                }

                @Override
                public void logout(final boolean force, final MASCallback<Void> callback) {
                    if (this.isSessionLocked()) {
                        Callback.onError(callback, new SecureLockException("The session is currently locked."));
                    } else {
                        current = null;
                        MASRequest request = null;
                        final TokenManager tokenManager = StorageProvider.getInstance().getTokenManager();
                        request = tokenManager.getIdToken() != null ? OAuthClientUtil.getLogoutRequest() : OAuthClientUtil.getRevokeRequest();
                        if (request != null) {
                            MAS.invoke(request, new MASCallback<MASResponse<JSONObject>>(){

                                @Override
                                public void onSuccess(MASResponse<JSONObject> result) {
                                    EventDispatcher.LOGOUT.notifyObservers();
                                    try {
                                        tokenManager.deleteIdToken();
                                        tokenManager.deleteSecureIdToken();
                                        tokenManager.deleteUserProfile();
                                    }
                                    catch (TokenStoreException e) {
                                        this.onError(e);
                                    }
                                    try {
                                        StorageProvider.getInstance().getOAuthTokenContainer().clear();
                                    }
                                    catch (DataSourceException e) {
                                        this.onError(e);
                                    }
                                    Callback.onSuccess(callback, null);
                                }

                                @Override
                                public void onError(Throwable e) {
                                    boolean lockSession;
                                    boolean bl = lockSession = MASUser.getCurrentUser() != null ? MASUser.getCurrentUser().isSessionLocked() : false;
                                    if (force && !lockSession) {
                                        EventDispatcher.LOGOUT.notifyObservers();
                                        try {
                                            tokenManager.deleteIdToken();
                                            tokenManager.deleteSecureIdToken();
                                            tokenManager.deleteUserProfile();
                                        }
                                        catch (TokenStoreException e1) {
                                            Callback.onError(callback, e);
                                            return;
                                        }
                                        try {
                                            StorageProvider.getInstance().getOAuthTokenContainer().clear();
                                        }
                                        catch (DataSourceException e1) {
                                            Callback.onError(callback, e);
                                        }
                                    }
                                    Callback.onError(callback, e);
                                }
                            });
                        }
                    }
                }

                @Override
                public void getUserById(String id, MASCallback<MASUser> callback) {
                    this.userRepository.getUserById(id, callback);
                }

                @Override
                public void getUsersByFilter(MASFilteredRequest filteredRequest, MASCallback<List<MASUser>> callback) {
                    this.userRepository.getUsersByFilter(filteredRequest, callback);
                }

                @Override
                public void getUserMetaData(MASCallback<UserAttributes> callback) {
                    this.userRepository.getUserMetaData(callback);
                }

                @Override
                public String getAccessToken() {
                    long expiry = StorageProvider.getInstance().getOAuthTokenContainer().getExpiry();
                    if (expiry <= 0L || System.currentTimeMillis() <= expiry) {
                        return StorageProvider.getInstance().getOAuthTokenContainer().getAccessToken();
                    }
                    return null;
                }

                @Override
                public Bitmap getThumbnailImage() {
                    return IdentityUtil.getThumbnail(this.getPhotoList());
                }

                @Override
                public void requestUserInfo(MASCallback<Void> callback) {
                    LinkedList<UserRepository> repositories = new LinkedList<UserRepository>();
                    if (this.userRepository != null) {
                        repositories.add(new UserRepository(){

                            @Override
                            public void getCurrentUser(MASCallback<MASUser> result) {
                                if (this.getUserName() == null) {
                                    userRepository.me(result);
                                } else {
                                    userRepository.getUserById(this.getUserName(), result);
                                }
                            }
                        });
                    }
                    repositories.add(new UserInfoRepository());
                    this.fetch(repositories, callback, null);
                }

                private void fetch(final LinkedList<UserRepository> repositories, final MASCallback<Void> callback, Throwable e) {
                    UserRepository f;
                    try {
                        f = repositories.pop();
                    }
                    catch (NoSuchElementException nse) {
                        Callback.onError(callback, e);
                        return;
                    }
                    try {
                        f.getCurrentUser(new MASCallback<MASUser>(){

                            @Override
                            public void onSuccess(MASUser result) {
                                block2: {
                                    try {
                                        JSONObject source = result.getSource();
                                        source.remove("password");
                                        this.populate(source);
                                        StorageProvider.getInstance().getTokenManager().saveUserProfile(source.toString());
                                    }
                                    catch (Exception e) {
                                        if (!MAS.DEBUG) break block2;
                                        Log.w((String)"MAS", (String)"Unable to persist user profile to local storage.", (Throwable)e);
                                    }
                                }
                                Callback.onSuccess(callback, null);
                            }

                            @Override
                            public void onError(Throwable e) {
                                this.fetch(repositories, callback, e);
                            }
                        });
                    }
                    catch (Exception e1) {
                        this.fetch(repositories, callback, e1);
                    }
                }

                @Override
                public void lockSession(MASCallback<Void> callback) {
                    if (Build.VERSION.SDK_INT >= 23) {
                        MASUser currentUser = MASUser.getCurrentUser();
                        if (currentUser == null) {
                            Callback.onError(callback, new SecureLockException("No currently authenticated user."));
                        } else if (this.isSessionLocked()) {
                            Callback.onSuccess(callback, null);
                        } else if (!this.isDeviceSecure()) {
                            Callback.onError(callback, new SecureLockException("Screen lock is not active"));
                        } else {
                            IdToken idToken = StorageProvider.getInstance().getTokenManager().getIdToken();
                            if (idToken == null) {
                                Callback.onError(callback, new SecureLockException("Failed to retrieve ID token."));
                                return;
                            }
                            MASRequest revokeRequest = OAuthClientUtil.getRevokeRequest();
                            StorageProvider.getInstance().getOAuthTokenContainer().clear();
                            MAS.invoke(revokeRequest, null);
                            try {
                                Parcel idTokenParcel = Parcel.obtain();
                                idToken.writeToParcel(idTokenParcel, 0);
                                byte[] idTokenBytes = idTokenParcel.marshall();
                                LockableEncryptionProvider lockableEncryptionProvider = new LockableEncryptionProvider(MAS.getContext(), MASUser.SESSION_LOCK_ALIAS);
                                lockableEncryptionProvider.clear();
                                byte[] encryptedData = lockableEncryptionProvider.encrypt(idTokenBytes);
                                try {
                                    StorageProvider.getInstance().getTokenManager().saveSecureIdToken(encryptedData);
                                }
                                catch (TokenStoreException e) {
                                    Callback.onError(callback, new SecureLockException("Failed to save encrypted ID token.", e));
                                    return;
                                }
                                try {
                                    StorageProvider.getInstance().getTokenManager().deleteIdToken();
                                }
                                catch (TokenStoreException e) {
                                    Callback.onError(callback, new SecureLockException("Failed to delete encrypted ID token.", e));
                                    return;
                                }
                                idTokenParcel.recycle();
                                Callback.onSuccess(callback, null);
                            }
                            catch (Exception e) {
                                Callback.onError(callback, new SecureLockException("Failed to save encrypted ID token.", e));
                            }
                        }
                    } else {
                        Callback.onError(callback, new IllegalAccessException("Device API level does not meet the target API requirements."));
                    }
                }

                private boolean isDeviceSecure() {
                    if (Build.VERSION.SDK_INT < 23) {
                        throw new SecureLockException("Screen lock is not active");
                    }
                    Context context = MAS.getContext();
                    MAS.getContext();
                    KeyguardManager manager = (KeyguardManager)context.getSystemService("keyguard");
                    boolean retValue = manager.isDeviceSecure();
                    return retValue;
                }

                @Override
                @RequiresApi(value=23)
                public void unlockSession(MASSessionUnlockCallback<Void> callback) {
                    block13: {
                        if (Build.VERSION.SDK_INT >= 23) {
                            if (this.isSessionLocked()) {
                                byte[] secureIdToken = StorageProvider.getInstance().getTokenManager().getSecureIdToken();
                                LockableEncryptionProvider lockableEncryptionProvider = new LockableEncryptionProvider(MAS.getContext(), MASUser.SESSION_LOCK_ALIAS);
                                Parcel parcel = Parcel.obtain();
                                try {
                                    byte[] decryptedData = lockableEncryptionProvider.decrypt(secureIdToken);
                                    parcel.unmarshall(decryptedData, 0, decryptedData.length);
                                    parcel.setDataPosition(0);
                                    IdToken idToken = (IdToken)IdToken.CREATOR.createFromParcel(parcel);
                                    try {
                                        StorageProvider.getInstance().getTokenManager().saveIdToken(idToken);
                                    }
                                    catch (TokenStoreException e) {
                                        Callback.onError(callback, new SecureLockException("Failed to save ID token.", e));
                                        return;
                                    }
                                    try {
                                        StorageProvider.getInstance().getTokenManager().deleteSecureIdToken();
                                    }
                                    catch (TokenStoreException e) {
                                        Callback.onError(callback, new SecureLockException("Failed to delete encrypted ID token.", e));
                                        return;
                                    }
                                    lockableEncryptionProvider.clear();
                                    boolean isTokenExpired = JWTValidation.isIdTokenExpired(idToken);
                                    if (!isTokenExpired) {
                                        Callback.onSuccess(callback, null);
                                        break block13;
                                    }
                                    this.logout(true, null);
                                    Callback.onError(callback, new SecureLockException("ID token is expired."));
                                }
                                catch (Exception e) {
                                    Throwable t = e.getCause();
                                    if (t != null && (t instanceof UserNotAuthenticatedException || t.getCause() instanceof UserNotAuthenticatedException)) {
                                        if (callback != null) {
                                            callback.onUserAuthenticationRequired();
                                        }
                                        break block13;
                                    }
                                    Callback.onError(callback, e);
                                }
                            } else {
                                Callback.onSuccess(callback, null);
                            }
                        } else {
                            Callback.onError(callback, new IllegalAccessException("Device API level does not meet the target API requirements."));
                        }
                    }
                }

                @Override
                public boolean isSessionLocked() {
                    return StorageProvider.getInstance().getTokenManager().getSecureIdToken() != null;
                }

                @Override
                public void removeSessionLock(MASCallback<Void> callback) {
                    if (!this.isSessionLocked()) {
                        Callback.onSuccess(callback, null);
                    } else {
                        try {
                            StorageProvider.getInstance().getTokenManager().deleteSecureIdToken();
                            Callback.onSuccess(callback, null);
                        }
                        catch (TokenStoreException e) {
                            Callback.onError(callback, new SecureLockException("Failed to delete encrypted ID token.", e));
                        }
                    }
                }
            };
            try {
                JSONObject localUserProfile = MASUser.getLocalUserProfile();
                if (localUserProfile != null) {
                    user.populate(localUserProfile);
                }
            }
            catch (JSONException e) {
                if (!MAS.DEBUG) break block3;
                Log.w((String)"MAS", (String)"Failed to populate MASUser from local storage.", (Throwable)e);
            }
        }
        Extension.inject(user);
        return user;
    }

    private static JSONObject getLocalUserProfile() throws JSONException {
        JSONObject user = null;
        String userProfile = StorageProvider.getInstance().getTokenManager().getUserProfile();
        if (userProfile != null) {
            user = new JSONObject(userProfile);
        }
        return user;
    }

    public abstract Bitmap getThumbnailImage();

    @Deprecated
    public abstract void logout(MASCallback<Void> var1);

    public abstract void logout(boolean var1, MASCallback<Void> var2);

    public abstract boolean isAuthenticated();

    public abstract boolean isCurrentUser();

    public abstract void requestUserInfo(MASCallback<Void> var1);

    @RequiresApi(value=23)
    public abstract void lockSession(MASCallback<Void> var1);

    @RequiresApi(value=23)
    public abstract void unlockSession(MASSessionUnlockCallback<Void> var1);

    public abstract boolean isSessionLocked();

    @RequiresApi(value=23)
    public abstract void removeSessionLock(MASCallback<Void> var1);

    @Override
    public abstract void getUserById(String var1, MASCallback<MASUser> var2);

    @Override
    public abstract void getUsersByFilter(MASFilteredRequest var1, MASCallback<List<MASUser>> var2);

    @Override
    public abstract void getUserMetaData(MASCallback<UserAttributes> var1);

    static {
        EventDispatcher.STOP.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                current = null;
            }
        });
    }
}

