/*
 * Decompiled with CFR 0.152.
 */
package com.ca.mas.foundation;

import android.net.Uri;
import android.util.Base64;
import android.util.Log;
import android.util.Pair;
import com.ca.mas.core.error.MAGError;
import com.ca.mas.core.http.ContentType;
import com.ca.mas.core.io.Charsets;
import com.ca.mas.core.util.FileUtils;
import com.ca.mas.foundation.MAS;
import com.ca.mas.foundation.MASClaims;
import com.ca.mas.foundation.MASClaimsBuilder;
import com.ca.mas.foundation.MASConstants;
import com.ca.mas.foundation.MASException;
import com.ca.mas.foundation.MASFileObject;
import com.ca.mas.foundation.MASProgressListener;
import com.ca.mas.foundation.MultiPart;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.PrivateKey;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class MASRequestBody {
    public abstract ContentType getContentType();

    public abstract long getContentLength();

    public abstract void write(OutputStream var1) throws IOException;

    public Object getContentAsJsonValue() {
        return null;
    }

    public static MASRequestBody byteArrayBody(final byte[] body) {
        return new MASRequestBody(){
            private final byte[] content;
            {
                this.content = body;
            }

            @Override
            public ContentType getContentType() {
                return null;
            }

            @Override
            public long getContentLength() {
                return this.content.length;
            }

            @Override
            public void write(OutputStream outputStream) throws IOException {
                outputStream.write(this.content);
            }

            @Override
            public Object getContentAsJsonValue() {
                return Base64.encodeToString((byte[])body, (int)11);
            }
        };
    }

    public static MASRequestBody stringBody(final String body) {
        return new MASRequestBody(){
            private final byte[] content;
            {
                this.content = body.getBytes(this.getContentType().getCharset());
            }

            @Override
            public ContentType getContentType() {
                return ContentType.TEXT_PLAIN;
            }

            @Override
            public long getContentLength() {
                return this.content.length;
            }

            @Override
            public void write(OutputStream outputStream) throws IOException {
                if (MAS.DEBUG) {
                    Log.d((String)"MAS", (String)String.format("Content: %s", body));
                }
                outputStream.write(this.content);
            }

            @Override
            public Object getContentAsJsonValue() {
                return body;
            }
        };
    }

    public static MASRequestBody jsonBody(final JSONObject jsonObject) {
        return new MASRequestBody(){
            private final byte[] content;
            {
                this.content = jsonObject.toString().getBytes(this.getContentType().getCharset());
            }

            @Override
            public ContentType getContentType() {
                return ContentType.APPLICATION_JSON;
            }

            @Override
            public long getContentLength() {
                return this.content.length;
            }

            @Override
            public void write(OutputStream outputStream) throws IOException {
                if (MAS.DEBUG) {
                    try {
                        Log.d((String)"MAS", (String)String.format("Content: %s", jsonObject.toString(4)));
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
                outputStream.write(this.content);
            }

            @Override
            public Object getContentAsJsonValue() {
                return jsonObject;
            }
        };
    }

    public static MASRequestBody jsonArrayBody(final JSONArray jsonArray) {
        MASRequestBody result = new MASRequestBody(){
            private byte[] content;
            {
                this.content = jsonArray.toString().getBytes(this.getContentType().getCharset());
            }

            @Override
            public ContentType getContentType() {
                return ContentType.APPLICATION_JSON;
            }

            @Override
            public long getContentLength() {
                return this.content.length;
            }

            @Override
            public void write(OutputStream outputStream) throws IOException {
                outputStream.write(this.content);
            }
        };
        return result;
    }

    public static MASRequestBody urlEncodedFormBody(final List<? extends Pair<String, String>> form) {
        return new MASRequestBody(){
            private final byte[] content = this.getContent();

            private byte[] getContent() {
                StringBuilder sb = new StringBuilder();
                for (Pair pair : form) {
                    try {
                        String value;
                        String name = URLEncoder.encode((String)pair.first, Charsets.UTF8.name());
                        String string = value = pair.second == null ? null : URLEncoder.encode((String)pair.second, Charsets.UTF8.name());
                        if (sb.length() > 0) {
                            sb.append("&");
                        }
                        sb.append(name);
                        if (value == null) continue;
                        sb.append("=");
                        sb.append(value);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException(e);
                    }
                }
                return sb.toString().getBytes(this.getContentType().getCharset());
            }

            @Override
            public ContentType getContentType() {
                return ContentType.APPLICATION_FORM_URLENCODED;
            }

            @Override
            public long getContentLength() {
                return this.content.length;
            }

            @Override
            public void write(OutputStream outputStream) throws IOException {
                if (MAS.DEBUG) {
                    Log.d((String)"MAS", (String)String.format("Content: %s", new String(this.getContent())));
                }
                outputStream.write(this.content);
            }

            @Override
            public Object getContentAsJsonValue() {
                JSONObject jsonObject = new JSONObject();
                for (Pair pair : form) {
                    if (pair.first == null) continue;
                    try {
                        JSONArray jsonArray = (JSONArray)jsonObject.opt((String)pair.first);
                        if (jsonArray == null) {
                            jsonArray = new JSONArray();
                            jsonObject.put((String)pair.first, (Object)jsonArray);
                        }
                        if (pair.second == null) continue;
                        jsonArray.put(pair.second);
                    }
                    catch (JSONException jSONException) {}
                }
                return jsonObject;
            }
        };
    }

    static MASRequestBody jwtClaimsBody(final MASClaims claims, final PrivateKey privateKey, final MASRequestBody body) {
        return new MASRequestBody(){

            @Override
            public ContentType getContentType() {
                return ContentType.TEXT_PLAIN;
            }

            @Override
            public long getContentLength() {
                return -1L;
            }

            @Override
            public void write(OutputStream outputStream) throws IOException {
                MASClaimsBuilder builder = new MASClaimsBuilder(claims);
                builder.claim("content", body.getContentAsJsonValue());
                if (body.getContentType() != null) {
                    builder.claim("content-type", body.getContentType().getMimeType());
                }
                MASClaims masClaims = builder.build();
                String compactJws = null;
                try {
                    compactJws = privateKey == null ? MAS.sign(masClaims) : MAS.sign(masClaims, privateKey);
                }
                catch (MASException e) {
                    throw new IOException(e);
                }
                outputStream.write(compactJws.getBytes(this.getContentType().getCharset()));
            }
        };
    }

    public static MASRequestBody multipartBody(final MultiPart multipart, final MASProgressListener progressListener) throws MASException {
        if (multipart == null) {
            throw new MASException(new Throwable("Multipart is null"));
        }
        try {
            return new MASRequestBody(){
                public final String twoHyphens = "--";
                public final String lineEnd = "\r\n";
                public String multipart_separator = "--" + MASConstants.MAS_BOUNDARY + "\r\n";
                private final byte[] content = this.getContent();

                private byte[] getContent() throws MASException, IOException {
                    StringBuilder formParams = new StringBuilder();
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    if (!multipart.getFormFields().isEmpty()) {
                        for (Map.Entry entry : multipart.getFormFields().entrySet()) {
                            formParams.append(this.multipart_separator);
                            formParams.append("Content-Disposition: form-data; name=\"" + (String)entry.getKey() + "\"" + "\r\n");
                            formParams.append("\r\n");
                            formParams.append((String)entry.getValue());
                            formParams.append("\r\n");
                        }
                        output.write(formParams.toString().getBytes());
                    }
                    for (MASFileObject mASFileObject : multipart.getFilePart()) {
                        byte[] bytes = mASFileObject.getFileBytes();
                        Uri uri = mASFileObject.getFileUri();
                        try {
                            if (bytes == null) {
                                if (uri != null) {
                                    bytes = FileUtils.getBytesFromUri(uri);
                                } else if (bytes == null) {
                                    bytes = FileUtils.getBytesFromPath(mASFileObject.getFilePath());
                                }
                            }
                            output.write(this.multipart_separator.getBytes());
                            output.write(("Content-Disposition: form-data; name=\"" + mASFileObject.getFieldName() + "\"; filename=\"" + mASFileObject.getFileName() + "\"" + "\r\n").getBytes());
                            output.write(("Content-Type: " + mASFileObject.getFileType() + "\r\n").getBytes());
                            output.write("Content-Transfer-Encoding: binary\r\n".getBytes());
                            output.write("\r\n".getBytes());
                            output.write(bytes);
                            output.write("\r\n".getBytes());
                            output.write("\r\n".getBytes());
                        }
                        catch (IOException e) {
                            progressListener.onError(new MAGError(e));
                            throw new MASException(e);
                        }
                    }
                    output.write(("--" + MASConstants.MAS_BOUNDARY + "--" + "\r\n").getBytes());
                    return output.toByteArray();
                }

                @Override
                public ContentType getContentType() {
                    return ContentType.MULTIPART_FORM_DATA;
                }

                @Override
                public long getContentLength() {
                    return this.content.length + this.multipart_separator.length();
                }

                @Override
                public void write(OutputStream outputStream) throws IOException {
                    ByteArrayInputStream stream = new ByteArrayInputStream(this.content);
                    byte[] buf = new byte[1024];
                    int progress = 0;
                    int bytesRead = 0;
                    BufferedInputStream bufInput = new BufferedInputStream(stream);
                    while ((bytesRead = bufInput.read(buf)) != -1) {
                        outputStream.write(buf, 0, bytesRead);
                        outputStream.flush();
                        progress += bytesRead;
                        if (progressListener == null) continue;
                        progressListener.onProgress("" + progress * 100 / this.content.length);
                    }
                    outputStream.write(this.multipart_separator.getBytes());
                    outputStream.flush();
                    if (progressListener != null) {
                        progressListener.onComplete();
                    }
                    outputStream.close();
                }
            };
        }
        catch (MASException | IOException e) {
            if (progressListener != null) {
                progressListener.onError(new MAGError(e));
            }
            throw new MASException(e);
        }
    }
}

